unit uLogView;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ComCtrls, ExtCtrls, StdCtrls;

type
  TLogView = class(TForm)
    Panel1: TPanel;
    ListView1: TListView;
    btnRefresh: TButton;
    btnClose: TButton;
    pMark: TPanel;
    btnTag: TButton;
    btnMonat: TButton;
    btnGesamt: TButton;
    btnNichts: TButton;
    pMinuten: TPanel;
    procedure FormShow(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure btnRefreshClick(Sender: TObject);
    procedure btnCloseClick(Sender: TObject);
    procedure ListView1Change(Sender: TObject; Item: TListItem;
      Change: TItemChange);
    procedure btnGesamtClick(Sender: TObject);
    procedure btnMonatClick(Sender: TObject);
    procedure btnTagClick(Sender: TObject);
    procedure ListView1ColumnClick(Sender: TObject; Column: TListColumn);
    procedure btnNichtsClick(Sender: TObject);
  private
    procedure log_view;
    { Private-Deklarationen }
    procedure WMSysCommand(var Message: TWMSysCommand);
      Message WM_SYSCOMMAND;
  public
    { Public-Deklarationen }
  end;


var
  LogView: TLogView;
  SortColumn : integer;
  ParamSort: Integer = 1;

implementation

uses uMainForm;

{$R *.DFM}

procedure TLogView.WMSysCommand(var Message: TWMSysCommand);
begin
  if Message.CmdType AND $FFF0 = SC_MINIMIZE then
    Close
  else
    inherited;
end;

procedure TLogView.FormShow(Sender: TObject);
var
  Owner : hWnd;
begin
  Owner := GetWindow(Handle, GW_OWNER);
  ShowWindow(Owner, SW_HIDE);

  (* Logdatei laden *)
  log_view;
end;

procedure TLogView.log_view;
var f: TextFile;
  line: String;
  p: Integer;
  eintrag: TListItem;
begin
  (* prfen, ob Logdatei existiert *)
  if not FileExists(MainForm.log_file) then begin
    ShowMessage('Es existiert keine Logdate.');
    Exit;
  end;

  (* Datei ffnen *)
  AssignFile(f, MainForm.log_file);
  Reset(f);

  repeat
    (* neuer Eintrag erstellen *)
    eintrag := ListView1.Items.Add;

    Readln(f, line);

    (* 1. Feld: Wochentag *)
    p := Pos(';', line);
    eintrag.Caption := Copy(line, 0, p-1);
    line := Copy(line, p+1, Length(line));

    (* 2. Feld: Datum *)
    p := Pos(';', line);
    eintrag.SubItems.Add(Copy(line, 0, p-1));
    line := Copy(line, p+1, Length(line));

    (* 3. Feld: Start *)
    p := Pos(';', line);
    eintrag.SubItems.Add(Copy(line, 0, p-1));
    line := Copy(line, p+1, Length(line));

    (* 4. Feld: Stopp *)
    p := Pos(';', line);
    eintrag.SubItems.Add(Copy(line, 0, p-1));
    line := Copy(line, p+1, Length(line));

    (* 5. Feld: Dauer *)
    p := Pos(';', line);
    eintrag.SubItems.Add(Copy(line, 0, p-1));
    line := Copy(line, p+1, Length(line));

    (* 6. Feld: Kommentar *)
    eintrag.SubItems.Add(line)
  until eof(f);


  (* Datei schlieen *)
  CloseFile(f);

end;

procedure TLogView.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  ListView1.Items.Clear;
end;

procedure TLogView.btnRefreshClick(Sender: TObject);
begin
  ListView1.Items.Clear;
  log_view;
end;

procedure TLogView.btnCloseClick(Sender: TObject);
begin
  Close;
end;

procedure TLogView.ListView1Change(Sender: TObject; Item: TListItem;
  Change: TItemChange);
var
  item1 : TListItem;
  s: String;
  mark_dauer: TDateTime;
  counter: Integer;
  std, min, dummy: Word;
begin
   counter := 0;
   item1 := ListView1.Selected;

   if (item1 = nil) then begin
        pMark.Caption := 'Markiert: 00:00:00, 0 Eintrge';
        pMinuten.Caption := 'angefangene Minuten: 0';
        Exit;
   end;

   s := item1.SubItems[3];
   mark_dauer := StrToTime(s);
   counter := counter + 1;

   item1 := ListView1.GetNextItem(item1, sdBelow, [isSelected]);

   while (item1 <> nil) do begin
     s := item1.SubItems[3];
     mark_dauer := mark_dauer + StrToTime(s);
     counter := counter + 1;

     item1 := ListView1.GetNextItem(item1, sdBelow, [isSelected]);
   end;


   if (counter > 1) then
       pMark.Caption := 'Markiert: ' + TimeToStr(mark_dauer)
                     + ', ' + IntToStr(counter) + ' Eintrge'
   else
       pMark.Caption := 'Markiert: ' + TimeToStr(mark_dauer)
                     + ', ' + IntToStr(counter) + ' Eintrag';


   DecodeTime(mark_dauer, std, min, dummy, dummy);
   min := std * 60 + min;
   min := min + counter;

   pMinuten.Caption := 'angefangene Minuten: ' + IntToStr(min);
end;

procedure TLogView.btnGesamtClick(Sender: TObject);
var i: Integer;
begin
 for i:=0 to (ListView1.Items.Count-1) do ListView1.Items[i].Selected := true;
end;

procedure TLogView.btnMonatClick(Sender: TObject);
var i : Integer;
    monat1,monat2,dummy: Word;
    s: String;
begin
  btnNichtsClick(Sender);

  for i := 0 to ListView1.Items.Count-1 do begin
    s := ListView1.Items[i].SubItems[0];
    DecodeDate(StrToDate(s), dummy, monat1, dummy);
    DecodeDate(Now, dummy, monat2, dummy);

    (* prfen, ob es der aktuelle Monat ist *)
    if (monat1 = monat2) then
      ListView1.Items[i].Selected := true;

  end;
end;


procedure TLogView.btnTagClick(Sender: TObject);
var i: Integer;
    s: String;
begin
  btnNichtsClick(Sender);
  for i := 0 to ListView1.Items.Count-1 do begin
    (* nach dem Datum prfen *)
    s := ListView1.Items[i].SubItems[0];
    if (StrToDate(s) = Date) then
      ListView1.Items[i].Selected := true;
  end;
end;

function MySortProc(Item1, Item2: TListItem; ParamSort: integer): integer; stdcall;
var T1,T2 : string;
begin
  case SortColumn of
    0 : begin
          T1:=Item1.Caption;
          T2:=Item2.Caption;
        end
    else begin
          T1:=Item1.SubItems[SortColumn-1];
          T2:=Item2.SubItems[SortColumn-1];
        end
  end;
  Result := ParamSort * lstrcmp(PChar(T1),PChar(T2));
end;


procedure TLogView.ListView1ColumnClick(Sender: TObject;
  Column: TListColumn);
begin
  SortColumn:=Column.Index;
  ParamSort := ParamSort * (-1);
  ListView1.CustomSort(@MySortProc, ParamSort);
end;

procedure TLogView.btnNichtsClick(Sender: TObject);
var i: Integer;
begin
  for i := 0 to ListView1.Items.Count-1 do begin
    (* erstmal abwhlen *)
    ListView1.Items[i].Selected := false;
  end;
end;

end.
