unit uMainForm;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, Menus, RasApi, ShellApi;

const
  WM_TASKBAREVENT = WM_USER + 20;

type
  TLogEintrag = record
    Wochentag : String[3];
    Datum : String;
    Start : String;
    Stopp : String;
    Dauer : String;
    Kommentar: String;
end;

type
  TMainForm = class(TForm)
    Panel1: TPanel;
    pJetzt: TPanel;
    Panel3: TPanel;
    Timer1: TTimer;
    btnStart: TButton;
    btnStopp: TButton;
    PopupMenu1: TPopupMenu;
    Beenden1: TMenuItem;
    LogdateiBetrachter1: TMenuItem;
    N1: TMenuItem;
    GroupBox1: TGroupBox;
    pTag: TPanel;
    GroupBox2: TGroupBox;
    pMonat: TPanel;
    GroupBox3: TGroupBox;
    pGesamt: TPanel;
    Info1: TMenuItem;
    procedure btnStartClick(Sender: TObject);
    procedure btnStoppClick(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure Beenden1Click(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure LogdateiBetrachter1Click(Sender: TObject);
    function  log_file: String;
    procedure Info1Click(Sender: TObject);
  private
    Start,Stopp: TDateTime;
    Dauer: TDateTime;
    Aktiv: Boolean;
    Kommentar: String;
    Online: Boolean;
    NotifyIconData: TNotifyIconData;
    Icon_nicht_Aktiv: THandle;
    Icon_Aktiv: THandle;
    auto_save: Integer;

    procedure ZeigeDauer;
    procedure log_Speichern;
    procedure log_auto_speichern;
    procedure log_wiederherstellen;
    function  log_tmpfile: String;
    function  log_tag: TDateTime;
    function  log_monat: TDateTime;
    function  log_gesamt: TDateTime;
    { Private-Deklarationen }
    procedure TaskbarEvent(var Msg: TMessage);
      Message WM_TASKBAREVENT;
    procedure WMSysCommand(var Message: TWMSysCommand);
      Message WM_SYSCOMMAND;
  public
    { Public-Deklarationen }
  end;

var
  MainForm: TMainForm;

implementation

uses uLogView, uInfoForm;

{$R *.DFM}


procedure TMainForm.TaskbarEvent(var Msg: TMessage);
var Point: TPoint;
begin
  { Die WM_TaskbarEvent-Message "Msg" gibt in Msg.LParam
    das genaue Ereignis an. Msg.LParam kann folgende Werte fr
    Mausereignisse annehmen:

    WM_MouseMove
    WM_LButtonDown
    WM_LButtonUp
    WM_LButtonDblClk
    WM_RButtonDown
    WM_RButtonUp
    WM_RButtonDblClk }
    if (Msg.LParam = WM_LButtonDown) then begin
      if Visible then Hide
      else begin
         Show;
         Application.BringToFront;
         SetFocus;
      end;
    end
    else if (Msg.LParam = WM_RButtonDown) then begin
      GetCursorPos(Point);
      PopupMenu1.Popup(Point.X, Point.Y);
    end;
end;

procedure TMainForm.btnStartClick(Sender: TObject);
begin
  (* zuerst Dauer leeren *)
  Dauer := 0;

  (* Die Variable Aktiv auf true setzen *)
  Aktiv := true;

  (* Die Uhrzeit der Aktivierung merken *)
  Start := Now;

  (* Kommentar setzen *)
  Kommentar := 'manuell';

  (* den Startbutton ausschalten,
     die anderen Buttons einschalten *)
  btnStart.Enabled := false;
  btnStopp.Enabled := true;

  (* TrayIcon ndern *)
  NotifyIconData.hIcon := Icon_Aktiv;
  Shell_NotifyIcon(NIM_MODIFY, @NotifyIconData);

  (* auto_save initialisieren *)
  auto_save := 0;
end;

procedure TMainForm.btnStoppClick(Sender: TObject);
begin
  (* Varible Aktiv auf false setzen! *)
  Aktiv := false;

  (* Zeitpunkt merken *)
  Stopp := Now;

  (* jetzt die Daten in eine Logdatei speichern *)
  log_Speichern;

  (* den Startbutton wieder anmachen *)
  btnStart.Enabled := true;
  btnStopp.Enabled := false;

  (* unter Umstnden Online := true....
     damit die DF-Routine in Timer1Timer() tut *)

  (* TrayIcon ndern *)
  NotifyIconData.hIcon := Icon_nicht_Aktiv;
  Shell_NotifyIcon(NIM_MODIFY, @NotifyIconData);
end;

procedure TMainForm.Timer1Timer(Sender: TObject);
var rasconnArray: TRasConn;
    i, lpcb: Integer;
    lpcConnections: Integer;
begin
  (* DF-Verbindung suchen... *)
  FillChar(rasconnArray, SizeOf(rasconnArray), 0);
  rasconnArray.dwSize := SizeOf(rasconnArray);
  lpcb := SizeOf(rasconnArray);
  lpcConnections := 0;
  i := RasEnumConnections(@rasconnArray, lpcb, lpcConnections);

  (* neue Verbindung *)
  if (i = 0) and (lpcConnections > 0) and not Online then begin
    (* Online auf true setzen! *)
    Online := true;

    (* wenn Stoppuhr nicht aktiv ist *)
    if not Aktiv then btnStartClick(nil)
    (* wenn Stoppuhr aktiv ist, dann *)
    else  if Aktiv then begin
        btnStoppClick(nil);
        btnStartClick(nil);
    end;

    (* Kommentar setzen *)
    Kommentar := 'DF: ' + rasconnArray.szEntryName;
  end;

  (* Verbindung besteht nicht mehr *)
  if (i = 0) and (lpcConnections = 0) and Online then begin
    (* zuerst online auf false setzen *)
    Online := false;

    (* Stoppuhr stoppen, falls sie aktiv ist *)
    if Aktiv then btnStoppClick(nil);
  end;


  (* folgender Teil nur ausfhren, wenn Stoppuhr aktiv ist *)
  if not Aktiv then Exit;

  (* Dauer hochzhlen *)
  Dauer := Dauer + StrToTime('00:00:01');

  (* Daten anzeigen lassen *)
  ZeigeDauer;

  (* Autospeichern-Funktion
     - jede Minute *)
  if auto_save > 59 then begin
    log_auto_speichern;
    auto_save := 0;
  end else auto_save := auto_save + 1;


end;

procedure TMainForm.ZeigeDauer;
begin
  (* den String anzeigen *)
  pJetzt.Caption := TimeToStr(Dauer);

  (* Dauer nur dazuzhlen, wenn die Stoppuhr luft... *)
  if Aktiv then begin
      pTag.Caption := TimeToStr(log_tag + Dauer);
      pMonat.Caption := TimeToStr(log_monat + Dauer);
      pGesamt.Caption := TimeToStr(log_gesamt + Dauer);
  end else begin
      (* Dauer wurde schon gespeichert und darf nicht mehr
         hinzugezhlt werden *)
      pTag.Caption := TimeToStr(log_tag);
      pMonat.Caption := TimeToStr(log_monat);
      pGesamt.Caption := TimeToStr(log_gesamt);
  end;
end;

function TMainForm.log_file: String;
var s: String;
begin
 s := Application.ExeName;
 s := Copy(s, 0, Length(s)-3);
 s := s + 'log';

 Result := s;
end;

function TMainForm.log_tmpfile: String;
var s: String;
begin
 s := Application.ExeName;
 s := Copy(s, 0, Length(s)-3);
 s := s + 'tmp';

 Result := s;
end;

procedure TMainForm.log_Speichern;
var logeintrag: TLogEintrag;
    s: String;
    i: Integer;
    f: Textfile;
begin
  (* erstmal ein Logeintrag erstellen *)
  i := DayOfWeek(Start);
  case i of
    1: s := 'So.';
    2: s := 'Mo.';
    3: s := 'Di.';
    4: s := 'Mi.';
    5: s := 'Do.';
    6: s := 'Fr.';
    7: s := 'Sa.';
  end;

  logeintrag.Wochentag := s;
  logeintrag.Datum := DateToStr(Start);
  logeintrag.Start := TimeToStr(Start);
  logeintrag.Stopp := TimeToStr(Stopp);
  logeintrag.Dauer := TimeToStr(Dauer);
  logeintrag.Kommentar := Kommentar;

  (* jetzt eine Datei ffnen *)

  AssignFile(f, log_file);
  if not FileExists(log_file) then Rewrite(f)
                              else Append(f);

  s := logeintrag.Wochentag + ';'
     + logeintrag.Datum + ';'
     + logeintrag.Start + ';'
     + logeintrag.Stopp + ';'
     + logeintrag.Dauer + ';'
     + logeintrag.Kommentar;
  Writeln(f, s);

  (* Datei schlieen *)
  CloseFile(f);

  (* Jetzt eine eventuell vorhandene log_tmpfile lschen *)
  if FileExists(log_tmpfile) then
    if not DeleteFile(log_tmpfile) then
      if not DeleteFile(log_tmpfile) then
        ShowMessage('Konnte ' + log_tmpfile + ' nicht lschen!');
end;

procedure TMainForm.FormShow(Sender: TObject);
var
  Owner : hWnd;
begin
  Owner := GetWindow(Handle, GW_OWNER);
  ShowWindow(Owner, SW_HIDE);

  ZeigeDauer;
end;

procedure TMainForm.WMSysCommand(var Message: TWMSysCommand);
begin
  if Message.CmdType AND $FFF0 = SC_MINIMIZE then
    Hide
  else
    inherited;
end;


procedure TMainForm.FormCreate(Sender: TObject);
begin
  (* Icon-Handle bekommen *)
  Icon_Aktiv       := ExtractIcon(HInstance, pChar(Application.ExeName), 1);
  Icon_nicht_Aktiv := ExtractIcon(HInstance, pChar(Application.ExeName), 2);

  (* Trayicon erstellen *)
  NotifyIconData.cbSize := SizeOf(NotifyIconData);
  NotifyIconData.Wnd := Handle;
  NotifyIconData.uID := 1;
  NotifyIconData.uFlags := NIF_MESSAGE + NIF_ICON + NIF_TIP;
  NotifyIconData.uCallbackMessage := WM_TASKBAREVENT;
  NotifyIconData.hIcon := Icon_nicht_Aktiv;
  NotifyIconData.szTip := ' Online Stop Watch ';
  Shell_NotifyIcon(NIM_ADD, @NotifyIconData);

  (* log-datei eventuell wiederherstellen *)
  if FileExists(log_tmpfile) then log_wiederherstellen;
end;

procedure TMainForm.FormDestroy(Sender: TObject);
begin
  (* TrayIcon zerstren *)
  Shell_NotifyIcon(NIM_DELETE, @NotifyIconData);
end;

procedure TMainForm.Beenden1Click(Sender: TObject);
begin
  Close;
end;

function TMainForm.log_tag : TDateTime;
var f: Textfile;
   line: String;
   s: String;
   p: Integer;
   dauer_tag: TDateTime;
begin
  dauer_tag := 0;
  Result := dauer_tag;

  (* erst prfen, ob eine Logdatei existiert *)
  if not FileExists(log_file) then Exit;

  (* Logdatei ffnen *)
  AssignFile(f, log_file);
  Reset(f);

  repeat
    Readln(f, line);

    (* als erstes Feld: Wochentag -> nicht wichtig *)
    p := Pos(';', line);
    line := Copy(line, p+1, Length(line));

    (* als 2. Feld: Datum.... das, was wir suchen *)
    p := Pos(';', line);
    s := Copy(line, 0, p-1);
    line := Copy(line, p+1, Length(line));

    (* prfen, ob das Datum mit dem heutigen bereinstimmt *)
    if (DateToStr(Now) <> s) then Continue;

    (* als 3. Feld: Start *)
    p := Pos(';', line);
    line := Copy(line, p+1, Length(line));

    (* als 4. Feld: Stopp *)
    p := Pos(';', line);
    line := Copy(line, p+1, Length(line));

    (* als 5. Feld: Dauer.... gekauft *)
    p := Pos(';', line);
    s := Copy(line, 0, p-1);

    (* jetzt mssen wir s aufspalten, denn
       es liegt in der Form '00:00:00' vor.
       Es muss dazuaddiert werden! *)
    dauer_tag := dauer_tag + StrToTime(s);

    (* das war's vorerst *)
  until eof(f);

  (* dauer_tag wieder zurckwandeln *)

  Result := dauer_tag;

  (* und jetzt die Datei wieder schlieen! *)
  CloseFile(f);
end;

function TMainForm.log_monat : TDateTime;
var f: Textfile;
   line: String;
   s: String;
   p: Integer;
   dauer_monat: TDateTime;
   monat,monat2,dummy: Word;

begin
  dauer_monat := 0;
  Result := dauer_monat;

  (* erst prfen, ob eine Logdatei existiert *)
  if not FileExists(log_file) then Exit;

  (* Logdatei ffnen *)
  AssignFile(f, log_file);
  Reset(f);

  repeat
    Readln(f, line);

    (* als erstes Feld: Wochentag -> nicht wichtig *)
    p := Pos(';', line);
    line := Copy(line, p+1, Length(line));

    (* als 2. Feld: Datum.... das, was wir suchen *)
    p := Pos(';', line);
    s := Copy(line, 0, p-1);
    line := Copy(line, p+1, Length(line));

    (* prfen, ob der Monat mit dem heutigen bereinstimmt *)
    DecodeDate(StrToDate(s),dummy,monat,dummy);
    DecodeDate(Now,dummy,monat2,dummy);

    if (monat <> monat2) then Continue;

    (* als 3. Feld: Start *)
    p := Pos(';', line);
    line := Copy(line, p+1, Length(line));

    (* als 4. Feld: Stopp *)
    p := Pos(';', line);
    line := Copy(line, p+1, Length(line));

    (* als 5. Feld: Dauer.... gekauft *)
    p := Pos(';', line);
    s := Copy(line, 0, p-1);

    (* jetzt mssen wir s aufspalten, denn
       es liegt in der Form '00:00:00' vor.
       Es muss dazuaddiert werden! *)
    dauer_monat := dauer_monat + StrToTime(s);

    (* das war's vorerst *)
  until eof(f);

  (* dauer_tag wieder zurckwandeln *)

  Result := dauer_monat;

  (* und jetzt die Datei wieder schlieen! *)
  CloseFile(f);

end;

function TMainForm.log_gesamt: TDateTime;
var f: Textfile;
   line: String;
   s: String;
   p: Integer;
   dauer_gesamt: TDateTime;
begin
  dauer_gesamt := 0;
  Result := dauer_gesamt;

  (* erst prfen, ob eine Logdatei existiert *)
  if not FileExists(log_file) then Exit;

  (* Logdatei ffnen *)
  AssignFile(f, log_file);
  Reset(f);

  repeat
    Readln(f, line);

    (* als erstes Feld: Wochentag -> nicht wichtig *)
    p := Pos(';', line);
    line := Copy(line, p+1, Length(line));

    (* als 2. Feld: Datum *)
    p := Pos(';', line);
    line := Copy(line, p+1, Length(line));

    (* als 3. Feld: Start *)
    p := Pos(';', line);
    line := Copy(line, p+1, Length(line));

    (* als 4. Feld: Stopp *)
    p := Pos(';', line);
    line := Copy(line, p+1, Length(line));

    (* als 5. Feld: Dauer.... gekauft *)
    p := Pos(';', line);
    s := Copy(line, 0, p-1);

    (* jetzt mssen wir s aufspalten, denn
       es liegt in der Form '00:00:00' vor.
       Es muss dazuaddiert werden! *)
    dauer_gesamt := dauer_gesamt + StrToTime(s);

    (* das war's vorerst *)
  until eof(f);

  (* dauer_tag wieder zurckwandeln *)

  Result := dauer_gesamt;

  (* und jetzt die Datei wieder schlieen! *)
  CloseFile(f);
end;


procedure TMainForm.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  (* wenn gerade eine Aufzeichnung aktiv ist,
     dann diese erst stoppen *)
  if Aktiv then btnStoppClick(Sender);

end;

procedure TMainForm.LogdateiBetrachter1Click(Sender: TObject);
begin
  LogView.Show;
end;

procedure TMainForm.Info1Click(Sender: TObject);
begin
  AboutBox.Show;
end;

procedure TMainForm.log_auto_speichern;
var logeintrag: TLogEintrag;
    s: String;
    i: Integer;
    f: Textfile;
begin
  (* erstmal ein Logeintrag erstellen *)
  i := DayOfWeek(Start);
  case i of
    1: s := 'So.';
    2: s := 'Mo.';
    3: s := 'Di.';
    4: s := 'Mi.';
    5: s := 'Do.';
    6: s := 'Fr.';
    7: s := 'Sa.';
  end;

  logeintrag.Wochentag := s;
  logeintrag.Datum := DateToStr(Start);
  logeintrag.Start := TimeToStr(Start);
  logeintrag.Stopp := TimeToStr(Now);
  logeintrag.Dauer := TimeToStr(Dauer);
  logeintrag.Kommentar := Kommentar;

  (* neue Datei erstellen bzw. berschreiben *)

  AssignFile(f, log_tmpfile);
  Rewrite(f);

  s := logeintrag.Wochentag + ';'
     + logeintrag.Datum + ';'
     + logeintrag.Start + ';'
     + logeintrag.Stopp + ';'
     + logeintrag.Dauer + ';'
     + logeintrag.Kommentar;
  Writeln(f, s);

  (* Datei schlieen *)
  CloseFile(f);

end;

procedure TMainForm.log_wiederherstellen;
var tmp,f: TextFile;
    line: String;
begin
  (* Erst prfen, ob tmp-Datei exisitert *)
  if not FileExists(log_tmpfile) then Exit;

  (* Dateien ffnen *)
  AssignFile(f, log_file);
  AssignFile(tmp, log_tmpfile);

  Append(f);
  Reset(tmp);

  (* Zeile von tmp lesen *)
  ReadLn(tmp, line);

  (* Die Zeile in f hinzufgen *)
  Writeln(f, line);

  (* Dateien schlieen *)
  CloseFile(f);
  CloseFile(tmp);

  (* tmp-Datei lschen *)
  if not DeleteFile(log_tmpfile) then
    if not DeleteFile(log_tmpfile) then
       ShowMessage('Konnte ' + log_tmpfile + ' nicht lschen!');
end;

end.
