/*
 * Node
 *
 * Andreas Dangel <it04109@informatik.ba-stuttgart.de>
 * 16.07.2005
 * 
 * Die Klasse Node reprsentiert ein Knoten bzw. ein Blatt
 * im Huffman-Baum.
 */
public class Node {

    /* linker Nachfolger
     * wenn kein Nachfolger existiert (Blatt): null
     * Links entspricht im Baum einer 0
     */
    private Node leftChild;
    
    /* rechter Nachfolger
     * wenn kein Nachfolger existiert (Blatt): null
     * Rechts entspricht im Baum einer 1
     */
    private Node rightChild;
    
    /* Vorgnger
     * wenn kein Vorgnger existiert (Wurzelknoten): null 
     */
    private Node parent;
    
    /*
     * Speichert bei einem Blatt das zugehrige Datenbyte.
     * Der Wert ist zwischen 0 und 255.
     */
    private int data;

    /*
     * speichert die Hufigkeit
     */
    private long count;
    
    /*
     * Konstruktoren
     */
    public Node() {
        data = -1;
        leftChild = null;
        rightChild = null;
        parent = null;
    }
    
    public Node(int d) {
        super();
        data = d;
    }
    
    
    /*
     * Zugriffsmethoden auf die Eigenschaften
     */
    public void setData(int d) {
        data = d;
    }
    
    public int getData() {
        return data;
    }

    public void setCount(long l) {
        count = l;
    }
    
    public long getCount() {
        return count;
    }
    
    public void setParent(Node p) {
        parent = p;
    }
    
    public Node getParent() {
        return parent;
    }
    
    public void setLeftChild(Node l) {
        leftChild = l;
    }
    
    public Node getLeftChild() {
        return leftChild;
    }
    
    public void setRightChild(Node r) {
        rightChild = r;
    }
    
    public Node getRightChild() {
        return rightChild;
    }
    
    

    /*
     * toString(int):
     * gibt einen String zurck, der den Baum unterhalb
     * dieses Knotens enthlt. Dabei wird jede Ebene
     * weiter eingerckt. Die Anzahl der Einrckungen wird der Methode
     * als Parameter bergeben (indent).
     * 
     */
    public String toString(int indent) {
        // Rckgabe-String
	String ret = "";

	// Einrcken
        for(int i = 0; i < indent; i++) {
        	ret = "  " + ret;
        }
    	
        // Ebene ausgeben
        ret += indent + ": ";

	// Linkes Kind/Rechtes Kind ausgeben
    	if (parent != null) {
    		if (this == parent.getLeftChild()) ret += "L-";
    		else ret += "R-";
    	}

        // Typ ausgeben: Ist der Knoten ein Blatt?
        if (leftChild == null && rightChild == null) {
            ret += "Blatt: \"";
	    // dann auch das Zeichen ausgeben
            if (data > 31) ret += (char) data;
            else ret += ".";
            
            ret += "\"\n";
        } else {
            ret += "Knoten\n";
	    // Wenn Knoten, dann die gleiche Methode bei den
	    // Kindern aufrufen
            if (leftChild != null)  ret += leftChild.toString(indent + 1);
            if (rightChild != null) ret += rightChild.toString(indent + 1);            
        }
        
	// den Ausgabe-String zurckgeben
        return ret;
    }
    
}

