/*
 * RawInteger
 * 
 * Andreas Dangel <it04109@informatik.ba-stuttgart.de>
 * 15.07.2005
 *
 * Die Klasse RawInteger ist dazu da, einen Integer in
 * 4 Bytes umzuwandeln und zurck; hnlich wie DataInputStream
 * oder DataOutputStream.
 * 
 */
public class RawInteger {

	// Der Integer-Wert, der umgewandelt werden kann
    private int value;

    /*
     * Konstruktoren
     */
    public RawInteger() {
        value = 0;
    }

    public RawInteger(int i) {
        value = i;
    }

    public RawInteger(Integer i) {
        value = i.intValue();
    }

    public RawInteger(char[] raw) {
        value = parseRawData(raw);
    }

    /*
     * Gibt den Integer-Wert zurck
     */
    public int intValue() {
        return value;
    }

    /*
     * Gibt den Integer-Wert als ein Char-Array
     * mit 4 Elementen zurck (entspricht den 4 Bytes)
     * siehe statische Methode: getRawData(int i)
     */
    public char[] getRawData() {
        return getRawData(value);
    }

    /*
     * Wandelt einen Integer-Wert
     * in vier Zeichen als Char-Array (4 Bytes) um.
     */
    public static char[] getRawData(int i) {

        char[] raw = new char[4];

        // Binrreprsentation
        StringBuffer binary = new StringBuffer(Integer.toBinaryString(i));

        // fhrende Nullen hinzufgen
        while (binary.length() < 32) {
            binary.insert(0, '0');
        }

        // Jetzt die Binrreprsentation zerlegen
        raw[0] = (char) Integer.parseInt(binary.substring( 0,  8), 2);
        raw[1] = (char) Integer.parseInt(binary.substring( 8, 16), 2);
        raw[2] = (char) Integer.parseInt(binary.substring(16, 24), 2);
        raw[3] = (char) Integer.parseInt(binary.substring(24, 32), 2);


        return raw;
    }

    /*
     * Wandelt einen Integer, der aus einzelnen Bytes besteht,
     * in eine Integerzahl.
     * Umkehrfunktion zu getRawData(int)
     */
    public static int parseRawData(char[] raw) {
        StringBuffer rawString = new StringBuffer();

        for (int i = 0; i < raw.length && i < 4; i++) {
            StringBuffer b = new StringBuffer(Integer.toBinaryString(raw[i]));
	    // fhrende Nullen wieder hinzufgen
            while (b.length() < 8) {
                b.insert(0, '0');
            }

            rawString.append(b);
        }

        // es wird long verwendet, damit prinzipiell auch
        // negative int-Zahlen verwendet werden knnen
        // siehe auch: Integer.toBinaryString(int)
        return (int) Long.parseLong(rawString.toString(), 2);
    }



}
