/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class Huffman {
    public static final int ACTION_NOTHING = 0;
    public static final int ACTION_COMPRESS = 1;
    public static final int ACTION_DECOMPRESS = 2;

    public static void main(String[] stringArray) {
        Object object;
        if (stringArray.length < 1) {
            Huffman.show_help();
        }
        boolean bl = false;
        boolean bl2 = false;
        int n = 0;
        Object object2 = null;
        Object object3 = null;
        String string = null;
        File file = null;
        File file2 = null;
        for (int i = 0; i < stringArray.length; ++i) {
            object = stringArray[i];
            if (((String)object).length() == 1 && n == 0) {
                if (((String)object).charAt(0) == 'c') {
                    n = 1;
                    continue;
                }
                if (((String)object).charAt(0) == 'd') {
                    n = 2;
                    continue;
                }
                Huffman.show_error("invalid action");
                continue;
            }
            if (((String)object).charAt(0) == '-' && n == 0) {
                if (((String)object).length() == 2) {
                    if (((String)object).charAt(1) == 'x') {
                        bl = true;
                        continue;
                    }
                    if (((String)object).charAt(1) == 'y') {
                        bl2 = true;
                        continue;
                    }
                    Huffman.show_error("invalid option");
                    continue;
                }
                Huffman.show_error("invalid option");
                continue;
            }
            if (object2 == null && n != 0) {
                object2 = object;
                continue;
            }
            Huffman.show_error("too many parameters!");
        }
        if (n == 0) {
            Huffman.show_error("shall I compress or decompress?");
        }
        InputStream inputStream = System.in;
        object = System.out;
        if (object2 != null) {
            if (n == 1) {
                object3 = object2;
                string = object3 + ".huffman";
            } else if (n == 2) {
                object3 = object2;
                if (((String)object3).endsWith(".huffman")) {
                    string = ((String)object3).substring(0, ((String)object3).length() - ".huffman".length());
                } else {
                    Huffman.show_error("the input filename doesn't end with \".huffman\". is it really compressed with this program?");
                }
            }
            file = new File((String)object3);
            file2 = new File(string);
            if (!file.exists()) {
                Huffman.show_error("File \"" + (String)object3 + "\" doesn't exist");
            }
            if (file2.exists()) {
                Huffman.show_error("File \"" + string + "\" already exists");
            }
            try {
                inputStream = new FileInputStream(file);
                object = new FileOutputStream(file2);
            }
            catch (FileNotFoundException fileNotFoundException) {
                Huffman.show_error("file not found!");
            }
        }
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream((OutputStream)object);
        try {
            int n2;
            StringBuffer stringBuffer = new StringBuffer();
            HuffmanTree huffmanTree = new HuffmanTree();
            while ((n2 = bufferedInputStream.read()) != -1) {
                stringBuffer.append((char)n2);
                huffmanTree.addData(n2);
            }
            if (n == 1) {
                huffmanTree.buildTree();
                if (bl) {
                    huffmanTree.printCodetable(System.err);
                } else if (bl2) {
                    huffmanTree.printBaum(System.err);
                }
                StringBuffer stringBuffer2 = huffmanTree.createRawCodetable();
                for (int i = 0; i < stringBuffer2.length(); ++i) {
                    bufferedOutputStream.write(stringBuffer2.charAt(i));
                }
                StringBuffer stringBuffer3 = huffmanTree.encode(stringBuffer);
                for (int i = 0; i < stringBuffer3.length(); ++i) {
                    bufferedOutputStream.write(stringBuffer3.charAt(i));
                }
                bufferedOutputStream.flush();
                if (file != null) {
                    Huffman.show_status("\"" + file + "\" to \"" + file2 + "\" compressed...");
                }
                String string2 = "compression ratio: ";
                float f = (float)(stringBuffer2.length() + stringBuffer3.length()) / (float)stringBuffer.length();
                f *= 100.0f;
                f = 100.0f - f;
                f = (float)((int)f) * 10.0f / 10.0f;
                string2 = string2 + f + "%";
                Huffman.show_status(string2);
            } else if (n == 2) {
                int n3 = huffmanTree.readRawCodetable(stringBuffer);
                if (bl) {
                    huffmanTree.printCodetable(System.err);
                } else if (bl2) {
                    huffmanTree.printBaum(System.err);
                }
                StringBuffer stringBuffer4 = huffmanTree.decode(stringBuffer, n3);
                for (int i = 0; i < stringBuffer4.length(); ++i) {
                    bufferedOutputStream.write(stringBuffer4.charAt(i));
                }
                bufferedOutputStream.flush();
                if (file != null) {
                    Huffman.show_status("\"" + file + "\" to \"" + file2 + "\" decompressed...");
                }
            }
            bufferedInputStream.close();
            bufferedOutputStream.close();
            inputStream.close();
            ((OutputStream)object).close();
        }
        catch (IOException iOException) {
            Huffman.show_error(iOException.toString());
        }
    }

    private static void show_status(String string) {
        System.err.println(string);
    }

    private static void show_error(String string) {
        System.err.println("error:\n" + string + "\n");
        Huffman.show_help();
    }

    private static void show_help() {
        System.err.println("Syntax: java -jar Huffman.jar [-x|-y] {c|d} [filename]\n");
        System.err.println("   -x = print codetable");
        System.err.println("   -y = print tree");
        System.err.println("    c = compress");
        System.err.println("    d = decompress");
        System.err.println("    if no filename ist given, then stdin to stdout is compressed/decompressed");
        System.exit(1);
    }
}

