/*
 * Decompiled with CFR 0.152.
 */
import java.io.PrintStream;
import java.util.Vector;

public class HuffmanTree {
    private long[] characters = new long[256];
    private long characterscount = 0L;
    private String[] codetable = new String[256];
    private Node root = null;

    public void addData(int n) {
        if (n >= 0 && n <= 255) {
            int n2 = n;
            this.characters[n2] = this.characters[n2] + 1L;
        }
        ++this.characterscount;
    }

    public void buildTree() {
        Object object;
        Node node;
        int n;
        Vector<Object> vector = new Vector<Object>();
        Vector<Node> vector2 = new Vector<Node>();
        for (n = 0; n < 256; ++n) {
            if (this.characters[n] <= 0L) continue;
            node = new Node();
            node.setData(n);
            node.setCount(this.characters[n]);
            vector.add(node);
            vector2.add(node);
        }
        while (vector.size() > 1) {
            Node node2;
            int n2;
            Node node3 = (Node)vector.remove(0);
            for (n2 = 0; n2 < vector.size(); ++n2) {
                node2 = (Node)vector.get(n2);
                if (node2.getCount() >= node3.getCount()) continue;
                vector.remove(n2);
                vector.add(node3);
                node3 = node2;
            }
            node = (Node)vector.remove(0);
            for (n2 = 0; n2 < vector.size(); ++n2) {
                node2 = (Node)vector.get(n2);
                if (node2.getCount() >= node.getCount()) continue;
                vector.remove(n2);
                vector.add(node);
                node = node2;
            }
            object = new Node();
            ((Node)object).setCount(node3.getCount() + node.getCount());
            ((Node)object).setLeftChild(node3);
            ((Node)object).setRightChild(node);
            node3.setParent((Node)object);
            node.setParent((Node)object);
            vector.add(object);
        }
        this.root = (Node)vector.remove(0);
        for (n = 0; n < vector2.size(); ++n) {
            node = (Node)vector2.get(n);
            object = "";
            int n3 = node.getData();
            while (node.getParent() != null) {
                Node node4 = node.getParent();
                object = node4.getLeftChild() == node ? "0" + (String)object : "1" + (String)object;
                node = node4;
            }
            if (((String)object).length() == 0) {
                object = "0";
            }
            this.codetable[n3] = object;
        }
    }

    public void printCodetable(PrintStream printStream) {
        for (int i = 0; i < 256; ++i) {
            if (this.codetable[i] == null) continue;
            printStream.print(i + " [");
            if (i > 31) {
                printStream.print((char)i);
            } else {
                printStream.print(".");
            }
            printStream.println("]: " + this.codetable[i]);
        }
    }

    public StringBuffer createRawCodetable() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(RawInteger.getRawData((int)this.characterscount));
        for (int i = 0; i < 256; ++i) {
            if (this.codetable[i] == null) continue;
            String string = new String(this.codetable[i]);
            string = "1" + string;
            while (string.length() % 8 != 0) {
                string = "0" + string;
            }
            int n = (string.length() - 1) / 8 + 1;
            stringBuffer.append(RawInteger.getRawData(n));
            stringBuffer.append((char)i);
            for (int j = 0; j < n; ++j) {
                int n2 = Integer.parseInt(string.substring(j * 8, (j + 1) * 8), 2);
                stringBuffer.append((char)n2);
            }
        }
        stringBuffer.append(RawInteger.getRawData(0));
        return stringBuffer;
    }

    public int readRawCodetable(StringBuffer stringBuffer) {
        int n;
        String string;
        for (int i = 0; i < 256; ++i) {
            this.codetable[i] = null;
        }
        char[] cArray = new char[4];
        int n2 = 0;
        cArray[0] = stringBuffer.charAt(n2++);
        cArray[1] = stringBuffer.charAt(n2++);
        cArray[2] = stringBuffer.charAt(n2++);
        cArray[3] = stringBuffer.charAt(n2++);
        int n3 = RawInteger.parseRawData(cArray);
        this.characterscount = n3;
        cArray[0] = stringBuffer.charAt(n2++);
        cArray[1] = stringBuffer.charAt(n2++);
        cArray[2] = stringBuffer.charAt(n2++);
        cArray[3] = stringBuffer.charAt(n2++);
        n3 = RawInteger.parseRawData(cArray);
        while (n3 != 0) {
            char c = stringBuffer.charAt(n2++);
            string = new String();
            for (n = 0; n < n3; ++n) {
                char c2 = stringBuffer.charAt(n2++);
                if (n2 >= stringBuffer.length()) {
                    System.err.println("error: invalid file format!");
                    return n2;
                }
                String string2 = Integer.toBinaryString(c2);
                while (string2.length() % 8 != 0) {
                    string2 = "0" + string2;
                }
                string = string + string2;
            }
            string = string.substring(string.indexOf(49) + 1);
            this.codetable[c] = new String(string);
            cArray[0] = stringBuffer.charAt(n2++);
            cArray[1] = stringBuffer.charAt(n2++);
            cArray[2] = stringBuffer.charAt(n2++);
            cArray[3] = stringBuffer.charAt(n2++);
            n3 = RawInteger.parseRawData(cArray);
        }
        this.root = new Node();
        for (n3 = 0; n3 < 256; ++n3) {
            if (this.codetable[n3] == null) continue;
            Node node = this.root;
            string = this.codetable[n3];
            for (n = 0; n < string.length(); ++n) {
                if (string.charAt(n) == '0') {
                    if (node.getLeftChild() == null) {
                        node.setLeftChild(new Node());
                    }
                    node = node.getLeftChild();
                    continue;
                }
                if (node.getRightChild() == null) {
                    node.setRightChild(new Node());
                }
                node = node.getRightChild();
            }
            node.setData(n3);
        }
        return n2;
    }

    public void printBaum(PrintStream printStream) {
        printStream.println(this.root.toString(0));
    }

    public StringBuffer encode(StringBuffer stringBuffer) {
        int n;
        StringBuffer stringBuffer2 = new StringBuffer();
        StringBuffer stringBuffer3 = new StringBuffer();
        for (n = 0; n < stringBuffer.length(); ++n) {
            char c = stringBuffer.charAt(n);
            stringBuffer2.append(this.codetable[c]);
            while (stringBuffer2.length() >= 8) {
                int n2 = Integer.parseInt(stringBuffer2.substring(0, 8), 2);
                stringBuffer3.append((char)n2);
                stringBuffer2.delete(0, 8);
            }
        }
        if (stringBuffer2.length() > 0) {
            while (stringBuffer2.length() % 8 != 0) {
                stringBuffer2.append('1');
            }
            while (stringBuffer2.length() >= 8) {
                n = Integer.parseInt(stringBuffer2.substring(0, 8), 2);
                stringBuffer3.append((char)n);
                stringBuffer2.delete(0, 8);
            }
        }
        return stringBuffer3;
    }

    public StringBuffer decode(StringBuffer stringBuffer, int n) {
        int n2 = n;
        StringBuffer stringBuffer2 = new StringBuffer();
        StringBuffer stringBuffer3 = new StringBuffer();
        Node node = this.root;
        int n3 = 0;
        while (n2 < stringBuffer.length()) {
            char c = stringBuffer.charAt(n2++);
            String string = Integer.toBinaryString(c);
            while (string.length() < 8) {
                string = "0" + string;
            }
            stringBuffer2.append(string);
            while (n3 < stringBuffer2.length()) {
                node = stringBuffer2.charAt(n3) == '0' ? node.getLeftChild() : node.getRightChild();
                ++n3;
                if (node.getLeftChild() != null || node.getRightChild() != null) continue;
                if ((long)stringBuffer3.length() < this.characterscount) {
                    stringBuffer3.append((char)node.getData());
                }
                node = this.root;
                stringBuffer2.delete(0, n3);
                n3 = 0;
            }
        }
        return stringBuffer3;
    }
}

