import java.net.*;
import java.io.*;
import java.util.Date;

public class ServerThread extends Thread
{
    Socket socket;
    String homepath;
    
    public ServerThread(Socket s, String hp)
    {
        socket = s;
        homepath = hp;
    }
    
    public void run()
    {
        try
        {
            PrintStream out = new PrintStream(socket.getOutputStream());
            BufferedReader in = new BufferedReader(new InputStreamReader(socket.getInputStream()));
                
            String get = in.readLine();
            //System.out.println(get);
            String line;
                
            //System.out.println(get);

            //System.out.println(new Date() + ": " + get + " - " + socket.getInetAddress());
            
            //Erste Zeile parsen...
            String[] commands = get.split(" ");
            if (!commands[0].equals("GET") && !commands[0].equals("POST"))
            {
                out.println("HTTP/1.1 501 Not Implemented");
                Errors.Error501(out);
                in.close();
                out.close();
                socket.close();
                return;
            }
            else if (commands[0].equals("POST"))
            {
                int length = 0;

                while((line = in.readLine()) != null && line.length() > 0)
                {
                    //System.out.println(line);
                    
                    String field = line.substring(0, line.indexOf(":"));
                    String content_length = "0";
                    if (field.toLowerCase().equals("content-length"))
                    {
                        content_length = line.substring(line.indexOf(":")+1).trim();
                        try
                        {
                            length = Integer.parseInt(content_length);
                        }
                        catch (NumberFormatException nfe) {}
                    }                    
                }
                
                char[] content = new char[length];
                in.read(content);
                
                commands[1] = commands[1] + "?" + new String(content);
            }
            
            //while((line = in.readLine()) != null && line.length() > 0)
            //    System.out.println(line);
            
            //GET /HelloWorld HTTP/1.1
            String file = commands[1];
            String[] args = new String[0];
            int fragezeichen = file.indexOf("?");
            if (fragezeichen > -1)
            {
                args = file.substring(fragezeichen+1).split("&");
                file = file.substring(0, fragezeichen);
            }
            
               
            //System.out.println(file);
            if(file.length() == 0)
                file = "index.html";
            
            file = homepath + "/" + file;

            System.out.println(new Date() + ": " + get + " - " + socket.getInetAddress());
            
            try
            {
                File f = new File(file);
                if (f.exists() && !f.isDirectory() && getFileEnding(f.getName()).equals("class"))
                {
                    String classname = f.getName();
                    classname = classname.substring(0, classname.indexOf("."));

                    PrintStream std_out = System.out;

                                        
                    Class c = Class.forName(classname, true, new SimpleClassLoader(f.getParentFile().getAbsolutePath()));
                    try
                    {                        
                        System.setOut(out);
                        
                        Class[] m_param = new Class[1];
                        m_param[0] = String[].class;
                        java.lang.reflect.Method m = c.getMethod("main", m_param);
                        
                        out.println("HTTP/1.1 200 OK");
                        Object[] m_args = {args};
                        m.invoke(null, m_args);
                        
                        System.setOut(std_out);
                        
                    }
                    //catch (ClassCastException cce)
                    catch (Exception cce)
                    {
                        System.setOut(std_out);
                        out.println("HTTP/1.1 500 Internal Server Error");
                        Errors.Error500(out, cce.toString());
                    }
                }
                else
                {
                    loadFile(file, out);
                }
            }
            catch(ClassNotFoundException cnfe)
            {
                //cnfe.printStackTrace();
                loadFile(file, out);
            }
            
            in.close();
            out.close();
            socket.close();
        }
        catch (Exception e)
        {
            e.printStackTrace();
        }
    }
    
    public void printFile(PrintStream out, File file)
    {
        try
        {
            FileInputStream in = new FileInputStream(file);
            byte[] b = new byte[in.available()];
            in.read(b);
            out.write(b);            
        }
        catch (Exception e)
        {
            e.printStackTrace();
        }
    }
    
    public void printFileSHTML(PrintStream out, File file)
    {
        try
        {
            //Datei einlesen
            StringBuffer data = new StringBuffer();
            BufferedReader in = new BufferedReader(new FileReader(file));
            String line;
            while ((line = in.readLine()) != null)
            {
                data.append(line);
                data.append("\n");
            }
            in.close();
            
            //Durchgehen zum ersten HTML-Kommentar:
            int index = 0;
            while (index < data.length())
            {
                int start  = data.indexOf("<!--#include virtual=\"", index);
                int start2 = start + 22;
                if (start == -1)
                    break;
                
                int ende  = data.indexOf("-->", start) + 3;
                int ende2 = data.indexOf("\"", start2);
                
                String virtual = data.substring(start2, ende2);
                
                //in Virtual ist ein Pfadname enthalten...
                virtual = homepath + "/" + virtual;
                FileInputStream virtual_input = new FileInputStream(new File(virtual));
                byte[] virtual_bytes = new byte[virtual_input.available()];
                virtual_input.read(virtual_bytes);
                
                data.replace(start, ende, new String(virtual_bytes));
            }
            
            //data ausgeben
            out.println(data.toString());
            
        }
        catch (Exception e)
        {
            e.printStackTrace();
        }
    }
    
    public String getFileEnding(String name)
    {
        int index_punkt = name.lastIndexOf(".");
        String ending = name.substring(index_punkt+1);
        ending = ending.toLowerCase();
        return ending;
    }
    
    public void printFileType(PrintStream out, File file)
    {
        String ending = getFileEnding(file.getName());
                
        if (ending.equals("html") || ending.equals("htm") || ending.equals("shtml"))
            out.println("Content-type: text/html\n");
        else if (ending.equals("css"))
            out.println("Content-type: text/css\n");
        else if (ending.equals("png"))
            out.println("Content-type: image/png\n");
        else if (ending.equals("jpg") || ending.equals("jpeg"))
            out.println("Content-type: image/jpeg\n");
        else
            out.println("Content-type: text/plain\n");
    }

    public void loadFile(String filename, PrintStream out)
    {
        File f = new File(filename);
        
        if (f.isDirectory())
        {
            f = new File(filename + "/index.html");
            
            if (!f.canRead())
            {
                f = new File(filename + "/index.shtml");
            }
        }
        
        
        if (f.canRead())
        {
            out.println("HTTP/1.1 200 OK");
            printFileType(out, f);
            if (getFileEnding(f.getName()).equals("shtml"))
            {
                printFileSHTML(out, f);
            }
            else
            {
                printFile(out, f);
            }
        }
        else
        {
            out.println("HTTP/1.1 404 Not Found");
            Errors.Error404(out);
        }
        
    }
}
