import java.io.*;

public class SimpleClassLoader extends ClassLoader
{
    String classpath;
    
    public SimpleClassLoader(String cp)
    {
        super();
        
        classpath = cp;    
    }
    
    public Class findClass(String name) throws ClassNotFoundException
    {
        File file = new File(classpath + "/" + name + ".class");
        if (!file.exists() || !file.isFile())
            throw new ClassNotFoundException(file.getPath());
        
        try
        {
            FileInputStream fi = new FileInputStream(file);
            byte[] classBytes = new byte[fi.available()];
            fi.read(classBytes);
            //System.out.println("loading...");
            return defineClass(name, classBytes, 0, classBytes.length);
        }
        catch(IOException e)
        {
            throw new ClassNotFoundException("I/O Error", e);   
        }
    }
}

