/*
 * Decompiled with CFR 0.152.
 */
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Vector;

public class Kalender {
    public static Vector holidays = new Vector();

    public static void main(String[] stringArray) {
        if (stringArray.length != 1) {
            System.err.println("Syntax: java Kalender <jahr>");
            System.exit(1);
        }
        int n = new GregorianCalendar().get(1);
        try {
            n = Integer.parseInt(stringArray[0]);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        Kalender.createHolidays(n);
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        Kalender.printCSV(n, gregorianCalendar);
    }

    public static void printCSV(int n, GregorianCalendar gregorianCalendar) {
        int n2;
        int n3;
        System.out.println("Jahreskalender " + n);
        Vector<String> vector = new Vector<String>();
        for (n3 = 0; n3 < 32; ++n3) {
            vector.add("");
        }
        n3 = 0;
        gregorianCalendar.set(1, n);
        gregorianCalendar.set(6, 1);
        String string = (String)vector.get(0);
        string = string + ";;" + Kalender.getMonthString(gregorianCalendar) + ";";
        vector.set(0, string);
        int n4 = 365;
        if (gregorianCalendar.isLeapYear(n)) {
            ++n4;
        }
        for (n2 = 1; n2 <= n4; ++n2) {
            int n5 = gregorianCalendar.get(5);
            gregorianCalendar.set(6, n2);
            if (gregorianCalendar.get(2) != n3) {
                n3 = gregorianCalendar.get(2);
                string = (String)vector.get(0);
                string = string + ";;" + Kalender.getMonthString(gregorianCalendar) + ";";
                vector.set(0, string);
                if (n5 < 31) {
                    for (int i = n5 + 1; i <= 31; ++i) {
                        string = (String)vector.get(i);
                        string = string + ";;;";
                        vector.set(i, string);
                    }
                }
            }
            Holiday holiday = Kalender.getHoliday(gregorianCalendar);
            String string2 = "";
            if (holiday != null) {
                string2 = holiday.name;
            }
            string = (String)vector.get(gregorianCalendar.get(5));
            string = string + gregorianCalendar.get(5) + ";" + Kalender.getWeekDayString(gregorianCalendar) + ";" + string2 + ";";
            vector.set(gregorianCalendar.get(5), string);
        }
        for (n2 = 0; n2 < 32; ++n2) {
            System.out.println((String)vector.get(n2));
        }
    }

    public static void printHTML(int n, GregorianCalendar gregorianCalendar) {
        String string = "Jahreskalender " + n;
        System.out.println("<html>");
        System.out.println("<head>");
        System.out.println("<title>" + string + "</title>");
        System.out.println("<style type=\"text/css\">");
        System.out.println(".border { border: 1px solid black; }");
        System.out.println("td { font-size: 10pt; }");
        System.out.println("h1 { margin: 0pt; text-align: center; }");
        System.out.println("</style>");
        System.out.println("</head>");
        System.out.println("<body>");
        System.out.println("<h1>" + string + "</h1>");
        int n2 = 0;
        gregorianCalendar.set(1, n);
        gregorianCalendar.set(6, 1);
        System.out.println("<table width=\"100%\" class=\"border\">");
        System.out.println("<tr><td valign=\"top\">");
        System.out.println("<table>");
        System.out.println("<tr><th colspan=\"3\">" + Kalender.getMonthString(gregorianCalendar) + "</th></tr>");
        int n3 = 365;
        if (gregorianCalendar.isLeapYear(n)) {
            ++n3;
        }
        for (int i = 1; i <= n3; ++i) {
            gregorianCalendar.set(6, i);
            if (gregorianCalendar.get(2) != n2) {
                n2 = gregorianCalendar.get(2);
                System.out.println("</table>");
                System.out.println("</td>\n");
                if (n2 == 6) {
                    System.out.println("</tr></table>\n\n");
                    System.out.println("<h1>" + string + "</h1>");
                    System.out.println("<table width=\"100%\" class=\"border\">");
                }
                System.out.println("<td valign=\"top\">");
                System.out.println("<table>");
                System.out.println("<tr><th colspan=\"3\">" + Kalender.getMonthString(gregorianCalendar) + "</th></tr>");
            }
            String string2 = "white";
            String string3 = "200";
            String string4 = "&nbsp;";
            Holiday holiday = Kalender.getHoliday(gregorianCalendar);
            if (holiday != null) {
                string2 = holiday.bgcolor;
                string4 = holiday.name;
            }
            if ((holiday = Kalender.getHoliday(gregorianCalendar)) != null) {
                if (string2.equals("white")) {
                    string2 = holiday.bgcolor;
                }
                string4 = string4 + " / " + holiday.name;
            }
            if (gregorianCalendar.get(7) == 7 || gregorianCalendar.get(7) == 1) {
                string2 = "gray";
            }
            System.out.println("<tr><td class=\"border\" align=\"right\" bgcolor=\"" + string2 + "\">" + gregorianCalendar.get(5) + "</td>" + "<td class=\"border\" bgcolor=\"" + string2 + "\">" + Kalender.getWeekDayString(gregorianCalendar) + "</td>" + "<td class=\"border\" width=\"" + string3 + "\" bgcolor=\"" + string2 + "\">" + string4 + "</td></tr>");
        }
        System.out.println("</table>");
        System.out.println("</td>\n");
        System.out.println("</tr></table>");
        System.out.println("</body>");
        System.out.println("</html>");
    }

    public static String getWeekDayString(Calendar calendar) {
        switch (calendar.get(7)) {
            case 1: {
                return "So";
            }
            case 2: {
                return "Mo";
            }
            case 3: {
                return "Di";
            }
            case 4: {
                return "Mi";
            }
            case 5: {
                return "Do";
            }
            case 6: {
                return "Fr";
            }
            case 7: {
                return "Sa";
            }
        }
        return null;
    }

    public static String getMonthString(Calendar calendar) {
        switch (calendar.get(2)) {
            case 0: {
                return "Januar";
            }
            case 1: {
                return "Februar";
            }
            case 2: {
                return "M\u00e4rz";
            }
            case 3: {
                return "April";
            }
            case 4: {
                return "Mai";
            }
            case 5: {
                return "Juni";
            }
            case 6: {
                return "Juli";
            }
            case 7: {
                return "August";
            }
            case 8: {
                return "September";
            }
            case 9: {
                return "Oktober";
            }
            case 10: {
                return "November";
            }
            case 11: {
                return "Dezember";
            }
        }
        return null;
    }

    public static Holiday getHoliday(Calendar calendar) {
        for (int i = 0; i < holidays.size(); ++i) {
            Holiday holiday = (Holiday)holidays.get(i);
            if (calendar.get(2) != holiday.month || calendar.get(5) != holiday.day) continue;
            return (Holiday)holidays.remove(i);
        }
        return null;
    }

    public static void createHolidays(int n) {
        holidays.add(new Holiday(0, 1, "Neujahr", true));
        holidays.add(new Holiday(0, 6, "Erscheinungsfest", true));
        holidays.add(new Holiday(1, 14, "Valentinstag", false));
        holidays.add(new Holiday(4, 1, "Tag der Arbeit", true));
        holidays.add(new Holiday(9, 3, "Tag der dt. Einheit", true));
        holidays.add(new Holiday(9, 31, "Reformationstag", false));
        holidays.add(new Holiday(10, 1, "Allerheiligen", true));
        holidays.add(new Holiday(11, 24, "Heiligabend", false));
        holidays.add(new Holiday(11, 25, "1. Weihnachtstag", true));
        holidays.add(new Holiday(11, 26, "2. Weihnachtstag", true));
        holidays.add(new Holiday(11, 31, "Silvester", false));
        int n2 = n % 19;
        int n3 = n / 100;
        int n4 = (n3 - n3 / 4 - (8 * n3 + 13) / 25 + 19 * n2 + 15) % 30;
        int n5 = n4 - n4 / 28 * (1 - 29 / (n4 + 1)) * ((21 - n2) / 11);
        int n6 = (n + n / 4 + n5 + 2 - n3 + n3 / 4) % 7;
        int n7 = n5 - n6;
        int n8 = 3 + (n7 + 40) / 44;
        int n9 = n7 + 28 - 31 * (n8 / 4);
        holidays.add(new Holiday(n8 - 1, n9, "Ostersonntag", true));
        GregorianCalendar gregorianCalendar = new GregorianCalendar(n, n8 - 1, n9);
        gregorianCalendar.add(6, 1);
        holidays.add(new Holiday(gregorianCalendar.get(2), gregorianCalendar.get(5), "Ostermontag", true));
        gregorianCalendar.add(6, -1);
        gregorianCalendar.add(6, -2);
        holidays.add(new Holiday(gregorianCalendar.get(2), gregorianCalendar.get(5), "Karfreitag", true));
        gregorianCalendar.set(n, n8 - 1, n9);
        gregorianCalendar.add(6, 39);
        holidays.add(new Holiday(gregorianCalendar.get(2), gregorianCalendar.get(5), "Christi Himmelfahrt", true));
        gregorianCalendar.add(6, 10);
        holidays.add(new Holiday(gregorianCalendar.get(2), gregorianCalendar.get(5), "Pfingstsonntag", true));
        gregorianCalendar.add(6, 1);
        holidays.add(new Holiday(gregorianCalendar.get(2), gregorianCalendar.get(5), "Pfingstmontag", true));
        gregorianCalendar.add(6, 10);
        holidays.add(new Holiday(gregorianCalendar.get(2), gregorianCalendar.get(5), "Fronleichnam", true));
        gregorianCalendar.set(n, n8 - 1, n9);
        gregorianCalendar.add(6, -48);
        holidays.add(new Holiday(gregorianCalendar.get(2), gregorianCalendar.get(5), "Rosenmontag", false));
        gregorianCalendar.add(6, 1);
        holidays.add(new Holiday(gregorianCalendar.get(2), gregorianCalendar.get(5), "Fastnacht", false));
        gregorianCalendar.add(6, 1);
        holidays.add(new Holiday(gregorianCalendar.get(2), gregorianCalendar.get(5), "Aschermittwoch", false));
        gregorianCalendar.set(n, 11, 24);
        while (gregorianCalendar.get(7) != 1) {
            gregorianCalendar.add(6, -1);
        }
        holidays.add(new Holiday(gregorianCalendar.get(2), gregorianCalendar.get(5), "4. Advent", true));
        gregorianCalendar.add(6, -7);
        holidays.add(new Holiday(gregorianCalendar.get(2), gregorianCalendar.get(5), "3. Advent", true));
        gregorianCalendar.add(6, -7);
        holidays.add(new Holiday(gregorianCalendar.get(2), gregorianCalendar.get(5), "2. Advent", true));
        gregorianCalendar.add(6, -7);
        holidays.add(new Holiday(gregorianCalendar.get(2), gregorianCalendar.get(5), "1. Advent", true));
        gregorianCalendar.set(n, 2, 31);
        while (gregorianCalendar.get(7) != 1) {
            gregorianCalendar.add(6, -1);
        }
        holidays.add(new Holiday(gregorianCalendar.get(2), gregorianCalendar.get(5), "Sommerzeitbeginn", false));
        gregorianCalendar.set(n, 9, 31);
        while (gregorianCalendar.get(7) != 1) {
            gregorianCalendar.add(6, -1);
        }
        holidays.add(new Holiday(gregorianCalendar.get(2), gregorianCalendar.get(5), "Sommerzeitende", false));
    }

    private static class Holiday {
        int month;
        int day;
        String name;
        String bgcolor;

        Holiday(int n, int n2, String string, boolean bl) {
            this.month = n;
            this.day = n2;
            this.name = string;
            this.bgcolor = bl ? "gray" : "white";
        }
    }
}

