import java.util.*;

public class Kalender
{
    public static Vector holidays = new Vector();
    
    public static void main(String[] args)
    {
        if (args.length != 1)
        {
            System.err.println("Syntax: java Kalender <jahr>");
            System.exit(1);
        }
        
        int year = (new GregorianCalendar()).get(Calendar.YEAR);
        try
        {
            year = Integer.parseInt(args[0]);
        }
        catch (NumberFormatException nfe)
        {
        }
    
        
        createHolidays(year);
        
        GregorianCalendar cal = new GregorianCalendar();

        //printHTML(year, cal);
        printCSV(year, cal);
        

        
    }
    
    public static void printCSV(int year, GregorianCalendar cal)
    {
        System.out.println("Jahreskalender " + year);
        
        Vector output = new Vector();
        for(int i = 0; i < 32; i++)
            output.add("");
        
        
        int old_month = Calendar.JANUARY;
        cal.set(Calendar.YEAR, year);
        cal.set(Calendar.DAY_OF_YEAR, 1);

        String line = (String) output.get(0);
        line += ";;" + getMonthString(cal) + ";";
        output.set(0, line);

        int count_days = 365;
        if (cal.isLeapYear(year)) count_days++;
        
        for(int i = 1; i <= count_days; i++)
        {
            int old_dom = cal.get(Calendar.DAY_OF_MONTH);
            cal.set(Calendar.DAY_OF_YEAR, i);
            
            
            //neuer Monat?
            if(cal.get(Calendar.MONTH) != old_month)
            {
                old_month = cal.get(Calendar.MONTH);
                
                line = (String) output.get(0);
                line += ";;" + getMonthString(cal) + ";";
                output.set(0, line);
                
                if (old_dom < 31)
                {
                    for (int j = old_dom+1; j <= 31; j++)
                    {
                        line = (String) output.get(j);
                        line += ";;;";
                        output.set(j, line);
                    }
                }
            }
            
            Holiday h = getHoliday(cal);
            String holiday = "";
            if (h != null) holiday = h.name;
            
            line = (String) output.get(cal.get(Calendar.DAY_OF_MONTH));
            line += cal.get(Calendar.DAY_OF_MONTH) + ";"
                    + getWeekDayString(cal) + ";" + holiday + ";";
            output.set(cal.get(Calendar.DAY_OF_MONTH), line);
            
        }
        
        for(int i = 0; i < 32; i++)
            System.out.println((String) output.get(i));
    }
    
    public static void printHTML(int year, GregorianCalendar cal)
    {
        String title = "Jahreskalender " + year;
                
        System.out.println("<html>");
        System.out.println("<head>");
        System.out.println("<title>" + title + "</title>");
        System.out.println("<style type=\"text/css\">");
        System.out.println(".border { border: 1px solid black; }");
        System.out.println("td { font-size: 10pt; }");
        System.out.println("h1 { margin: 0pt; text-align: center; }");
        System.out.println("</style>");
        System.out.println("</head>");
        System.out.println("<body>");
        System.out.println("<h1>" + title + "</h1>");

        int old_month = Calendar.JANUARY;
        cal.set(Calendar.YEAR, year);
        cal.set(Calendar.DAY_OF_YEAR, 1);
        
        System.out.println("<table width=\"100%\" class=\"border\">");
        System.out.println("<tr><td valign=\"top\">");
        
        System.out.println("<table>");
        System.out.println("<tr><th colspan=\"3\">" + getMonthString(cal) + "</th></tr>");
        
        int count_days = 365;
        if (cal.isLeapYear(year)) count_days++;
        
        for(int i = 1; i <= count_days; i++)
        {
            cal.set(Calendar.DAY_OF_YEAR, i);
            
            
            //neuer Monat?
            if(cal.get(Calendar.MONTH) != old_month)
            {
                old_month = cal.get(Calendar.MONTH);
                System.out.println("</table>");
                System.out.println("</td>\n");
                //zweites Halbjahr?
                if (old_month == Calendar.JULY)
                {
                    System.out.println("</tr></table>\n\n");
                    System.out.println("<h1>" + title + "</h1>");
                    System.out.println("<table width=\"100%\" class=\"border\">");
                }
                System.out.println("<td valign=\"top\">");
                System.out.println("<table>");
                System.out.println("<tr><th colspan=\"3\">" + getMonthString(cal) + "</th></tr>");
            }
            
            
            String bgcolor = "white";
            String width = "200";
            String name = "&nbsp;";
            
            Holiday h = getHoliday(cal);
            if (h != null)
            {
                bgcolor = h.bgcolor;
                name = h.name;
            }
            
            // zweiter Feiertag??
            h = getHoliday(cal);
            if (h != null)
            {
                if (bgcolor.equals("white")) bgcolor = h.bgcolor;
                name = name + " / " + h.name;
            }
            
            if (cal.get(Calendar.DAY_OF_WEEK) == Calendar.SATURDAY
                || cal.get(Calendar.DAY_OF_WEEK) == Calendar.SUNDAY)
            {
                bgcolor = "gray";
            }
            
            
            System.out.println("<tr>"
                    + "<td class=\"border\" align=\"right\" bgcolor=\"" + bgcolor + "\">"
                        + cal.get(Calendar.DAY_OF_MONTH) + "</td>"
                    + "<td class=\"border\" bgcolor=\"" + bgcolor + "\">"
                        + getWeekDayString(cal) + "</td>"
                    + "<td class=\"border\" width=\"" + width + "\" bgcolor=\"" + bgcolor + "\">"
                        + name + "</td></tr>");
            
            
        }
        
        System.out.println("</table>");
        System.out.println("</td>\n");
        System.out.println("</tr></table>");
        System.out.println("</body>");
        System.out.println("</html>");
        
    }
    
    public static String getWeekDayString(Calendar c)
    {
        switch (c.get(Calendar.DAY_OF_WEEK))
        {
            case Calendar.SUNDAY: return "So";
            case Calendar.MONDAY: return "Mo";
            case Calendar.TUESDAY: return "Di";
            case Calendar.WEDNESDAY: return "Mi";
            case Calendar.THURSDAY: return "Do";
            case Calendar.FRIDAY: return "Fr";
            case Calendar.SATURDAY: return "Sa";
        }
        
        return null;
        
    }
    
    public static String getMonthString(Calendar c)
    {
        switch(c.get(Calendar.MONTH))
        {
            case Calendar.JANUARY: return "Januar";
            case Calendar.FEBRUARY: return "Februar";
            case Calendar.MARCH: return "Mrz";
            case Calendar.APRIL: return "April";
            case Calendar.MAY: return "Mai";
            case Calendar.JUNE: return "Juni";
            case Calendar.JULY: return "Juli";
            case Calendar.AUGUST: return "August";
            case Calendar.SEPTEMBER: return "September";
            case Calendar.OCTOBER: return "Oktober";
            case Calendar.NOVEMBER: return "November";
            case Calendar.DECEMBER: return "Dezember";
        }
        
        return null;
    }
    
    public static Holiday getHoliday(Calendar c)
    {
        for(int i = 0; i < holidays.size(); i++)
        {
            Holiday h = (Holiday) holidays.get(i);
            if (c.get(Calendar.MONTH) == h.month && c.get(Calendar.DAY_OF_MONTH) == h.day)
                return (Holiday) holidays.remove(i);
        }
        
        return null;
    }
    
    public static void createHolidays(int year)
    {
        holidays.add(new Holiday(Calendar.JANUARY, 1, "Neujahr", true));
        holidays.add(new Holiday(Calendar.JANUARY, 6, "Erscheinungsfest", true));
        holidays.add(new Holiday(Calendar.FEBRUARY, 14, "Valentinstag", false));
        holidays.add(new Holiday(Calendar.MAY, 1, "Tag der Arbeit", true));
        holidays.add(new Holiday(Calendar.OCTOBER, 3, "Tag der dt. Einheit", true));
        holidays.add(new Holiday(Calendar.OCTOBER, 31, "Reformationstag", false));
        holidays.add(new Holiday(Calendar.NOVEMBER, 1, "Allerheiligen", true));
        holidays.add(new Holiday(Calendar.DECEMBER, 24, "Heiligabend", false));
        holidays.add(new Holiday(Calendar.DECEMBER, 25, "1. Weihnachtstag", true));
        holidays.add(new Holiday(Calendar.DECEMBER, 26, "2. Weihnachtstag", true));
        holidays.add(new Holiday(Calendar.DECEMBER, 31, "Silvester", false));
        
        
        //Ostern
        //siehe Wikipedia: Osterdatum
        int G = year % 19;
        int C = year / 100;
        int H = (C - C/4 - (8*C+13)/25+19*G+15) % 30;
        int I = H - H/28 * (1-29/(H+1))*((21-G)/11);
        int J = (year + year/4 + I + 2 - C + C/4) % 7;
        int L = I - J;
        
        int Ostermonat = 3 + (L + 40)/44;
        int Ostertag = L + 28 - 31 * (Ostermonat / 4);
        
        //System.err.println("G=" + G + "\nC=" + C + "\nH=" + H + "\nI=" + I + "\nJ=" + J + "\nL=" + L);
        //System.err.println("Ostermonat=" + Ostermonat + "\nOstertag=" + Ostertag);
                
        holidays.add(new Holiday(Ostermonat-1, Ostertag, "Ostersonntag", true));
        GregorianCalendar c = new GregorianCalendar(year, Ostermonat-1, Ostertag);
        c.add(Calendar.DAY_OF_YEAR, 1);
        holidays.add(new Holiday(c.get(Calendar.MONTH), c.get(Calendar.DAY_OF_MONTH), "Ostermontag", true));
        c.add(Calendar.DAY_OF_YEAR, -1);
        c.add(Calendar.DAY_OF_YEAR, -2);        
        holidays.add(new Holiday(c.get(Calendar.MONTH), c.get(Calendar.DAY_OF_MONTH), "Karfreitag", true));
        
        //Christi Himmelfahrt (Do) (Mai): 39 Tage nach Ostern
        c.set(year, Ostermonat-1, Ostertag);
        c.add(Calendar.DAY_OF_YEAR, 39);
        holidays.add(new Holiday(c.get(Calendar.MONTH), c.get(Calendar.DAY_OF_MONTH), "Christi Himmelfahrt", true));
        
        //Pfingstsonntag+Montag (Mai/Juni): 49 Tag nach Ostern, 10 Tag nach Christi Himmelfahrt
        c.add(Calendar.DAY_OF_YEAR, 10);
        holidays.add(new Holiday(c.get(Calendar.MONTH), c.get(Calendar.DAY_OF_MONTH), "Pfingstsonntag", true));
        c.add(Calendar.DAY_OF_YEAR, 1);
        holidays.add(new Holiday(c.get(Calendar.MONTH), c.get(Calendar.DAY_OF_MONTH), "Pfingstmontag", true));
        
        
        //Fronleichnam (Do) (Juni): 60 Tag nach Ostern, 11 Tage nach Pfingstsonntag
        // 10 Tage nach Pfingsmontag
        c.add(Calendar.DAY_OF_YEAR, 10);
        holidays.add(new Holiday(c.get(Calendar.MONTH), c.get(Calendar.DAY_OF_MONTH), "Fronleichnam", true));        

        // Rosenmontag: 48 Tage vor Ostern
        c.set(year, Ostermonat-1, Ostertag);
        c.add(Calendar.DAY_OF_YEAR, -48);
        holidays.add(new Holiday(c.get(Calendar.MONTH), c.get(Calendar.DAY_OF_MONTH), "Rosenmontag", false));
        //Fastnacht
        c.add(Calendar.DAY_OF_YEAR, 1);
        holidays.add(new Holiday(c.get(Calendar.MONTH), c.get(Calendar.DAY_OF_MONTH), "Fastnacht", false));
        //Aschermittwoch
        c.add(Calendar.DAY_OF_YEAR, 1);
        holidays.add(new Holiday(c.get(Calendar.MONTH), c.get(Calendar.DAY_OF_MONTH), "Aschermittwoch", false));
        
        //1. - 4. Advent
        c.set(year, Calendar.DECEMBER, 24);
        while(c.get(Calendar.DAY_OF_WEEK) != Calendar.SUNDAY)
            c.add(Calendar.DAY_OF_YEAR, -1);
        
        holidays.add(new Holiday(c.get(Calendar.MONTH), c.get(Calendar.DAY_OF_MONTH), "4. Advent", true));
        c.add(Calendar.DAY_OF_YEAR, -7);
        holidays.add(new Holiday(c.get(Calendar.MONTH), c.get(Calendar.DAY_OF_MONTH), "3. Advent", true));
        c.add(Calendar.DAY_OF_YEAR, -7);
        holidays.add(new Holiday(c.get(Calendar.MONTH), c.get(Calendar.DAY_OF_MONTH), "2. Advent", true));
        c.add(Calendar.DAY_OF_YEAR, -7);
        holidays.add(new Holiday(c.get(Calendar.MONTH), c.get(Calendar.DAY_OF_MONTH), "1. Advent", true));
        
        //Sommerzeit-Anfang: letzter Sonntag im Mrz
        c.set(year, Calendar.MARCH, 31);
        while(c.get(Calendar.DAY_OF_WEEK) != Calendar.SUNDAY)
            c.add(Calendar.DAY_OF_YEAR, -1);
        holidays.add(new Holiday(c.get(Calendar.MONTH), c.get(Calendar.DAY_OF_MONTH), "Sommerzeitbeginn", false));
        //Winterzeit-Anfang: letzter Sonntag im Oktober
        c.set(year, Calendar.OCTOBER, 31);
        while(c.get(Calendar.DAY_OF_WEEK) != Calendar.SUNDAY)
            c.add(Calendar.DAY_OF_YEAR, -1);
        holidays.add(new Holiday(c.get(Calendar.MONTH), c.get(Calendar.DAY_OF_MONTH), "Sommerzeitende", false));
            
    }
    
    private static class Holiday
    {
        int month;
        int day;
        String name;
        String bgcolor;
        
        Holiday(int month, int day, String name, boolean type)
        {
            this.month = month;
            this.day = day;
            this.name = name;
            bgcolor = (type ? "gray" : "white");
        }
    }
}
