/*
 * NetworkSpeed
 * (c) 2006 Andreas Dangel <adabolo@adabolo.de>
 * list.h   2006-04-12
 */

#ifndef LIST_H_
#define LIST_H_

#include <sys/types.h>
#include "main.h"

// The structure of one list element
struct list {
    struct list * next;
    u_char ethernet_address[ETHER_ADDR_LEN];
    unsigned long sent;
    unsigned long received;
};

void packet_counter_sent(const u_char ether_addr[], unsigned int bytes);
void packet_counter_received(const u_char ether_addr[], unsigned int bytes);
void print_list(double seconds, const char * filename);
unsigned int count();
struct list * get(int index);
void clear_counters();
void free_list();
void init_list();


#endif /*LIST_H_*/
