#!/usr/bin/perl
###!/usr/bin/perl -w
use CGI;
#use CGI::Carp qw(fatalsToBrowser);


#
#    oberstufe.cgi -- Oberstufen-Rechner
#    Copyright (C) 2007  Andreas Dangel <adabolo@adabolo.de>
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
#



## Verlauf:
# Seite 1: Fcherwahl
# Seite 2: Noteneingabe
# Seite 3: Ergebnis


my $q = new CGI;
print $q->header;

## Parameter mit Standardwerten
my $self_url = $ENV{"SCRIPT_NAME"};
my $version = "1.8 (2007/04/21)";
my $bottom_line = qq(<hr>\nVersion: $version | &copy; 2007 adabolo.de | <a href="$self_url">Oberstufen-Rechner neu starten</a> | <a href="http://www.adabolo.de/projects/osrechner/index.html">zur Homepage</a>\n</body>\n</html>\n);
my $error_wahl = "";
my $error_noten = "";
my $error_pruef = "";
my $wertung_info = "";
my $anzahl_faecher = 0;
my $anzahl_stunden = 0;
my $page;
my $kern_sprache;
my $profilfach;
my $neigungsfach;
my $geschichte2;
my $gemeinschaftskunde2;
my $erdkunde2;
my $musik2;
my $kunst2;
my $religion2;
my $ethik2;
my $biologie2;
my $chemie2;
my $physik2;
my $sport2;
my $wahl_lernleistung;
my $wahl_facharbeit;
my $wahl_seminarkurs;
my $wahl_sprache;
my $wahl_literatur;
my $wahl_philosophie;
my $wahl_psychologie;
my $wahl_astronomie;
my $wahl_geometrie;
my $wahl_cas;
my $wahl_geologie;
my $wahl_informatik;
my @noten_faecher;
my $Pruef_Fach2;
my $Pruef_Fach4;
my $Pruef_Fach5;
my $doppel1;
my $doppel2;

if (defined($q->param("page"))) {
  $page = $q->param("page");

  if (defined($q->param("back_button"))) {
    $page--;
    $page--;
  }

  ## Parameter sichten
  $kern_sprache = $q->param("kern_sprache");
  $profilfach = $q->param("profilfach");
  $neigungsfach = $q->param("neigungsfach");
  $geschichte2 = $q->param("geschichte2");
  $gemeinschaftskunde2 = $q->param("gemeinschaftskunde2");
  $erdkunde2 = $q->param("erdkunde2");
  $musik2 = $q->param("musik2");
  $kunst2 = $q->param("kunst2");
  $religion2 = $q->param("religion2");
  $ethik2 = $q->param("ethik2");
  $biologie2 = $q->param("biologie2");
  $chemie2 = $q->param("chemie2");
  $physik2 = $q->param("physik2");
  $sport2 = $q->param("sport2");
  $wahl_lernleistung = $q->param("wahl_lernleistung");
  $wahl_facharbeit = $q->param("wahl_facharbeit");
  $wahl_seminarkurs = $q->param("wahl_seminarkurs");
  $wahl_sprache = $q->param("wahl_sprache");
  $wahl_literatur = $q->param("wahl_literatur");
  $wahl_philosophie = $q->param("wahl_philosophie");
  $wahl_psychologie = $q->param("wahl_psychologie");
  $wahl_astronomie = $q->param("wahl_astronomie");
  $wahl_geometrie = $q->param("wahl_geometrie");
  $wahl_cas = $q->param("wahl_cas");
  $wahl_geologie = $q->param("wahl_geologie");
  $wahl_informatik = $q->param("wahl_informatik");
  @noten_faecher = grep(/\_noten/, $q->param);
  $Pruef_Fach2 = $q->param("Pruef_Fach2");
  $Pruef_Fach4 = $q->param("Pruef_Fach4");
  $Pruef_Fach5 = $q->param("Pruef_Fach5");

  ## Fcher und Stunden zhlen...
  &count_faecher_stunden;

  if ($page == 1) {

    ## Die Wahl berprfen...
    &check_wahl;

    if ($error_wahl eq "") {
      &print_page2;
      exit 0;
    }
  } elsif ($page == 2) {
    # Prfungsfcherwahl prfen
    &check_pruef;

    # Noten (-anzahl) berprfen
    &check_noten;

    if ($error_noten eq "" && $error_pruef eq "") {
      &print_page3;
      exit 0;
    } else {
      &print_page2;
      exit 0;
    }
  }
}

&print_page1;


exit 0;


#############
sub print_page1 {
  print <<HTML;
<html>
<head>
  <title>Oberstufen-Rechner - Schritt 1: Fcherwahl</title>
</head>
<body>
<h1>Oberstufen-Rechner - Schritt 1: Fcherwahl</h1>

HTML

if ($error_wahl ne "") {
  print qq(<font color="red"><strong>FEHLER:<br>$error_wahl</strong></font>\n);
}

print <<HTML;

<form method="post">
<h2>4-Stndige Kurse</h2>
<h3>Kernkompetenzfcher</h3>
<ul>
  <li>Deutsch</li>
  <li>Mathematik</li>
  <li><select name="kern_sprache">
HTML

  print qq(      <option);
  print qq( selected) if ($kern_sprache eq "Englisch");
  print qq(>Englisch\n);
  print qq(      <option);
  print qq( selected) if ($kern_sprache eq "Franzsisch");
  print qq(>Franzsisch\n);
  print qq(      <option);
  print qq( selected) if ($kern_sprache eq "Latein");
  print qq(>Latein\n);

  print <<HTML;
      </select></li>
</ul>

<h3>Profilfach</h3>
<select name="profilfach">
HTML

  print qq(  <option);
  print qq( selected) if ($profilfach eq "Englisch");
  print qq(>Englisch\n);
  print qq(  <option);
  print qq( selected) if ($profilfach eq "Franzsisch");
  print qq(>Franzsisch\n);
  print qq(  <option);
  print qq( selected) if ($profilfach eq "Latein");
  print qq(>Latein\n);
  print qq(  <option);
  print qq( selected) if ($profilfach eq "Biologie");
  print qq(>Biologie\n);
  print qq(  <option);
  print qq( selected) if ($profilfach eq "Chemie");
  print qq(>Chemie\n);
  print qq(  <option);
  print qq( selected) if ($profilfach eq "Physik");
  print qq(>Physik\n);

  print <<HTML;
</select>

<h3>Neigungsfach</h3>
<select name="neigungsfach">
HTML

  print qq(  <option);
  print qq( selected) if ($neigungsfach eq "Musik");
  print qq(>Musik\n);
  print qq(  <option);
  print qq( selected) if ($neigungsfach eq "Bildende Kunst");
  print qq(>Bildende Kunst\n);
  print qq(  <option);
  print qq( selected) if ($neigungsfach eq "Geschichte");
  print qq(>Geschichte\n);
  print qq(  <option);
  print qq( selected) if ($neigungsfach eq "Erdkunde");
  print qq(>Erdkunde\n);
  print qq(  <option);
  print qq( selected) if ($neigungsfach eq "Gemeinschaftskunde");
  print qq(>Gemeinschaftskunde\n);
  print qq(  <option);
  print qq( selected) if ($neigungsfach eq "Religionslehre");
  print qq(>Religionslehre\n);
  print qq(  <option);
  print qq( selected) if ($neigungsfach eq "Ethik");
  print qq(>Ethik\n);
  print qq(  <option);
  print qq( selected) if ($neigungsfach eq "Physik");
  print qq(>Physik\n);
  print qq(  <option);
  print qq( selected) if ($neigungsfach eq "Chemie");
  print qq(>Chemie\n);
  print qq(  <option);
  print qq( selected) if ($neigungsfach eq "Biologie");
  print qq(>Biologie\n);
  print qq(  <option);
  print qq( selected) if ($neigungsfach eq "Sport");
  print qq(>Sport\n);

  print <<HTML;
</select>

<h2>2-Stndige Kurse</h2>
HTML

print qq(<input type="checkbox" name="geschichte2");
print qq( checked) if ($geschichte2 eq "on");
print qq(>Geschichte<br>\n);
print qq(<input type="checkbox" name="gemeinschaftskunde2");
print qq( checked) if ($gemeinschaftskunde2 eq "on");
print qq(>Gemeinschaftskunde<br>\n);
print qq(<input type="checkbox" name="erdkunde2");
print qq( checked) if ($erdkunde2 eq "on");
print qq(>Erdkunde<br>\n);
print qq(<p>\n);
print qq(<input type="checkbox" name="musik2");
print qq( checked) if ($musik2 eq "on");
print qq(>Musik<br>\n);
print qq(<input type="checkbox" name="kunst2");
print qq( checked) if ($kunst2 eq "on");
print qq(>Bildende Kunst<br>\n);
print qq(<p>\n);
print qq(<input type="checkbox" name="religion2");
print qq( checked) if ($religion2 eq "on");
print qq(>Religionslehre<br>\n);
print qq(<input type="checkbox" name="ethik2");
print qq( checked) if ($ethik2 eq "on");
print qq(>Ethik<br>\n);
print qq(<p>\n);
print qq(<input type="checkbox" name="biologie2");
print qq( checked) if ($biologie2 eq "on");
print qq(>Biologie<br>\n);
print qq(<input type="checkbox" name="chemie2");
print qq( checked) if ($chemie2 eq "on");
print qq(>Chemie<br>\n);
print qq(<input type="checkbox" name="physik2");
print qq( checked) if ($physik2 eq "on");
print qq(>Physik<br>\n);
print qq(<p>\n);
print qq(<input type="checkbox" name="sport2");
print qq( checked) if ($sport2 eq "on");
print qq(>Sport<br>\n);
print qq(\n);

print qq(<h2>Wahlbereich (2-stndig)</h2>\n);
print qq(<select name="wahl_sprache">\n);
print qq(  <option value="keine");
print qq( selected) if ($wahl_sprache eq "keine");
print qq(>Keine weitere Sprache\n);
print qq(  <option);
print qq( selected) if ($wahl_sprache eq "Franzsisch");
print qq(>Franzsisch\n);
print qq(  <option);
print qq( selected) if ($wahl_sprache eq "Latein");
print qq(>Latein\n);
print qq(  <option);
print qq( selected) if ($wahl_sprache eq "Griechisch");
print qq(>Griechisch\n);
print qq(  <option);
print qq( selected) if ($wahl_sprache eq "Russisch");
print qq(>Russisch\n);
print qq(  <option);
print qq( selected) if ($wahl_sprache eq "Hebrisch");
print qq(>Hebrisch\n);
print qq(  <option);
print qq( selected) if ($wahl_sprache eq "Italienisch");
print qq(>Italienisch\n);
print qq(  <option);
print qq( selected) if ($wahl_sprache eq "Spanisch");
print qq(>Spanisch\n);
print qq(  <option);
print qq( selected) if ($wahl_sprache eq "Portugisisch");
print qq(>Portugisisch\n);
print qq(  <option);
print qq( selected) if ($wahl_sprache eq "Chinesisch");
print qq(>Chinesisch\n);
print qq(  <option);
print qq( selected) if ($wahl_sprache eq "Japanisch");
print qq(>Japanisch\n);
print qq(  <option);
print qq( selected) if ($wahl_sprache eq "Trkisch");
print qq(>Trkisch\n);
print qq(</select> (Hinweis: Sprachen sind immer 4-stndig!)<br>\n);
print qq(<input type="checkbox" name="wahl_literatur");
print qq( checked) if ($wahl_literatur eq "on");
print qq(>Literatur<br>\n);
print qq(<input type="checkbox" name="wahl_philosophie");
print qq( checked) if ($wahl_philosophie eq "on");
print qq(>Philosophie<br>\n);
print qq(<input type="checkbox" name="wahl_psychologie");
print qq( checked) if ($wahl_psychologie eq "on");
print qq(>Psychologie<br>\n);
print qq(<input type="checkbox" name="wahl_astronomie");
print qq( checked) if ($wahl_astronomie eq "on");
print qq(>Astronomie<br>\n);
print qq(<input type="checkbox" name="wahl_geometrie");
print qq( checked) if ($wahl_geometrie eq "on");
print qq(>Darstellende Geometrie<br>\n);
print qq(<input type="checkbox" name="wahl_cas");
print qq( checked) if ($wahl_cas eq "on");
print qq(>Problemlsen mit einem Computer-Algebra-System<br>\n);
print qq(<input type="checkbox" name="wahl_geologie");
print qq( checked) if ($wahl_geologie eq "on");
print qq(>Geologie<br>\n);
print qq(<input type="checkbox" name="wahl_informatik");
print qq( checked) if ($wahl_informatik eq "on");
print qq(>Informatik<br>\n);

print qq(<h2>Sonstiges</h2>\n);
print qq(<input type="checkbox" name="wahl_seminarkurs");
print qq( checked) if ($wahl_seminarkurs eq "on");
print qq(>Seminarkurs als Ersatz fr die 2. Naturwissenschaft<br>\n);
print qq(<input type="checkbox" name="wahl_lernleistung");
print qq( checked) if ($wahl_lernleistung eq "on");
print qq(>Besondere Lernleistung/Seminarkurs als Ersatz fr das 5. (mndliche) Prfungsfach<br>\n);
print qq(<input type="checkbox" name="wahl_facharbeit");
print qq( checked) if ($wahl_facharbeit eq "on");
print qq(>Facharbeit<br>\n);


print qq(<p>\n);
print qq(<input type="hidden" name="page" value="1">\n);
print qq(<input type="submit" value="weiter">\n);
print qq(<input type="reset" value="Eingaben lschen">\n);
print qq(</form>\n);

print $bottom_line;
}

sub check_wahl {
  $error_wahl = "";

  # Fremdsprache: ein und dieselbe Sprache darf nicht
  # mehrmals vorkommen
  if  ($kern_sprache eq $profilfach) {
    $error_wahl .= "Dieselbe Sprache als Kernkompetenzfach und als Profilfach!<br>\n";
  }
  if ($kern_sprache eq $wahl_sprache) {
    $error_wahl .= "Dieselbe Sprache als Kernkompetenzfach und als Wahlfach!<br>\n";
  }
  if ($profilfach eq $wahl_sprache) {
    $error_wahl .= "Dieselbe Sprache als Profilfach und als Wahlfach!<br>\n";
  }

  # Profilfach: Darf nicht auch als 2stndiges Fach vorkommen
  if ($profilfach eq "Biologie" && $biologie2 eq "on") {
    $error_wahl .= "Biologie sowohl als Profilfach als auch als 2stndiger Kurs!<br>\n";
  }
  if ($profilfach eq "Chemie" && $chemie2 eq "on") {
    $error_wahl .= "Chemie sowohl als Profilfach als auch als 2stndiger Kurs!<br>\n";
  }
  if ($profilfach eq "Physik" && $physik2 eq "on") {
    $error_wahl .= "Physik sowohl als Profilfach als auch als 2stndiger Kurs!<br>\n";
  }

  # Profilfach: Darf nicht gleich dem Neigungsfach sein
  if ($profilfach eq $neigungsfach) {
    $error_wahl .= "Profilfach und Neigungsfach sind identisch!<br>\n";
  }

  # Neigungsfach: Darf nicht auch als 2stndiges Fach vorkommen
  if ($neigungsfach eq "Musik" && $musik2 eq "on") {
    $error_wahl .= "Musik sowohl als Neigungsfach als auch als 2stndiger Kurs!<br>\n";
  }
  if ($neigungsfach eq "Bildende Kunst" && $kunst2 eq "on") {
    $error_wahl .= "Bildende Kunst sowohl als Neigungsfach als auch als 2stndiger Kurs!<br>\n";
  }
  if ($neigungsfach eq "Geschichte" && $geschichte2 eq "on") {
    $error_wahl .= "Geschichte sowohl als Neigungsfach als auch als 2stndiger Kurs!<br>\n";
  }
  if ($neigungsfach eq "Erdkunde" && $erdkunde2 eq "on") {
    $error_wahl .= "Erdkunde sowohl als Neigungsfach als auch als 2stndiger Kurs!<br>\n";
  }
  if ($neigungsfach eq "Gemeinschaftskunde" && $gemeinschaftskunde2 eq "on") {
    $error_wahl .= "Gemeinschaftskunde sowohl als Neigungsfach als auch als 2stndiger Kurs!<br>\n";
  }
  if ($neigungsfach eq "Religionslehre" && $religion2 eq "on") {
    $error_wahl .= "Religionslehre sowohl als Neigungsfach als auch als 2stndiger Kurs!<br>\n";
  }
  if ($neigungsfach eq "Ethik" && $ethik2 eq "on") {
    $error_wahl .= "Ethik sowohl als Neigungsfach als auch als 2stndiger Kurs!<br>\n";
  }
  if ($neigungsfach eq "Physik" && $physik2 eq "on") {
    $error_wahl .= "Physik sowohl als Neigungsfach als auch als 2stndiger Kurs!<br>\n";
  }
  if ($neigungsfach eq "Chemie" && $chemie2 eq "on") {
    $error_wahl .= "Chemie sowohl als Neigungsfach als auch als 2stndiger Kurs!<br>\n";
  }
  if ($neigungsfach eq "Biologie" && $biologie2 eq "on") {
    $error_wahl .= "Biologie sowohl als Neigungsfach als auch als 2stndiger Kurs!<br>\n";
  }
  if ($neigungsfach eq "Sport" && $sport2 eq "on") {
    $error_wahl .= "Sport sowohl als Neigungsfach als auch als 2stndiger Kurs!<br>\n";
  }

  # Geschichte/Gemeinschaftskunde/Erdkunde mssen alle irgendwo
  # vertreten sein
  if ($neigungsfach eq "Geschichte") {
    if ($gemeinschaftskunde2 ne "on" && $erdkunde2 ne "on") {
      $error_wahl .= "Gemeinschaftskunde und/oder Erdkunde fehlen als 2stndige Kurse!<br>\n";
    }
  }
  if ($neigungsfach eq "Erdkunde") {
    if ($geschichte2 ne "on" && $gemeinschaftskunde2 ne "on") {
      $error_wahl .= "Geschichte und/oder Gemeinschaftskunde fehlen als 2stndige Kurse!<br>\n";
    }
  }
  if ($neigungsfach eq "Gemeinschaftskunde") {
    if ($geschichte2 ne "on" && $erdkunde2 ne "on") {
      $error_wahl .= "Geschichte und/oder Erdkunde fehlen als 2stndige Kurse!<br>\n";
    }
  }
  if (($neigungsfach ne "Geschichte" && $geschichte2 ne "on") ||
      ($neigungsfach ne "Erdkunde" && $erdkunde2 ne "on") ||
      ($neigungsfach ne "Gemeinschaftskunde" && $gemeinschaftskunde2 ne "on")) {
    $error_wahl .= "Geschichte, Gemeinschaftskunde und/oder Erdkunde fehlen!<br>\n";
  }


  # Musik oder Bildende Kunst, mind. 1 muss vertreten sein
  if ($neigungsfach ne "Musik" &&
      $neigungsfach ne "Bildende Kunst" &&
      $musik2 ne "on" &&
      $kunst2 ne "on") {
    $error_wahl .= "Weder Musik noch Bildende Kunst gewhlt!<br>\n";
  }

  # Religionslehre oder Ethik, eins von beiden
  if ($neigungsfach ne "Religionslehre" &&
      $neigungsfach ne "Ethik" &&
      $religion2 ne "on" &&
      $ethik2 ne "on") {
    $error_wahl .= "Weder Religionslehre noch Ethik gewhlt!<br>\n";
  }

  # zwei Naturwissenschaften
  my $anzahl = 0;
  if ($profilfach eq "Biologie" ||
      $profilfach eq "Chemie" ||
      $profilfach eq "Physik") {
    $anzahl++;
  }
  if ($neigungsfach eq "Biologie" ||
      $neigungsfach eq "Chemie" ||
      $neigungsfach eq "Physik") {
    $anzahl++;
  }
  $anzahl++ if ($biologie2 eq "on");
  $anzahl++ if ($chemie2 eq "on");
  $anzahl++ if ($physik2 eq "on");
  $anzahl++ if ($wahl_seminarkurs eq "on");

  if ($anzahl < 2) {
    $error_wahl .= "Zu wenig Naturwissenschaften. Mindestens 2 whlen!<br>\n";
  }

  # Sport muss nicht unbedingt gewhlt werden....
  # es gibt auch Schler, die aus gesundheitlichen Grnden keinen
  # Sport machen knnen.
  #
  # Sport
  #if ($neigungsfach ne "Sport" && $sport2 ne "on") {
  #  $error_wahl .= "Kein Sport gewhlt!<br>\n";
  #}


}

sub count_faecher_stunden {
  $anzahl_faecher = 0;
  $anzahl_stunden = 0;

  ## Kernkompetenz: D, M, Sprache
  $anzahl_faecher += 3;
  $anzahl_stunden += 3*4;

  ## Profilfach:
  $anzahl_faecher += 1;
  $anzahl_stunden += 4;

  ## Neigungsfach:
  $anzahl_faecher += 1;
  $anzahl_stunden += 4;

  ## 2stndige Kurse:
  if ($geschichte2 eq "on") {
    $anzahl_faecher += 1;
    $anzahl_stunden += 2;
  }
  if ($gemeinschaftskunde2 eq "on" &&
      $erdkunde2 eq "on") {
    $anzahl_faecher += 2;
    $anzahl_stunden += 2;
  }

  if ($gemeinschaftskunde2 ne "on" &&
      $erdkunde2 eq "on") {
    $anzahl_faecher += 1;
    $anzahl_stunden += 1;
  }

  if ($musik2 eq "on") {
    $anzahl_faecher += 1;
    $anzahl_stunden += 2;
  }
  if ($kunst2 eq "on") {
    $anzahl_faecher += 1;
    $anzahl_stunden += 2;
  }

  # Religionslehre
  $anzahl_faecher += 1;
  $anzahl_stunden += 2;

  if ($biologie2 eq "on") {
    $anzahl_faecher += 1;
    $anzahl_stunden += 2;
  }
  if ($chemie2 eq "on") {
    $anzahl_faecher += 1;
    $anzahl_stunden += 2;
  }
  if ($physik2 eq "on") {
    $anzahl_faecher += 1;
    $anzahl_stunden += 2;
  }

  if ($sport2 eq "on") {
    $anzahl_faecher += 1;
    $anzahl_stunden += 2;
  }

  if ($wahl_sprache ne "keine") {
    $anzahl_faecher += 1;
    $anzahl_stunden += 4;
  }
  if ($wahl_literatur eq "on") {
    $anzahl_faecher += 1;
    $anzahl_stunden += 2;
  }
  if ($wahl_philosophie eq "on") {
    $anzahl_faecher += 1;
    $anzahl_stunden += 2;
  }
  if ($wahl_psychologie eq "on") {
    $anzahl_faecher += 1;
    $anzahl_stunden += 2;
  }
  if ($wahl_astronomie eq "on") {
    $anzahl_faecher += 1;
    $anzahl_stunden += 2;
  }
  if ($wahl_geometrie eq "on") {
    $anzahl_faecher += 1;
    $anzahl_stunden += 2;
  }
  if ($wahl_cas eq "on") {
    $anzahl_faecher += 1;
    $anzahl_stunden += 2;
  }
  if ($wahl_geologie eq "on") {
    $anzahl_faecher += 1;
    $anzahl_stunden += 2;
  }
  if ($wahl_informatik eq "on") {
    $anzahl_faecher += 1;
    $anzahl_stunden += 2;
  }

}

sub print_page2 {
  print <<HTML;
<html>
<head>
  <title>Oberstufen-Rechner - Schritt 2: Noteneingabe</title>
  <style type="text/css">
  input {
    text-align: center;
  }
  </style>
</head>
<body>
<h1>Oberstufen-Rechner - Schritt 2: Noteneingabe</h1>
Anzahl der Fcher: <strong>$anzahl_faecher</strong><br>
Anzahl der Wochenstunden: <strong>$anzahl_stunden</strong> (Jahresdurchschnitt)
<p>

HTML

  if ($error_pruef ne "") {
    print qq(<p><font color="red"><strong>FEHLER:<br>$error_pruef</strong></font>\n);
  }

  if ($error_noten ne "") {
    print qq(<p><font color="red"><strong>FEHLER:<br>$error_noten</strong></font>\n);
  }

  print <<HTML;
<form method="post">
<h2>I. Leistungen in den beiden Jahrgangsstufen</h2>
<table border="1" cellpadding="3" cellspacing="0">
<tr><th>Fach</th><th colspan="4">Punktzahlen in einfacher Wertung</th></tr>
<tr><td></td><td align="center">1.HJ</td><td align="center">2.HJ</td><td align="center">3.HJ</td><td align="center">4.HJ</td></tr>
<tr><td colspan="5"><b>Sprachlich-literarisch-knstlerisches Aufgabenfeld</b></td></tr>
HTML

  print &noten_zeile("Deutsch");
  ## Sprachen: z.B. Kernkompetenz und Profilfach
  print &noten_zeile($kern_sprache);
  print &noten_zeile($profilfach, "(P)") if ($profilfach eq "Englisch" ||
                                             $profilfach eq "Franzsisch" ||
                                             $profilfach eq "Latein");
  print &noten_zeile($neigungsfach, "(N)") if ($neigungsfach eq "Musik");
  print &noten_zeile($neigungsfach, "(N)") if ($neigungsfach eq "Bildende Kunst");
  print &noten_zeile("Musik") if ($musik2 eq "on");
  print &noten_zeile("Bildende Kunst") if ($kunst2 eq "on");

  print qq(<tr><td colspan="5"><b>Gesellschaftswissenschaftliches  Aufgabenfeld</b></td></tr>\n);
  print &noten_zeile($neigungsfach, "(N)") if ($neigungsfach eq "Geschichte");
  print &noten_zeile($neigungsfach, "(N)") if ($neigungsfach eq "Gemeinschaftskunde");
  print &noten_zeile($neigungsfach, "(N)") if ($neigungsfach eq "Erdkunde");
  print &noten_zeile($neigungsfach, "(N)") if ($neigungsfach eq "Religionslehre");
  print &noten_zeile($neigungsfach, "(N)") if ($neigungsfach eq "Ethik");

  if ($neigungsfach eq "Geschichte") {
    print &noten_zeile("Gemeinschaftskunde/Erdkunde");
  } elsif ($neigungsfach eq "Gemeinschaftskunde") {
    print &noten_zeile("Geschichte/Erdkunde");
  } elsif ($neigungsfach eq "Erdkunde") {
    print &noten_zeile("Geschichte/Gemeinschaftskunde");
  } else {
    print &noten_zeile("Geschichte/Gemeinschaftskunde/Erdkunde");
  }

  print &noten_zeile("Religionslehre") if ($religion2 eq "on");
  print &noten_zeile("Ethik") if ($ethik2 eq "on");

  print qq(<tr><td colspan="5"><b>Mathematisch-naturwissenschaftlich-technisches Aufgabenfeld</b></td></tr>\n);
  print &noten_zeile("Mathematik");
  print &noten_zeile($profilfach, "(P)") if ($profilfach eq "Biologie" ||
                                             $profilfach eq "Chemie" ||
                                             $profilfach eq "Physik");
  print &noten_zeile($neigungsfach, "(N)") if ($neigungsfach eq "Biologie" ||
                                               $neigungsfach eq "Chemie" ||
                                               $neigungsfach eq "Physik");
  print &noten_zeile("Biologie") if ($biologie2 eq "on");
  print &noten_zeile("Chemie") if ($chemie2 eq "on");
  print &noten_zeile("Physik") if ($physik2 eq "on");

  print qq(<tr><td colspan="5"></td></tr>\n);
  print &noten_zeile($neigungsfach, "(N)") if ($neigungsfach eq "Sport");
  print &noten_zeile("Sport") if ($sport2 eq "on");

  $wahl_literatur = "off" if (not defined($wahl_literatur));
  $wahl_philosophie = "off" if (not defined($wahl_philosophie));
  $wahl_psychologie = "off" if (not defined($wahl_psychologie));
  $wahl_astronomie = "off" if (not defined($wahl_astronomie));
  $wahl_geometrie = "off" if (not defined($wahl_geometrie));
  $wahl_cas = "off" if (not defined($wahl_cas));
  $wahl_geologie = "off" if (not defined($wahl_geologie));
  $wahl_informatik = "off" if (not defined($wahl_informatik));


  if ($wahl_sprache ne "keine" ||
      $wahl_literatur ne "off" || $wahl_philosophie ne "off" ||
      $wahl_psychologie ne "off" || $wahl_astronomie ne "off" ||
      $wahl_geometrie ne "off" || $wahl_cas ne "off" ||
      $wahl_geologie ne "off" || $wahl_informatik ne "off") {
    print qq(<tr><td colspan="5"><b>Wahlbereich</b></td></tr>\n);
    print &noten_zeile($wahl_sprache) if ($wahl_sprache ne "keine");
    print &noten_zeile("Literatur") if ($wahl_literatur eq "on");
    print &noten_zeile("Philosophie") if ($wahl_philosophie eq "on");
    print &noten_zeile("Psychologie") if ($wahl_psychologie eq "on");
    print &noten_zeile("Astronomie") if ($wahl_astronomie eq "on");
    print &noten_zeile("Geometrie") if ($wahl_geometrie eq "on");
    print &noten_zeile("CAS") if ($wahl_cas eq "on");
    print &noten_zeile("Geologie") if ($wahl_geologie eq "on");
    print &noten_zeile("Informatik") if ($wahl_informatik eq "on");
  }

  if ($wahl_lernleistung eq "on" || $wahl_seminarkurs eq "on" ||
      $wahl_facharbeit eq "on") {
    print qq(<tr><td colspan="5"><b>Sonstiges</b></td></tr>\n);
  }
  if ($wahl_seminarkurs eq "on") {
    print qq(<tr><td>Seminarkurs</td>);
    my $note = "-";
    $note = $q->param("seminarkurs_noten") if (defined($q->param("seminarkurs_noten")));
    print qq(<td align="center" colspan="4"><input type="text" size="2" maxlength="2" name="seminarkurs_noten" value="$note"></td>);
    print qq(</tr>\n);
  }
  if ($wahl_lernleistung eq "on") {
    print qq(<tr><td>Besondere Lernleistung</td>);
    my $note = "-";
    $note = $q->param("lernleistung_noten") if (defined($q->param("lernleistung_noten")));
    print qq(<td align="center" colspan="4"><input type="text" size="2" maxlength="2" name="lernleistung_noten" value="$note"></td>);
    print qq(</tr>\n);
  }
  if ($wahl_facharbeit eq "on") {
    print qq(<tr><td>Facharbeit</td>);
    my $note = "-";
    $note = $q->param("facharbeit_noten") if (defined($q->param("facharbeit_noten")));
    print qq(<td align="center" colspan="4"><input type="text" size="2" maxlength="2" name="facharbeit_noten" value="$note"></td>);
    print qq(</tr>\n);
  }

  print qq(</table>\n);

  print qq(<h2>II. Leistungen in der Abiturprfung</h2>\n);
  print qq(<table border="1" cellpadding="3" cellspacing="0">\n);
  print qq(<tr><th>Prfungsfach</th><th colspan="2">Punktzahlen in einfacher Wertung</th><th colspan="2">Doppelt gewichten</th></tr>\n);
  print qq(<tr><td></td><td align="center">schriftlich</td><td align="center">mndlich</td><td>1. Fach</td><td>2. Fach</td></tr>\n);

  print qq(<tr><td>1. Deutsch (Kernkompetenz)</td>\n);
  my $note = "-";
  $note = $q->param("Deutsch_Pruef_S_noten") if (defined($q->param("Deutsch_Pruef_S_noten")));
  print qq(    <td align="center"><input type="text" size="2" maxlength="2" name="Deutsch_Pruef_S_noten" value="$note"></td>\n);
  $note = "-";
  $note = $q->param("Deutsch_Pruef_M_noten") if (defined($q->param("Deutsch_Pruef_M_noten")));
  print qq(    <td align="center"><input type="text" size="2" maxlength="2" name="Deutsch_Pruef_M_noten" value="$note"></td>\n);
  print qq(    <td align="center"><input type="radio" name="Doppel_Fach1" value="1"></td>\n);
  print qq(    <td align="center"><input type="radio" name="Doppel_Fach2" value="1"></td>\n);
  print qq(</tr>\n);
  print qq(<tr><td>2. );
  print qq(<input type="hidden" name="Pruef_Fach2" value="$kern_sprache">);
  print qq($kern_sprache (Kernkompetenz)</td>\n);
  $note = "-";
  $note = $q->param("Fach2_Pruef_S_noten") if (defined($q->param("Fach2_Pruef_S_noten")));
  print qq(    <td align="center"><input type="text" size="2" maxlength="2" name="Fach2_Pruef_S_noten" value="$note"></td>\n);
  $note = "-";
  $note = $q->param("Fach2_Pruef_M_noten") if (defined($q->param("Fach2_Pruef_M_noten")));
  print qq(    <td align="center"><input type="text" size="2" maxlength="2" name="Fach2_Pruef_M_noten" value="$note"></td>\n);
  print qq(    <td align="center"><input type="radio" name="Doppel_Fach1" value="2"></td>\n);
  print qq(    <td align="center"><input type="radio" name="Doppel_Fach2" value="2"></td>\n);
  print qq(</tr>\n);
  print qq(<tr><td>3. Mathematik (Kernkompetenz)</td>\n);
  $note = "-";
  $note = $q->param("Mathematik_Pruef_S_noten") if (defined($q->param("Mathematik_Pruef_S_noten")));
  print qq(    <td align="center"><input type="text" size="2" maxlength="2" name="Mathematik_Pruef_S_noten" value="$note"></td>\n);
  $note = "-";
  $note = $q->param("Mathematik_Pruef_M_noten") if (defined($q->param("Mathematik_Pruef_M_noten")));
  print qq(    <td align="center"><input type="text" size="2" maxlength="2" name="Mathematik_Pruef_M_noten" value="$note"></td>\n);
  print qq(    <td align="center"><input type="radio" name="Doppel_Fach1" value="3"></td>\n);
  print qq(    <td align="center"><input type="radio" name="Doppel_Fach2" value="3"></td>\n);
  print qq(</tr>\n);
  $selected = "";
  $selected = " selected" if ($Pruef_Fach4 eq $profilfach);
  print qq(<tr><td>4. <select name="Pruef_Fach4"><option$selected>$profilfach);
  $selected = "";
  $selected = " selected" if ($Pruef_Fach4 eq $neigungsfach);
  print qq(<option$selected>$neigungsfach);
  print qq(</select> (Neigungs-/Profilfach)</td>\n);
  $note = "-";
  $note = $q->param("Fach4_Pruef_S_noten") if (defined($q->param("Fach4_Pruef_S_noten")));
  print qq(    <td align="center"><input type="text" size="2" maxlength="2" name="Fach4_Pruef_S_noten" value="$note"></td>\n);
  $note = "-";
  $note = $q->param("Fach4_Pruef_M_noten") if (defined($q->param("Fach4_Pruef_M_noten")));
  print qq(    <td align="center"><input type="text" size="2" maxlength="2" name="Fach4_Pruef_M_noten" value="$note"></td>\n);
  print qq(    <td align="center"><input type="radio" name="Doppel_Fach1" value="4"></td>\n);
  print qq(    <td align="center"><input type="radio" name="Doppel_Fach2" value="4"></td>\n);
  print qq(</tr>\n);
  print qq(<tr><td>5. <select name="Pruef_Fach5">);
  $selected = "";
  $selected = " selected" if ($Pruef_Fach5 eq $profilfach);
  print qq(<option$selected>$profilfach);
  $selected = "";
  $selected = " selected" if ($Pruef_Fach5 eq $neigungsfach);
  print qq(<option$selected>$neigungsfach);
  $selected = "";
  $selected = " selected" if ($Pruef_Fach5 eq "Geschichte");
  print qq(<option$selected>Geschichte) if ($geschichte2 eq "on");
  $selected = "";
  $selected = " selected" if ($Pruef_Fach5 eq "Gemeinschaftskunde");
  print qq(<option$selected>Gemeinschaftskunde) if ($gemeinschaftskunde2 eq "on");
  $selected = "";
  $selected = " selected" if ($Pruef_Fach5 eq "Erdkunde");
  print qq(<option$selected>Erdkunde) if ($erdkunde2 eq "on");
  $selected = "";
  $selected = " selected" if ($Pruef_Fach5 eq "Musik");
  print qq(<option$selected>Musik) if ($musik2 eq "on");
  $selected = "";
  $selected = " selected" if ($Pruef_Fach5 eq "Bildende Kunst");
  print qq(<option$selected>Bildende Kunst) if ($kunst2 eq "on");
  $selected = "";
  $selected = " selected" if ($Pruef_Fach5 eq "Religionslehre");
  print qq(<option$selected>Religionslehre) if ($religion2 eq "on");
  $selected = "";
  $selected = " selected" if ($Pruef_Fach5 eq "Ethik");
  print qq(<option$selected>Ethik) if ($ethik2 eq "on");
  $selected = "";
  $selected = " selected" if ($Pruef_Fach5 eq "Biologie");
  print qq(<option$selected>Biologie) if ($biologie2 eq "on");
  $selected = "";
  $selected = " selected" if ($Pruef_Fach5 eq "Chemie");
  print qq(<option$selected>Chemie) if ($chemie2 eq "on");
  $selected = "";
  $selected = " selected" if ($Pruef_Fach5 eq "Physik");
  print qq(<option$selected>Physik) if ($physik2 eq "on");
  $selected = "";
  $selected = " selected" if ($Pruef_Fach5 eq "Sport");
  print qq(<option$selected>Sport) if ($sport2 eq "on");
  $selected = "";
  $selected = " selected" if ($Pruef_Fach5 eq "Besondere Lernleistung");
  print qq(<option$selected>Besondere Lernleistung) if ($wahl_lernleistung eq "on");
  $selected = "";
  $selected = " selected" if ($Pruef_Fach5 eq $wahl_sprache);
  print qq(<option$selected>$wahl_sprache) if ($wahl_sprache ne "keine");
  $selected = "";
  $selected = " selected" if ($Pruef_Fach5 eq "Informatik");
  print qq(<option$selected>Informatik) if ($wahl_informatik eq "on");
  print qq(</select> (Prsentationsprfung)</td>\n);
  print qq(    <td align="center">-</td>\n);
  $note = "-";
  $note = $q->param("Fach5_Pruef_M_noten") if (defined($q->param("Fach5_Pruef_M_noten")));
  print qq(    <td align="center"><input type="text" size="2" maxlength="2" name="Fach5_Pruef_M_noten" value="$note"></td>\n);
  print qq(</tr>\n);

  print qq(</table>\n);


  ## alte Parameter senden...
  foreach $name ($q->param) {
    my $value = $q->param($name);
    next if ($name eq "page");
    next if ($name =~ m/\_noten/);
    next if ($name =~ m/Pruef/);
    next if ($name eq "button_ohne_abi");

    print qq(<input type="hidden" name="$name" value="$value">\n);
  }


  print qq(<p>\n);
  print qq(<input type="submit" name="button_ohne_abi" value="ohne die Noten der Abiturprfung weiter"> (Bitte trotzdem das 4. und 5. Prfungsfach whlen!)<br>\n);
  print qq(<input type="hidden" name="page" value="2">\n);
  print qq(<input type="submit" name="back_button" value="zurck">\n);
  print qq(<input type="submit" value="weiter">\n);
  print qq(<input type="reset" value="Eingaben lschen"><br>\n);
  print qq(<input type="checkbox" name="debug">Debug-Ausgaben...\n);
  print qq(</form>\n);

  print $bottom_line;
}

sub noten_zeile {
  $fach = shift;
  $zeichen = shift;
  $name = $fach;

  $spezialfall = 0;

  if (not defined($zeichen)) {
    $spezialfall = 1 if ($fach =~ m/Geschichte/ ||
                         $fach =~ m/Gemeinschaftskunde/ ||
                         $fach =~ m/Erdkunde/);
  }

  if (not defined($zeichen)) {
    $zeichen = "";
  } else {
    $zeichen = " $zeichen";
  }

  if ($spezialfall == 1) {
    $fach = "G_Gk_Ek";
  }

  $return = qq(<tr><td>${name}${zeichen}</td>\n);
  my @noten = $q->param("${fach}_noten");
  my $index = 0;
  for (0..3) {
    $noten[$_] = "-" if (not defined($noten[$_]));
  }
  $return .= qq(    <td align="center"><input type="text" size="2" maxlength="2" name="${fach}_noten" value="$noten[$index++]"></td>\n);
  $return .= qq(    <td align="center"><input type="text" size="2" maxlength="2" name="${fach}_noten" value="$noten[$index++]"></td>\n);
  $return .= qq(    <td align="center"><input type="text" size="2" maxlength="2" name="${fach}_noten" value="$noten[$index++]"></td>\n);
  $return .= qq(    <td align="center"><input type="text" size="2" maxlength="2" name="${fach}_noten" value="$noten[$index++]"></td>\n);
  $return .= qq(</tr>\n);

  return $return;
}

sub check_noten {
  $error_noten = "";

  foreach $name (@noten_faecher) {
    my @noten = $q->param($name);
    my $anzahl = 0;
    foreach $note (@noten) {
      next if ($note eq "-");
      next if ($note eq "");
      $note =~ m/(\d+)/;
      my $punkte = $1;
      if ($punkte >= 0 && $punkte <= 15 && $punkte ne "") {
        $anzahl++;
      }
    }

    if ($name =~ m/Literatur/ || $name =~ /Philosophie/ ||
        $name =~ /Psychologie/ || $name =~ /Astronomie/ ||
        $name =~ /Geometrie/ || $name =~ /CAS/ ||
        $name =~ /Geologie/) {
      if ($anzahl != 2) {
        $name =~ s/\_noten//;
        $error_noten .= "$name muss darf maximal 2 Kurse haben...<br>\n";
      }
    } elsif ($anzahl != 4) {
      if ($name =~ m/Pruef/) {
        next;
      } elsif ($name =~ m/seminarkurs/) {
        if ($anzahl != 1) {
          $error_noten .= "Die Note fr den Seminarkurs fehlt...<br>\n";
        }
      } elsif ($name =~ m/lernleistung/) {
        if ($anzahl != 1) {
          $error_noten .= "Die Note fr die Besondere Lernleistung fehlt...<br>\n";
        }
      } elsif ($name =~ m/facharbeit/) {
        if ($anzahl != 1) {
          $error_noten .= "Die Note fr die Facharbeit fehlt...<br>\n";
        }
      } elsif ($name =~ m/G_Gk_Ek/) {
        $error_noten .= "Geschichte-, Gemeinschaftskunde- und/oder Erdkunde-Noten fehlen...<br>\n";
      } else {
        $name =~ s/\_noten//;
        $error_noten .= "$name-Noten fehlen...<br>\n";
      }
    }
  }

  # Prfungsnoten zhlen
  # oder ohne Noten weiter?
  if (defined($q->param("button_ohne_abi"))) {
    return;
  }

  my $muendliche = 0;
  if ($q->param("Deutsch_Pruef_S_noten") !~ m/\d+/) {
    $error_noten .= "Die Prfungsnote von Deutsch (schriftlich) fehlt...<br>\n";
  }
  if ($q->param("Fach2_Pruef_S_noten") !~ m/\d+/) {
    $error_noten .= "Die Prfungsnote von $Pruef_Fach2 (schriftlich) fehlt...<br>\n";
  }
  if ($q->param("Mathematik_Pruef_S_noten") !~ m/\d+/) {
    $error_noten .= "Die Prfungsnote von Mathematik (schriftlich) fehlt...<br>\n";
  }
  if ($q->param("Fach4_Pruef_S_noten") !~ m/\d+/) {
    $error_noten .= "Die Prfungsnote von $Pruef_Fach4 (schriftlich) fehlt...<br>\n";
  }
  if ($q->param("Fach5_Pruef_M_noten") !~ m/\d+/) {
    if ($q->param("Pruef_Fach5") ne "Besondere Lernleistung") {
      $error_noten .= "Die Prfungsnote von $Pruef_Fach5 (mndlich) fehlt...<br>\n";
    }
  }
  $muendliche++ if ($q->param("Deutsch_Pruef_M_noten") =~ m/\d+/);
  $muendliche++ if ($q->param("Fach2_Pruef_M_noten") =~ m/\d+/);
  $muendliche++ if ($q->param("Mathematik_Pruef_M_noten") =~ m/\d+/);
  $muendliche++ if ($q->param("Fach4_Pruef_M_noten") =~ m/\d+/);
  
  # Version 1.7: es ist inzwischen nur noch die Prsentationsprfung Pflicht
  # als mndliche Prfung.
  #if ($muendliche == 0) {
  #  $error_noten .= "Die 2. mndliche Prfungsnote fehlt...<br>\n";
  #}
  # es drfen ja mehrere mndliche prfungen besucht werden...
  #elsif ($muendliche > 1) {
  #  $error_noten .= "Zuviele mndliche Prfungsnoten!!<br>\n";
  #}
}

sub check_pruef {
  $error_pruef = "";

  # Prfungsfcher 2 und 4 drfen nicht gleich sein
  if ($Pruef_Fach2 eq $Pruef_Fach4) {
    $error_pruef .= "$Pruef_Fach2 ist sowohl 2. als auch 4. Prfungsfach!<br>\n";
  }
  # 2 muss != 5 sein
  if ($Pruef_Fach2 eq $Pruef_Fach5) {
    $error_pruef .= "$Pruef_Fach2 ist sowohl 2. als auch 5. Prfungsfach!<br>\n";
  }
  # 4 muss != 5 sein
  if ($Pruef_Fach4 eq $Pruef_Fach5) {
    $error_pruef .= "$Pruef_Fach4 ist sowohl 4. als auch 5. Prfungsfach!<br>\n";
  }

  # Aufgabenfelder Prfen!!
  if ($Pruef_Fach4 eq "Englisch" || $Pruef_Fach4 eq "Franzsisch" ||
      $Pruef_Fach4 eq "Latein" || $Pruef_Fach4 eq "Physik" ||
      $Pruef_Fach4 eq "Chemie" || $Pruef_Fach4 eq "Biologie" ||
      $Pruef_Fach4 eq "Bildende Kunst" ||
      $Pruef_Fach4 eq "Musik" || $Pruef_Fach4 eq "Sport") {
    if ($Pruef_Fach5 ne "Geschichte" && $Pruef_Fach5 ne "Erdkunde" &&
        $Pruef_Fach5 ne "Gemeinschaftskunde" && $Pruef_Fach5 ne "Religionslehre" &&
        $Pruef_Fach5 ne "Ethik" && $Pruef_Fach5 ne "Besondere Lernleistung") {
      $error_pruef .= "Mit den Prfungsfchern werden nicht alle Aufgabenfelder abgedeckt!<br>\n";
    }
  } elsif ($Pruef_Fach4 eq "Geschichte" || $Pruef_Fach4 eq "Erdkunde" ||
           $Pruef_Fach4 eq "Gemeinschaftskunde" || $Pruef_Fach4 eq "Religionslehre" ||
           $Pruef_Fach4 eq "Ethik") {
    if ($Pruef_Fach5 ne "Physik" && $Pruef_Fach5 ne "Chemie" &&
        $Pruef_Fach5 ne "Biologie" &&
        $Pruef_Fach5 ne $wahl_sprache &&
        $Pruef_Fach5 ne "Bildende Kunst" &&
        $Pruef_Fach5 ne "Musik" && $Pruef_Fach5 ne "Geschichte" &&
        $Pruef_Fach5 ne "Erdkunde" && $Pruef_Fach5 ne "Gemeinschaftskunde" &&
        $Pruef_Fach5 ne "Religionslehre" && $Pruef_Fach5 ne "Ethik" &&
        $Pruef_Fach5 ne "Informatik" && $Pruef_Fach5 ne "Sport" &&
        $Pruef_Fach5 ne "Besondere Lernleistung") {
      $error_pruef .= "Mit den Prfungsfchern werden nicht alle Aufgabenfelder abgedeckt!<br>\n";
    }
  }
}

sub print_page3 {
  print <<HTML;
<html>
<head>
  <title>Oberstufen-Rechner - Ergebnis</title>
</head>
<body>
<h1>Oberstufen-Rechner - Ergebnis</h1>

HTML

  my $DEBUG = "";

  ## Auswertung...

  # ZWEITER BLOCK BERECHNEN
  # 1. Die 2 schriftlichen Prfungsfcher feststellen, die
  #    doppelt gewertet werden sollen...
  #    Das sind diejenigen mit der meisten Punktzahl in der Summe
  #    Dabei muss darunter mindestens ein Kernkompetenzfach sein
  my $fach1_punkte = 0;
  my @noten;
  my @liste;
  push(@liste, "1");
  push(@liste, "2");
  push(@liste, "3");
  push(@liste, "4");

  @noten = $q->param("Deutsch_noten");
  for (0..2) {
    $fach1_punkte += 2 * $noten[$_];
  }
  $fach1_punkte += $noten[3];
  my $fach2_punkte = 0;
  @noten = $q->param($q->param("Pruef_Fach2") . "_noten");
  for (0..2) {
    $fach2_punkte += 2 * $noten[$_];
  }
  $fach2_punkte += $noten[3];
  my $fach3_punkte = 0;
  @noten = $q->param("Mathematik_noten");
  for (0..2) {
    $fach3_punkte += 2 * $noten[$_];
  }
  $fach3_punkte += $noten[3];
  my $fach4_punkte = 0;
  @noten = $q->param($q->param("Pruef_Fach4") . "_noten");
  for (0..2) {
    $fach4_punkte += 2 * $noten[$_];
  }
  $fach4_punkte += $noten[3];

  # @liste sortieren
  @liste = sort {
    $c = $fach1_punkte if ($a eq "1");
    $c = $fach2_punkte if ($a eq "2");
    $c = $fach3_punkte if ($a eq "3");
    $c = $fach4_punkte if ($a eq "4");
    $d = $fach1_punkte if ($b eq "1");
    $d = $fach2_punkte if ($b eq "2");
    $d = $fach3_punkte if ($b eq "3");
    $d = $fach4_punkte if ($b eq "4");

    $d <=> $c;
  } @liste;

  $DEBUG .= "D Deutsch: $fach1_punkte<br>\n";
  $DEBUG .= "D $Pruef_Fach2: $fach2_punkte<br>\n";
  $DEBUG .= "D Mathematik: $fach3_punkte<br>\n";
  $DEBUG .= "D $Pruef_Fach4: $fach4_punkte<br>\n";

  # spezielle Fcher doppelt gewichtet?
  # Benutzerdefiniert
  my $doppel_fach1 = $q->param("Doppel_Fach1") || 0;
  my $doppel_fach2 = $q->param("Doppel_Fach2") || 0;
  # prfen: es mssen beide fcher gewhlt sein,
  #         zwei verschiedene fcher,
  #         es muss wenigstens ein kernkomp.fach dabei sein
  if (($doppel_fach1 == 0 || $doppel_fach2 == 0)
      || ($doppel_fach1 == $doppel_fach2)
      || ($doppel_fach1 == 4 && $doppel_fach2 == 4)) {
       # Kernkompetenzfach muss dabei sein
       if ($liste[0] ne "4" || $liste[1] ne "4") {
           $doppel1 = $liste[0];
           $doppel2 = $liste[1];
       } elsif ($liste[2] ne "4") {
           $doppel1 = $liste[0];
           $doppel2 = $liste[2];
       } elsif ($liste[3] ne "4") {
           $doppel1 = $liste[0];
           $doppel2 = $liste[3];
       }
  } else {
      # Wahl bernehmen
      $doppel1 = $doppel_fach1;
      $doppel2 = $doppel_fach2;
  }
  
  # Punktzahl im 2. Block berechnen
  my $punktzahl_block2 = 0;
  $punktzahl_block2 += $fach1_punkte if ($doppel1 eq "1");
  $punktzahl_block2 += $fach2_punkte if ($doppel1 eq "2");
  $punktzahl_block2 += $fach3_punkte if ($doppel1 eq "3");
  $punktzahl_block2 += $fach4_punkte if ($doppel1 eq "4");
  $punktzahl_block2 += $fach1_punkte if ($doppel2 eq "1");
  $punktzahl_block2 += $fach2_punkte if ($doppel2 eq "2");
  $punktzahl_block2 += $fach3_punkte if ($doppel2 eq "3");
  $punktzahl_block2 += $fach4_punkte if ($doppel2 eq "4");

  # In Namen umwandeln
  # alte Werte sichern...
  my $doppel1_nr = $doppel1;
  my $doppel2_nr = $doppel2;
  $doppel1 = "Deutsch" if ($doppel1 eq "1");
  $doppel1 = $q->param("Pruef_Fach2") if ($doppel1 eq "2");
  $doppel1 = "Mathematik" if ($doppel1 eq "3");
  $doppel1 = $q->param("Pruef_Fach4") if ($doppel1 eq "4");
  $doppel2 = "Deutsch" if ($doppel2 eq "1");
  $doppel2 = $q->param("Pruef_Fach2") if ($doppel2 eq "2");
  $doppel2 = "Mathematik" if ($doppel2 eq "3");
  $doppel2 = $q->param("Pruef_Fach4") if ($doppel2 eq "4");

  my $facharbeit_gewertet = "false";
  # Wenn Facharbeit mglich....berprfen
  if ($wahl_facharbeit eq "on") {
    my $punkte = 0;
    if ($doppel1_nr eq "1") {
      @noten = $q->param("Deutsch_noten");
      $punkte += $noten[3];
    } elsif ($doppel1_nr eq "2") {
      @noten = $q->param("${Pruef_Fach2}_noten");
      $punkte += $noten[3];
    } elsif ($doppel1_nr eq "3") {
      @noten = $q->param("Mathematik_noten");
      $punkte += $noten[3];
    } elsif ($doppel1_nr eq "4") {
      @noten = $q->param("${Pruef_Fach4}_noten");
      $punkte += $noten[3];
    }
    if ($doppel2_nr eq "1") {
      @noten = $q->param("Deutsch_noten");
      $punkte += $noten[3];
    } elsif ($doppel2_nr eq "2") {
      @noten = $q->param("${Pruef_Fach2}_noten");
      $punkte += $noten[3];
    } elsif ($doppel2_nr eq "3") {
      @noten = $q->param("Mathematik_noten");
      $punkte += $noten[3];
    } elsif ($doppel2_nr eq "4") {
      @noten = $q->param("${Pruef_Fach4}_noten");
      $punkte += $noten[3];
    }

    my $punkte_facharbeit = $q->param("Facharbeit_noten");
    $punkte_facharbeit *= 2;

    if ($punkte_facharbeit > $punkte) {
      # Facharbeit ist besser....
      $punktzahl_block2 -= $punkte;
      $punktzahl_block2 += $punkte_facharbeit;
      $facharbeit_gewertet = "true";
    }
  }


  ### ERSTER BLOCK BERECHNEN / DRITTER BLOCK

  ## Tabelle anlegen...
  #    ...in ein 2-dimensionales array
  #     eine zeile:
  #     NOTE(PUNKTE) Fach    Kurs gewertet
  #      11          Deutsch  3    ja

  my @tabelle;
  &add_entry(\@tabelle, "Musik") if ($musik2 eq "on");
  &add_entry(\@tabelle, "Bildende Kunst") if ($kunst2 eq "on");
  &add_entry(\@tabelle, "Religionslehre") if ($religion2 eq "on");
  &add_entry(\@tabelle, "Ethik") if ($ethik2 eq "on");
  &add_entry(\@tabelle, "Biologie") if ($biologie2 eq "on");
  &add_entry(\@tabelle, "Chemie") if ($chemie2 eq "on");
  &add_entry(\@tabelle, "Physik") if ($physik2 eq "on");
  &add_entry(\@tabelle, "Sport") if ($sport2 eq "on");
  &add_entry(\@tabelle, $wahl_sprache) if ($wahl_sprache ne "keine");
  &add_entry(\@tabelle, "Literatur") if ($wahl_literatur eq "on");
  &add_entry(\@tabelle, "Philosophie") if ($wahl_philosophie eq "on");
  &add_entry(\@tabelle, "Psychologie") if ($wahl_psychologie eq "on");
  &add_entry(\@tabelle, "Astronomie") if ($wahl_astronomie eq "on");
  &add_entry(\@tabelle, "Geometrie") if ($wahl_geometrie eq "on");
  &add_entry(\@tabelle, "CAS") if ($wahl_cas eq "on");
  &add_entry(\@tabelle, "Geologie") if ($wahl_geologie eq "on");
  &add_entry(\@tabelle, "Informatik") if ($wahl_informatik eq "on");

  # Unterkurse zhlen
  my $unterkurse = 0;


  # die drei restlichen Prfungsfcher, die nicht doppelt
  # gewertet werden; davon jeweils die ersten drei Halbjahre
  # beim dritten block: das 4. Halbjahr dieser drei Prfungsfcher
  my $punktzahl_block1 = 0;
  my $punktzahl_block3 = 0;
  my $anzahl_block1 = 0;

  my @liste2 = grep(!/($doppel1_nr|$doppel2_nr)/, @liste);
  my $fachname_debug = "";
  if ($liste2[0] eq "1") {
    @noten = $q->param("Deutsch_noten");
    $fachname_debug = "P Deutsch";
  } elsif ($liste2[0] eq "2") {
    @noten = $q->param($q->param("Pruef_Fach2") . "_noten");
    $fachname_debug = "P " . $q->param("Pruef_Fach2");
  } elsif ($liste2[0] eq "3") {
    @noten = $q->param("Mathematik_noten");
    $fachname_debug = "P Mathematik";
  } elsif ($liste2[0] eq "4") {
    @noten = $q->param($q->param("Pruef_Fach4") . "_noten");
    $fachname_debug = "P " . $q->param("Pruef_Fach4");
  }
  $DEBUG .= $fachname_debug . ": ";
  for (0..2) {
               $punktzahl_block1 += $noten[$_];
               $DEBUG .= "$noten[$_],";
               $unterkurse++ if ($noten[$_] < 5);
  }
  $DEBUG .= "<br>\n";
  $anzahl_block1 += 3;
  $punktzahl_block3 += $noten[3];
  if ($liste2[1] eq "1") {
    @noten = $q->param("Deutsch_noten");
    $fachname_debug = "P Deutsch";
  } elsif ($liste2[1] eq "2") {
    @noten = $q->param($q->param("Pruef_Fach2") . "_noten");
    $fachname_debug = "P " . $q->param("Pruef_Fach2");
  } elsif ($liste2[1] eq "3") {
    @noten = $q->param("Mathematik_noten");
    $fachname_debug = "P Mathematik";
  } elsif ($liste2[1] eq "4") {
    @noten = $q->param($q->param("Pruef_Fach4") . "_noten");
    $fachname_debug = "P " . $q->param("Pruef_Fach4");
  }
  $DEBUG .= $fachname_debug . ": ";
  for (0..2) { $punktzahl_block1 += $noten[$_];
               $DEBUG .= "$noten[$_],";
               $unterkurse++ if ($noten[$_] < 5); }
  $DEBUG .= "<br>\n";
  $anzahl_block1 += 3;
  $punktzahl_block3 += $noten[3];

  # jetzt noch das 5. (mndliche) Prfungsfach
  # nur, wenn das 5. Prfungsfach nicht durch eine
  # Besondere Lernleistung ersetzt wurde
  if ($q->param("Pruef_Fach5") ne "Besondere Lernleistung") {
    if ((($q->param("Pruef_Fach5") eq "Erdkunde")
        || ($q->param("Pruef_Fach5") eq "Gemeinschaftskunde")
        || ($q->param("Pruef_Fach5") eq "Geschichte"))
        &&
        ($q->param("Pruef_Fach5") ne $neigungsfach)) {
      @noten = $q->param("G_Gk_Ek_noten");
      if ($neigungsfach eq "Geschichte") {
        $fachname_debug = "P Gemeinschaftskunde/Erdkunde";
      } elsif ($neigungsfach eq "Gemeinschaftskunde") {
        $fachname_debug = "P Geschichte/Erdkunde";
      } elsif ($neigungsfach eq "Erdkunde") {
        $fachname_debug = "P Geschichte/Gemeinschaftskunde";
      } else {
        $fachname_debug = "P Geschichte/Gemeinschaftskunde/Erdkunde";
      }
      $DEBUG .= $fachname_debug . ": ";
    } else {
      @noten = $q->param($q->param("Pruef_Fach5") . "_noten");
      $DEBUG .= "P " . $q->param("Pruef_Fach5") . ": ";
    }

    for (0..2) { $punktzahl_block1 += $noten[$_];
                 $DEBUG .= "$noten[$_],";
                 $unterkurse++ if ($noten[$_] < 5); }
    $DEBUG .= "<br>\n";
    $anzahl_block1 += 3;
    $punktzahl_block3 += $noten[3];
  }

  ## Im ersten Block wurden bisher gezhlt:
  #  - HJ 1-3 3. Prfungsfach
  #  - HJ 1-3 4. Prfungsfach
  #  - HJ 1-3 5. Prfungsfach
  #  bis jetzt ist $anzahl_block1 == 9
  #  Ausnahme: 5. Prfungsfach = Besondere Lernleistung
  if ($q->param("Pruef_Fach5") eq "Besondere Lernleistung" && $anzahl_block1 == 6) {
    $wertung_info .= "Das 3. und das 4. Prfungsfach wurden gewertet.<br>\n";
  } elsif ($anzahl_block1 == 9) {
    $wertung_info .= "Das 3., 4. und das 5. Prfungsfach wurden gewertet.<br>\n";
  } else {
    $wertung_info .= "FEHLER bei der Wertung der Prfungsfcher...<br>\n";
  }


  ## Und jetzt: weitere Fcher
  # > sofern nicht unter den Prfungsfchern:
  # HJ 1-4 von Profil- bzw. Neigungsfach
  # a) wenn Profilfach weder 4. noch 5. Prfungsfach
  if ($Pruef_Fach4 ne $profilfach && $Pruef_Fach5 ne $profilfach) {
    # werte Profilfach
    @noten = $q->param("${profilfach}_noten");
    $DEBUG .= $profilfach . ": ";
    for (0..3) { $punktzahl_block1 += $noten[$_];
                 $DEBUG .= "$noten[$_],";
               $unterkurse++ if ($noten[$_] < 5); }
    $DEBUG .= "<br>\n";
    $anzahl_block1 += 4;
    $wertung_info .= "Das Profilfach (alle 4 Halbjahre) wurde gewertet.<br>\n";
  }
  # b) wenn Neigungsfach weder 4. noch 5. Prfungsfach
  if ($Pruef_Fach4 ne $neigungsfach && $Pruef_Fach5 ne $neigungsfach) {
    # werte Neigungsfach
    @noten = $q->param("${neigungsfach}_noten");
    $DEBUG .= $neigungsfach . ": ";
    for (0..3) { $punktzahl_block1 += $noten[$_];
               $DEBUG .= "$noten[$_],";
                 $unterkurse++ if ($noten[$_] < 5); }
    $DEBUG .= "<br>\n";
    $anzahl_block1 += 4;
    $wertung_info .= "Das Neigungsfach (alle 4 Halbjahre) wurde gewertet.<br>\n";
  }


  # > sofern nicht als Prfungsfcher, als Profil- oder Neigungsfach eingebracht:
  # * die Kurse aller vier Halbjahre
  #   in Geschichte, Erdkunde und Gemeinschaftskunde in  der jeweils
  #   vorgeschriebenen Kombination
  #
  if ($neigungsfach eq "Geschichte") {
    # fall 1: geschichte als neigungsfach
    # alle 4 kurse g_gk_ek zhlen (wenn nicht schon als prfungsfach gewertet!!)
    if ($q->param("Pruef_Fach5") ne "Erdkunde" &&
        $q->param("Pruef_Fach5") ne "Gemeinschaftskunde") {
      @noten = $q->param("G_Gk_Ek_noten");
      $DEBUG .= "Gemeinschaftskunde/Erdkunde: ";
      for (0..3) { $punktzahl_block1 += $noten[$_];
                 $DEBUG .= "$noten[$_],";
                   $unterkurse++ if ($noten[$_] < 5); }
      $DEBUG .= "<br>\n";
      $anzahl_block1 += 4;
      $wertung_info .= "Gemeinschaftskunde und Erdkunde (alle Halbjahre) gewertet.<br>\n";
    }
  } elsif ($neigungsfach eq "Gemeinschaftskunde") {
    # fall 2: gemeinschaftskunde als neigungsfach
    # nur den 2. und 3. kurs von g_gk_ek zhlen
    # Prfungsfach??
    if ($q->param("Pruef_Fach5") ne "Geschichte" &&
        $q->param("Pruef_Fach5") ne "Erdkunde") {
      @noten = $q->param("G_Gk_Ek_noten");
      $DEBUG .= "Geschichte/Erdkunde: ";
      for (1..2) { $punktzahl_block1 += $noten[$_];
                 $DEBUG .= "$noten[$_],";
                 $unterkurse++ if ($noten[$_] < 5); }
      $DEBUG .= "<br>\n";
      $anzahl_block1 += 2;
      $wertung_info .= "Geschichte und Erdkunde (2. und 3. Halbjahr) gewertet.<br>\n";
    }
  } elsif ($neigungsfach eq "Erdkunde") {
    # fall 3: erdkunde als neigungsfach
    # nur 1. und 4. kurs von g_gk_ek zhlen
    # Prfungsfach??
    if ($q->param("Pruef_Fach5") ne "Geschichte" &&
        $q->param("Pruef_Fach5") ne "Gemeinschaftskunde") {
      @noten = $q->param("G_Gk_Ek_noten");
      $DEBUG .= "Geschichte/Gemeinschaftskunde: ";
      $punktzahl_block1 += $noten[0];
                 $DEBUG .= "$noten[0],";
      $unterkurse++ if ($noten[0] < 5);
      $punktzahl_block1 += $noten[3];
                 $DEBUG .= "$noten[3],";
      $unterkurse++ if ($noten[3] < 5);
      $DEBUG .= "<br>\n";
      $anzahl_block1 += 2;
      $wertung_info .= "Geschichte und Gemeinschaftskunde (1. und 4. Halbjahr) gewertet.<br>\n";
    }
  } else {
    # fall 4: keines der drei fcher als neigungsfach
    # alle 4 kurse werten
    # Prfungsfach??
    if ($q->param("Pruef_Fach5") ne "Geschichte" &&
        $q->param("Pruef_Fach5") ne "Gemeinschaftskunde" &&
        $q->param("Pruef_Fach5") ne "Erdkunde") {
      @noten = $q->param("G_Gk_Ek_noten");
      $DEBUG .= "Geschichte/Gemeinschaftskunde/Erdkunde: ";
      for (0..3) { $punktzahl_block1 += $noten[$_];
                 $DEBUG .= "$noten[$_],";
                 $unterkurse++ if ($noten[$_] < 5); }
      $DEBUG .= "<br>\n";
      $anzahl_block1 += 4;
      $wertung_info .= "Geschichte, Gemeinschaftskunde und Erdkunde (alle 4 Halbjahre) gewertet.<br>\n";
    }
  }


  # * jeweils zwei Kurse aus zwei der Fcher Physik, Chemie oder Biologie
  if ($wahl_seminarkurs eq "on") {
    # Seminarkurs als Ersatz fr die 2. Naturwissenschaft
    # ... zuerst die erste Naturwissenschaft herausfinden
    if ($profilfach eq "Physik" || $profilfach eq "Chemie" || $profilfach eq "Biologie") {
      # die erste Naturwissenschaft wurde schon gewertet (als Profilfach)
    } else {
      # 2 stndige Naturwissenschaft raussuchen und davon die
      # 2 besten Kurse werten...
      my @noten1;
      my @noten2;
      my @noten3;
      if ($physik2 eq "on" && $Pruef_Fach5 ne "Physik") {
        @noten1 = sort {$b <=> $a} $q->param("Physik_noten");
      }
      if ($chemie2 eq "on" && $Pruef_Fach5 ne "Chemie") {
        @noten2 = sort {$b <=> $a} $q->param("Chemie_noten");
      }
      if ($biologie2 eq "on" && $Pruef_Fach5 ne "Biologie") {
        @noten3 = sort {$b <=> $a} $q->param("Biologie_noten");
      }
      my $punkte1 = $noten1[0] + $noten1[1];
      my $punkte2 = $noten2[0] + $noten2[1];
      my $punkte3 = $noten3[0] + $noten3[1];

      if ($punkte1 > $punkte2 && $punkte1 > $punkte3) {
        $DEBUG .= "Physik: ";
        $punktzahl_block1 += $punkte1;
               $DEBUG .= "$noten1[0],";
        $unterkurse++ if ($noten1[0] < 5);
               $DEBUG .= "$noten1[1],";
        $unterkurse++ if ($noten1[1] < 5);
        $DEBUG .= "<br>\n";
        $anzahl_block1 += 2;
        my $ret1 = &edit_entry(\@tabelle, "Physik", $noten1[0]);
        my $ret2 = &edit_entry(\@tabelle, "Physik", $noten1[1]);
        if ($ret1 != -1 && $ret2 != -1) {
          $wertung_info .= "Die zwei besten Kurse ($ret1. und $ret2. Halbjahr) von Physik wurden gewertet.<br>\n";
        } else {
          $wertung_info .= "Die zwei besten Kurse von Physik wurden gewertet.<br>\n";
        }
      } elsif ($punkte2 > $punkte1 && $punkte2 > $punkte3) {
        $DEBUG .= "Chemie: ";
        $punktzahl_block1 += $punkte2;
        $unterkurse++ if ($noten2[0] < 5);
               $DEBUG .= "$noten2[0],";
        $unterkurse++ if ($noten2[1] < 5);
               $DEBUG .= "$noten2[1],";
        $DEBUG .= "<br>\n";
        $anzahl_block1 += 2;
        my $ret1 = &edit_entry(\@tabelle, "Chemie", $noten2[0]);
        my $ret2 = &edit_entry(\@tabelle, "Chemie", $noten2[1]);
        if ($ret1 != -1 && $ret2 != -1) {
          $wertung_info .= "Die zwei besten Kurse ($ret1. und $ret2. Halbjahr) von Chemie wurden gewertet.<br>\n";
        } else {
          $wertung_info .= "Die zwei besten Kurse von Chemie wurden gewertet.<br>\n";
        }
      } elsif ($punkte3 > $punkte1 && $punkte3 > $punkte2) {
        $DEBUG .= "Biologie: ";
        $punktzahl_block1 += $punkte3;
        $unterkurse++ if ($noten3[0] < 5);
               $DEBUG .= "$noten3[0],";
        $unterkurse++ if ($noten3[1] < 5);
               $DEBUG .= "$noten3[1],";
        $DEBUG .= "<br>\n";
        $anzahl_block1 += 2;
        my $ret1 = &edit_entry(\@tabelle, "Biologie", $noten3[0]);
        my $ret2 = &edit_entry(\@tabelle, "Biologie", $noten3[1]);
        if ($ret1 != -1 && $ret2 != -1) {
          $wertung_info .= "Die zwei besten Kurse ($ret1. und $ret2. Halbjahr) von Biologie wurden gewertet.<br>\n";
        } else {
          $wertung_info .= "Die zwei besten Kurse von Biologie wurden gewertet.<br>\n";
        }
      }
    }

    # Seminarkurs werten
    $DEBUG .= "Seminarkurs: ";
    $DEBUG .= $q->param("seminarkurs_noten") . ", ";
    $DEBUG .= $q->param("seminarkurs_noten");
    $DEBUG .= "<br>\n";
    $punktzahl_block1 += 2 * $q->param("seminarkurs_noten");
    $anzahl_block1 += 2;
    $wertung_info .= "Der Seminarkurs wurde als Ersatz fr die 2. Naturwissenschaft gewertet.<br>\n";
  } elsif (($profilfach eq "Physik" || $profilfach eq "Chemie" || $profilfach eq "Biologie") &&
      ($neigungsfach eq "Physik" || $neigungsfach eq "Chemie" || $neigungsfach eq "Biologie")) {
        # Profilfach = Naturwissenschaft
        # Neigungsfach = Naturwissenschaft
        # keine Wertung mehr ntig...
  } elsif (($profilfach eq "Physik" || $profilfach eq "Chemie" || $profilfach eq "Biologie") &&
      ($neigungsfach ne "Physik" && $neigungsfach ne "Chemie" && $neigungsfach ne "Biologie")) {
    # Profilfach = Naturwissenschaft
    # Neigungsfach = keine Naturwissenschaft
    
    # da eine Naturwissenschaft schon 4-Stndig ist, muss die 2-stndige nicht mehr unbedingt berechnet
    # werden
    # -> keine Wertung ntig
  } elsif (($profilfach ne "Physik" && $profilfach ne "Chemie" && $profilfach ne "Biologie") &&
           ($neigungsfach eq "Physik" || $neigungsfach eq "Chemie" || $neigungsfach eq "Biologie")) {
    # Profilfach = keine Naturwissenschaft
    # Neigungsfach = Naturwissenschaft
    
    # da eine Naturwissenschaft schon 4-Stndig ist, muss die 2-stndige nicht mehr unbedingt berechnet
    # werden
    # -> keine Wertung ntig
  }


  # > sofern nicht als Prfungsfach, als Profil- oder Neigungsfach eingebracht
  ## "Die Kurse aus zwei Halbjahren aus einem der Fcher
  #   Musik oder Bildende Kunst"
  my @noten1;
  my @noten2;
  if ($neigungsfach ne "Musik" && $neigungsfach ne "Bildende Kunst" &&
      $Pruef_Fach4 ne "Musik" && $Pruef_Fach4 ne "Bildende Kunst" &&
      $Pruef_Fach5 ne "Musik" && $Pruef_Fach5 ne "Bildende Kunst") {
    if ($Pruef_Fach4 ne "Musik" && $Pruef_Fach5 ne "Musk" &&
        $neigungsfach ne "Musik" && $musik2 eq "on") {
      @noten1 = sort {$b <=> $a} $q->param("Musik_noten");
    }
    if ($Pruef_Fach4 ne "Bildende Kunst" && $Pruef_Fach5 ne "Bildende Kunst" &&
        $neigungsfach ne "Bildende Kunst" && $kunst2 eq "on") {
      @noten2 = sort {$b <=> $a} $q->param("Bildende Kunst_noten");
    }
    my $punkte1 = $noten1[0] + $noten1[1];
    my $punkte2 = $noten2[0] + $noten2[1];

    if ($punkte1 > $punkte2) {
      $DEBUG .= "Musik: ";
      $punktzahl_block1 += $punkte1;
      $unterkurse++ if ($noten1[0] < 5);
                 $DEBUG .= "$noten1[0],";
      $unterkurse++ if ($noten1[1] < 5);
                 $DEBUG .= "$noten1[1],";
      $DEBUG .= "<br>\n";
      $anzahl_block1 += 2;
      # Kurse raussuchen
      my $ret  = &edit_entry(\@tabelle, "Musik", $noten1[0]);
      my $ret2 = &edit_entry(\@tabelle, "Musik", $noten1[1]);
      if ($ret != -1 && $ret2 != -1) {
        $wertung_info .= "Die zwei besten Kurse ($ret. und $ret2. Halbjahr) von Musik wurden gewertet.<br>\n";
      } else {
        $wertung_info .= "Die zwei besten Kurse von Musik wurden gewertet.<br>\n";
      }
    } else {
      $DEBUG .= "Bildende Kunst: ";
      $punktzahl_block1 += $punkte2;
      $unterkurse++ if ($noten2[0] < 5);
                 $DEBUG .= "$noten2[0],";
      $unterkurse++ if ($noten2[1] < 5);
                 $DEBUG .= "$noten2[1],";
      $DEBUG .= "<br>\n";
      $anzahl_block1 += 2;
      # Kurse raussuchen
      my $ret  = &edit_entry(\@tabelle, "Bildende Kunst", $noten2[0]);
      my $ret2 = &edit_entry(\@tabelle, "Bildende Kunst", $noten2[1]);
      if ($ret != -1 && $ret2 != -1) {
        $wertung_info .= "Die zwei besten Kurse ($ret. und $ret2. Halbjahr) von Bildende Kunst wurden gewertet.<br>\n";
      } else {
        $wertung_info .= "Die zwei besten Kurse von Bildende Kunst wurden gewertet.<br>\n";
      }
    }
  }


  ### jetzt....wenn $anzahl_block1 < 22, dann mssen
  # noch Kurse gewertet werden.
  # a) Mgliche Kurse auflisten
  #    in ein 2-dimensionales array
  #     eine zeile:
  #     NOTE(PUNKTE) Fach    Kurs gewertet
  #      11          Deutsch  3    ja
  # b) nach den besten sortieren
  # c) soviele von den besten werten, sodass 22 Kurse insgesamt gewertet
  #    wurden.

  # b) sortieren
  @tabelle = sort {
    $x = $$a[0];
    $y = $$b[0];
    $y <=> $x;
  } @tabelle;

  my $counter = 0;
  my $sport_kurse = 0; ## hchstens 3 Kurse!!
  while ($anzahl_block1 < 22) {
    $counter++;
    if ($counter > 100) {
      $wertung_info .= "ES IST EIN FEHLER AUFGETRETEN...<br>\n";
      last;
    }

    my $note;
    my $fach;
    my $kurs;
    ($note,$fach,$kurs) = &get_best(\@tabelle);
    # fach darf nicht Prfungsfach sein...
    if ($fach eq $Pruef_Fach4 || $fach eq $Pruef_Fach5) {
      next;
    }

    if ($note != -1) {
      $sport_kurse++ if ($fach eq "Sport" && $sport2 eq "on");
      next if ($sport_kurse > 3);
      $punktzahl_block1 += $note;
      $unterkurse++ if ($note < 5);
               $DEBUG .= "W $fach: $note<br>\n";
      $anzahl_block1 += 1;
      $wertung_info .= "Das $kurs. Halbjahr von $fach wurde gewertet.<br>\n";
    }
  }


  if ($unterkurse > 0) {
    $wertung_info .= "<em>Hinweis:</em> Es wurden $unterkurse Unterkurse gezhlt.<br>\n";
  }


  if ($anzahl_block1 != 22) {
    $wertung_info .= "FEHLER: Es wurden $anzahl_block1 statt 22 Kurse gewertet!<br>\n";
  }


  ## DRITTER BLOCK
  # das 4. HJ der 2 Prfungsfcher die doppelt gewertet wurden
  if ($doppel1_nr eq "1") {
    @noten = $q->param("Deutsch_noten");
  } elsif ($doppel1_nr eq "2") {
    @noten = $q->param($q->param("Pruef_Fach2") . "_noten");
  } elsif ($doppel1_nr eq "3") {
    @noten = $q->param("Mathematik_noten");
  } elsif ($doppel1_nr eq "4") {
    @noten = $q->param($q->param("Pruef_Fach4") . "_noten");
  }
  $punktzahl_block3 += $noten[3];
  if ($doppel2_nr eq "1") {
    @noten = $q->param("Deutsch_noten");
  } elsif ($doppel2_nr eq "2") {
    @noten = $q->param($q->param("Pruef_Fach2") . "_noten");
  } elsif ($doppel2_nr eq "3") {
    @noten = $q->param("Mathematik_noten");
  } elsif ($doppel2_nr eq "4") {
    @noten = $q->param($q->param("Pruef_Fach4") . "_noten");
  }
  $punktzahl_block3 += $noten[3];

  # jetzt noch die Prfungsergebnisse
  if ($doppel1_nr eq "1") {
    if ($q->param("Deutsch_Pruef_M_noten") eq "-" || $q->param("Deutsch_Pruef_M_noten") !~ /\d+/) {
      $punktzahl_block3 += 3 * $q->param("Deutsch_Pruef_S_noten");
    } else {
      $punktzahl_block3 += 2 * $q->param("Deutsch_Pruef_S_noten") + $q->param("Deutsch_Pruef_M_noten");
    }
  } elsif ($doppel1_nr eq "2") {
    if ($q->param("Fach2_Pruef_M_noten") eq "-" || $q->param("Fach2_Pruef_M_noten") !~ /\d+/) {
      $punktzahl_block3 += 3 * $q->param("Fach2_Pruef_S_noten");
    } else {
      $punktzahl_block3 += 2 * $q->param("Fach2_Pruef_S_noten") + $q->param("Fach2_Pruef_M_noten");
    }
  } elsif ($doppel1_nr eq "3") {
    if ($q->param("Mathematik_Pruef_M_noten") eq "-" || $q->param("Mathematik_Pruef_M_noten") !~ /\d+/) {
      $punktzahl_block3 += 3 * $q->param("Mathematik_Pruef_S_noten");
    } else {
      $punktzahl_block3 += 2 * $q->param("Mathematik_Pruef_S_noten") + $q->param("Mathematik_Pruef_M_noten");
    }
  } elsif ($doppel1_nr eq "4") {
    if ($q->param("Fach4_Pruef_M_noten") eq "-" || $q->param("Fach4_Pruef_M_noten") !~ /\d+/) {
      $punktzahl_block3 += 3 * $q->param("Fach4_Pruef_S_noten");
    } else {
      $punktzahl_block3 += 2 * $q->param("Fach4_Pruef_S_noten") + $q->param("Fach4_Pruef_M_noten");
    }
  }

  if ($doppel2_nr eq "1") {
    if ($q->param("Deutsch_Pruef_M_noten") eq "-" || $q->param("Deutsch_Pruef_M_noten") !~ /\d+/) {
      $punktzahl_block3 += 3 * $q->param("Deutsch_Pruef_S_noten");
    } else {
      $punktzahl_block3 += 2 * $q->param("Deutsch_Pruef_S_noten") + $q->param("Deutsch_Pruef_M_noten");
    }
  } elsif ($doppel2_nr eq "2") {
    if ($q->param("Fach2_Pruef_M_noten") eq "-" || $q->param("Fach2_Pruef_M_noten") !~ /\d+/) {
      $punktzahl_block3 += 3 * $q->param("Fach2_Pruef_S_noten");
    } else {
      $punktzahl_block3 += 2 * $q->param("Fach2_Pruef_S_noten") + $q->param("Fach2_Pruef_M_noten");
    }
  } elsif ($doppel2_nr eq "3") {
    if ($q->param("Mathematik_Pruef_M_noten") eq "-" || $q->param("Mathematik_Pruef_M_noten") !~ /\d+/) {
      $punktzahl_block3 += 3 * $q->param("Mathematik_Pruef_S_noten");
    } else {
      $punktzahl_block3 += 2 * $q->param("Mathematik_Pruef_S_noten") + $q->param("Mathematik_Pruef_M_noten");
    }
  } elsif ($doppel2_nr eq "4") {
    if ($q->param("Fach4_Pruef_M_noten") eq "-" || $q->param("Fach4_Pruef_M_noten") !~ /\d+/) {
      $punktzahl_block3 += 3 * $q->param("Fach4_Pruef_S_noten");
    } else {
      $punktzahl_block3 += 2 * $q->param("Fach4_Pruef_S_noten") + $q->param("Fach4_Pruef_M_noten");
    }
  }

  if ($liste2[0] eq "1") {
    if ($q->param("Deutsch_Pruef_M_noten") eq "-" || $q->param("Deutsch_Pruef_M_noten") !~ /\d+/) {
      $punktzahl_block3 += 3 * $q->param("Deutsch_Pruef_S_noten");
    } else {
      $punktzahl_block3 += 2 * $q->param("Deutsch_Pruef_S_noten") + $q->param("Deutsch_Pruef_M_noten");
    }
  } elsif ($liste2[0] eq "2") {
    if ($q->param("Fach2_Pruef_M_noten") eq "-" || $q->param("Fach2_Pruef_M_noten") !~ /\d+/) {
      $punktzahl_block3 += 3 * $q->param("Fach2_Pruef_S_noten");
    } else {
      $punktzahl_block3 += 2 * $q->param("Fach2_Pruef_S_noten") + $q->param("Fach2_Pruef_M_noten");
    }
  } elsif ($liste2[0] eq "3") {
    if ($q->param("Mathematik_Pruef_M_noten") eq "-" || $q->param("Mathematik_Pruef_M_noten") !~ /\d+/) {
      $punktzahl_block3 += 3 * $q->param("Mathematik_Pruef_S_noten");
    } else {
      $punktzahl_block3 += 2 * $q->param("Mathematik_Pruef_S_noten") + $q->param("Mathematik_Pruef_M_noten");
    }
  } elsif ($liste2[0] eq "4") {
    if ($q->param("Fach4_Pruef_M_noten") eq "-" || $q->param("Fach4_Pruef_M_noten") !~ /\d+/) {
      $punktzahl_block3 += 3 * $q->param("Fach4_Pruef_S_noten");
    } else {
      $punktzahl_block3 += 2 * $q->param("Fach4_Pruef_S_noten") + $q->param("Fach4_Pruef_M_noten");
    }
  }

  if ($liste2[1] eq "1") {
    if ($q->param("Deutsch_Pruef_M_noten") eq "-" || $q->param("Deutsch_Pruef_M_noten") !~ /\d+/) {
      $punktzahl_block3 += 3 * $q->param("Deutsch_Pruef_S_noten");
    } else {
      $punktzahl_block3 += 2 * $q->param("Deutsch_Pruef_S_noten") + $q->param("Deutsch_Pruef_M_noten");
    }
  } elsif ($liste2[1] eq "2") {
    if ($q->param("Fach2_Pruef_M_noten") eq "-" || $q->param("Fach2_Pruef_M_noten") !~ /\d+/) {
      $punktzahl_block3 += 3 * $q->param("Fach2_Pruef_S_noten");
    } else {
      $punktzahl_block3 += 2 * $q->param("Fach2_Pruef_S_noten") + $q->param("Fach2_Pruef_M_noten");
    }
  } elsif ($liste2[1] eq "3") {
    if ($q->param("Mathematik_Pruef_M_noten") eq "-" || $q->param("Mathematik_Pruef_M_noten") !~ /\d+/) {
      $punktzahl_block3 += 3 * $q->param("Mathematik_Pruef_S_noten");
    } else {
      $punktzahl_block3 += 2 * $q->param("Mathematik_Pruef_S_noten") + $q->param("Mathematik_Pruef_M_noten");
    }
  } elsif ($liste2[1] eq "4") {
    if ($q->param("Fach4_Pruef_M_noten") eq "-" || $q->param("Fach4_Pruef_M_noten") !~ /\d+/) {
      $punktzahl_block3 += 3 * $q->param("Fach4_Pruef_S_noten");
    } else {
      $punktzahl_block3 += 2 * $q->param("Fach4_Pruef_S_noten") + $q->param("Fach4_Pruef_M_noten");
    }
  }

  # 5. Prfungsfach:
  if ($q->param("Pruef_Fach5") eq "Besondere Lernleistung") {
    $punktzahl_block3 += 4 * $q->param("lernleistung_noten");
  } else {
    #######
    # 21.09.2004: das 4.hj. des 5. prfungsfachs wurde schon gewertet!!!
    # das 4. Halbjahr des 5. Prfungsfaches:
    #$fach = $q->param("Pruef_Fach5");
    #@noten = $q->param("${fach}_noten");
    #####
    ####$punktzahl_block3 += $noten[3];
    ##########
    # Abiturprfung:
    $punktzahl_block3 += 3 * $q->param("Fach5_Pruef_M_noten");
  }

  # Gesamtpunktzahl:
  my $punktzahl_gesamt = $punktzahl_block1 + $punktzahl_block2 + $punktzahl_block3;


#  ## Informationen ber die gewhlten Kurse nochmal:
#  print qq(Kernkompetenzsprache: $Pruef_Fach2<br>\n);
#  if ($Pruef_Fach2 eq $profilfach) {
#    print qq(Profilfach: $kern_sprache<br>\n);
#  } else {
#    print qq(Profilfach: $profilfach<br>\n);
#  }
#  print qq(Neigungsfach: $neigungsfach<br>\n);
#  print qq(<p>\n);



  print qq(<font color="red"><h1>ALLE ANGABEN SIND OHNE GEWHR!</h1></font>\n);

  print qq(<h2>Erster Block</h2>\n);
  print qq($wertung_info\n);
  print qq(Punktzahl: <big>$punktzahl_block1</big><br>\n);

  print qq(<h2>Zweiter Block</h2>\n);
  print qq(Zweifach gewertet werden: );
  print qq(<b>$doppel1</b> und <b>$doppel2</b><br>\n);
  if ($facharbeit_gewertet eq "true") {
    print qq(Die Facharbeit wurde gewertet. Passt das Thema auch?<br>\n);
  }
  print qq(Punktzahl: <big>$punktzahl_block2</big><br>\n);

  print qq(<h2>Dritter Block</h2>\n);
  if (not defined($q->param("button_ohne_abi"))) {
    print qq(Prfungsfcher:\n);
    print qq(Deutsch, $Pruef_Fach2, Mathematik, $Pruef_Fach4 und $Pruef_Fach5<br>\n);
    print qq(Punktzahl: <big>$punktzahl_block3</big><br>\n);
    print qq(<h2>Gesamtpunktzahl: );
    print qq($punktzahl_gesamt</h2>\n);
    my $gesamtdurchschnitt = &get_durchschnitt($punktzahl_gesamt);
    print qq(<h2>Gesamtdurchschnitt: $gesamtdurchschnitt</h2>\n);
  } else {
    print qq(Der dritte Block wurde nicht berechnet.<br>\n);
    $punktzahl_gesamt = $punktzahl_block1 + $punktzahl_block2;
    print qq(<h2>Punktzahl (Block1 und Block2): );
    print qq($punktzahl_gesamt</h2>\n);
  }


  if ($q->param("debug") eq "on") {
      print qq(<h2>Debug-Ausgaben</h2>\n);
      print qq(<p>$DEBUG</p>\n);
      print qq(<small>D = Daten fr Doppelt gewertete Kurse (2.Block)<br>\n);
      print qq(P = gewertetes Prfungsfach<br>\n);
      print qq(W = Wahlbereich bei Wertung (nicht vorgeschriebene Kurse)\n);
      print qq(</small>\n);
  }

  print qq(<font color="red"><h1>ALLE ANGABEN SIND OHNE GEWHR!</h1></font>\n);
  #print $q->Dump;

  print $bottom_line;
}

sub get_durchschnitt {
  my $punkte = shift;

  return "4,0" if ($punkte == 280);
  return "3,9" if ($punkte <= 296 && $punkte >= 281);
  return "3,8" if ($punkte <= 313 && $punkte >= 297);
  return "3,7" if ($punkte <= 330 && $punkte >= 314);
  return "3,6" if ($punkte <= 347 && $punkte >= 331);
  return "3,5" if ($punkte <= 364 && $punkte >= 348);
  return "3,4" if ($punkte <= 380 && $punkte >= 365);
  return "3,3" if ($punkte <= 397 && $punkte >= 381);
  return "3,2" if ($punkte <= 414 && $punkte >= 398);
  return "3,1" if ($punkte <= 431 && $punkte >= 415);
  return "3,0" if ($punkte <= 448 && $punkte >= 432);
  return "2,9" if ($punkte <= 464 && $punkte >= 449);
  return "2,8" if ($punkte <= 481 && $punkte >= 465);
  return "2,7" if ($punkte <= 498 && $punkte >= 482);
  return "2,6" if ($punkte <= 515 && $punkte >= 499);
  return "2,5" if ($punkte <= 532 && $punkte >= 516);
  return "2,4" if ($punkte <= 548 && $punkte >= 533);
  return "2,3" if ($punkte <= 565 && $punkte >= 549);
  return "2,2" if ($punkte <= 582 && $punkte >= 566);
  return "2,1" if ($punkte <= 599 && $punkte >= 583);
  return "2,0" if ($punkte <= 616 && $punkte >= 600);
  return "1,9" if ($punkte <= 632 && $punkte >= 617);
  return "1,8" if ($punkte <= 649 && $punkte >= 633);
  return "1,7" if ($punkte <= 666 && $punkte >= 650);
  return "1,6" if ($punkte <= 683 && $punkte >= 667);
  return "1,5" if ($punkte <= 700 && $punkte >= 684);
  return "1,4" if ($punkte <= 716 && $punkte >= 701);
  return "1,3" if ($punkte <= 733 && $punkte >= 717);
  return "1,2" if ($punkte <= 750 && $punkte >= 734);
  return "1,1" if ($punkte <= 767 && $punkte >= 751);
  return "1,0" if ($punkte <= 840 && $punkte >= 768);

  return "Fehler!";
}

sub add_entry {
  #    ...in ein 2-dimensionales array
  #     eine zeile:
  #     NOTE(PUNKTE) Fach    Kurs gewertet
  #      11          Deutsch  3    ja

  my $tabelle = shift;
  my $fach = shift;

  my @noten = $q->param("${fach}_noten");
  for (0..3) {
    my @array = qw();
    push(@array, $noten[$_]);
    push(@array, $fach);
    my $kurs = $_ + 1;
    push(@array, $kurs);
    push(@array, "nein");
    push(@$tabelle, \@array);
  }
}

sub edit_entry {
  my $tabelle = shift;
  my $fach = shift;
  my $note = shift;

  foreach $entry (@$tabelle) {
    if ($$entry[0] == $note &&
        $$entry[1] eq $fach &&
        $$entry[3] ne "ja") {
      $$entry[3] = "ja";
      return $$entry[2];
    }
  }

  return -1;
}

sub get_best {
  my $tabelle = shift;

  # sucht nur das erstbeste,
  # die tabelle sollte also sortiert sein
  foreach $entry (@$tabelle) {
    my $note = $$entry[0];
    my $fach = $$entry[1];
    my $kurs = $$entry[2];
    my $wertung = $$entry[3];
    if ($wertung ne "ja") {
      &edit_entry($tabelle, $fach, $note);
      return ($note,$fach,$kurs);
    }
  }

  return (-1,"","");
}

sub D {
    my $data = shift;
    open (FILE, ">>debug.txt");
    print FILE scalar(localtime()), " $data\n";
    close(FILE);
}

