unit uMySQLProperties;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, IniFiles, mysql;

type
  TMySQLProperties = class(TForm)
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    editServer: TEdit;
    editLogin: TEdit;
    editPassword: TEdit;
    editDatabase: TEdit;
    editTable: TEdit;
    btnOK: TButton;
    btnCancel: TButton;
    checkMySQL: TCheckBox;
    checkNormalLogging: TCheckBox;
    Memo1: TMemo;
    procedure btnCancelClick(Sender: TObject);
    procedure btnOKClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure checkMySQLClick(Sender: TObject);
  private
    { Private-Deklarationen }
    MySQL : PMYSQL;
    procedure LoadProperties;
    procedure SaveProperties;
    function ini_file: String;
    procedure connect_to_mysql;
  public
    { Public-Deklarationen }
    procedure log_MySQL(Start : TDateTime; Stop : TDateTime; Kommentar : String);
    procedure close_mysql;
  end;

var
  MySQLProperties: TMySQLProperties;

implementation

{$R *.dfm}

procedure TMySQLProperties.btnCancelClick(Sender: TObject);
begin
  LoadProperties;
  Hide;
end;

function TMySQLProperties.ini_file: String;
var s:String;
begin
  s := Application.ExeName;
  s := Copy(s, 0, Length(s)-3);
  s := s + 'ini';

  Result := s;
end;

//Einstellungen aus der Datei laden
procedure TMySQLProperties.LoadProperties;
var inifile: TIniFile;
begin
  inifile := TIniFile.Create(ini_file);
  editServer.Text := inifile.ReadString('osw', 'mysql_server', '');
  editLogin.Text  := inifile.ReadString('osw', 'mysql_login', '');
  editPassword.Text := inifile.ReadString('osw', 'mysql_password', '');
  editDatabase.Text := inifile.ReadString('osw', 'mysql_db', '');
  editTable.Text := inifile.ReadString('osw', 'mysql_table', '');
  checkMySQL.Checked := inifile.ReadBool('osw', 'mysql_use', False);
  checkNormalLogging.Checked := inifile.ReadBool('osw', 'mysql_textlog', True);
  inifile.Free;
end;

//Einstellungen in Datei speichern
procedure TMySQLProperties.SaveProperties;
var inifile: TIniFile;
begin
  inifile := TIniFile.Create(ini_file);
  inifile.WriteString('osw', 'mysql_server', editServer.Text);
  inifile.WriteString('osw', 'mysql_login', editLogin.Text);
  inifile.WriteString('osw', 'mysql_password', editPassword.Text);
  inifile.WriteString('osw', 'mysql_db', editDatabase.Text);
  inifile.WriteString('osw', 'mysql_table', editTable.Text);
  inifile.WriteBool('osw', 'mysql_use', checkMySQL.Checked);
  inifile.WriteBool('osw', 'mysql_textlog', checkNormalLogging.Checked);
  inifile.Free;
end;


procedure TMySQLProperties.btnOKClick(Sender: TObject);
begin
  if (checkMySQL.Checked = True) then begin
    if ((Length(editServer.Text) = 0) or (Length(editDatabase.Text) = 0)) then begin
      ShowMessage('Es muss mindestens ein MySQL-Server und eine Datenbank angegeben werden!');
      Exit;
    end;
  end;

  SaveProperties;
  Hide;
  //Verbindung zum MySQL-Server aufbauen
  if (checkMySQL.Checked = True) then connect_to_mysql;
end;

procedure TMySQLProperties.FormCreate(Sender: TObject);
begin
  LoadProperties;
  checkMySQLClick(Sender);
  //Jetzt gegebenenfalls Verbindung zum MySQL-Server aufbauen
  if (checkMySQL.Checked) then connect_to_mysql;
end;

procedure TMySQLProperties.checkMySQLClick(Sender: TObject);
begin
  checkNormalLogging.Enabled := checkMySQL.Checked;
  editServer.Enabled := checkMySQL.Checked;
  editLogin.Enabled := checkMySQL.Checked;
  editPassword.Enabled := checkMySQL.Checked;
  editDatabase.Enabled := checkMySQL.Checked;
  editTable.Enabled := checkMySQL.Checked;
end;

procedure TMySQLProperties.connect_to_mysql;
begin
  //eventuell alte Verbindung schlieen
  close_mysql;
  
  MySQL := mysql_init(nil);
  if (mysql_connect(MySQL, pChar(editServer.Text), pChar(editLogin.Text), pChar(editPassword.Text)) = nil) then
  begin
    //Verbindungsaufbau gescheitert
    ShowMessage('Konnte keine Verbindung zum MySQL-Server aufbauen. Deaktiviere MySQL.');
    checkMySQL.Checked := False;
    checkMySQLClick(nil);
    SaveProperties;
    MySQL := nil;
    Exit;
  end;

  if (mysql_select_db(MySQL, pChar(editDatabase.Text)) <> 0) then
  begin
    //kein Zugriff auf die Datenbank
    ShowMessage('Konnte die Datenbank "' + editDatabase.Text + '" nicht auswhlen. Deaktiviere MySQL.');
    checkMySQL.Checked := False;
    checkMySQLClick(nil);
    SaveProperties;
    mysql_close(MySQL);
    MySQL := nil;
    Exit;
  end;
end;

procedure TMySQLProperties.log_MySQL(Start, Stop : TDateTime; Kommentar : String);
var start_str, stopp_str: String;
begin
  DateTimeToString(start_str, 'yyyy-mm-dd hh:mm:ss', Start);
  DateTimeToString(stopp_str, 'yyyy-mm-dd hh:mm:ss', Stop);

  if (mysql_query(MySQL, pChar('INSERT INTO `' + editTable.Text + '` SET start='''
      + start_str + ''', end=''' + stopp_str + ''', comment='''
      + Kommentar + '''')) <> 0) then
  begin
    //Fehler
    ShowMessage('Beim Zugriff auf die Datenbank ist ein Fehler aufgetreten:' + #13#10
      + mysql_error(MySQL) + #13#10 + 'Deaktiviere MySQL');
    checkMySQL.Checked := False;
    checkMySQLClick(nil);
    SaveProperties;
    mysql_close(MySQL);
    MySQL := nil;
    Exit;
  end;
end;

procedure TMySQLProperties.close_mysql;
begin
  if (MySQL <> nil) then mysql_close(MySQL);
end;

end.
