import java.io.*;
import java.awt.event.*;
import javax.swing.*;

public class Dialog1 extends JDialog implements ActionListener, Runnable
{
    Thread runner = null;
    
    File image, target;
    int max_image_size;
    
    JButton cancel_btn;
    JProgressBar progress;    
    JLabel progress_label, progress_label2;
    
    int max_sectors;
    int current_sector;
    int found_images;
    
    Dialog1(JFrame owner, String i, String t, int max)
    {
        super(owner, PhotoUnformat.TITLE + " - Wiederherstellen", true);
        setDefaultCloseOperation(WindowConstants.DO_NOTHING_ON_CLOSE);
        
        image = new File(i);
        target = new File(t);
        max_image_size = max;
        
        
        /* zuerst berprfen, ob die Dateien bzw. das Verzeichnis lesbar/schreibbar ist */
        if (! image.canRead()) {
            JOptionPane.showMessageDialog(this, "Die Datei " + image + " ist nicht lesbar oder es wurde keine Datei angegeben!", "Fehler", JOptionPane.ERROR_MESSAGE);
            return;
        }
        if (! target.canWrite()) {
            JOptionPane.showMessageDialog(this, "Das Verzeichnis " + target + " ist nicht schreibbar oder es wurde kein Verzeichnis angegeben!", "Fehler", JOptionPane.ERROR_MESSAGE);
            return;
        }
        
        max_sectors = (int) image.length() / 512;
        current_sector = -1;
        found_images = 0;
        progress_label = new JLabel("Fortschritt: " + current_sector + "/" + max_sectors);
        progress_label2 = new JLabel("Gefundene Bilder: " + found_images);
        
        progress = new JProgressBar();
        progress.setMaximum(max_sectors);
        
        cancel_btn = new JButton("abbrechen");
        cancel_btn.addActionListener(this);
        
        JPanel contentpane = new JPanel();
        contentpane.setLayout(new BoxLayout(contentpane, BoxLayout.Y_AXIS));
        
        contentpane.add(new JLabel("Datentrger-Image: " + image));
        contentpane.add(new JLabel("Dateigre: " + ((int) image.length() / 1024 / 1024) + " MiB"));
        contentpane.add(new JLabel("Ziel-Verzeichnis: " + target));
        contentpane.add(new JLabel("Maximale Bildgre: " + max_image_size + " KiB"));
        contentpane.add(new JLabel(" "));
        contentpane.add(progress);
        contentpane.add(progress_label);
        contentpane.add(progress_label2);
        contentpane.add(new JLabel(" "));
        contentpane.add(cancel_btn);
        
        setContentPane(contentpane);
        pack();

        runner = new Thread(this);
        runner.start();

        show();
        
    }
    
    public void run() {
        begin_rescue();
    }
    
    void update_progress() {
        progress.setValue(current_sector);
        progress_label.setText("Fortschritt: " + current_sector + "/" + max_sectors + " (" + ((current_sector * 1000 / max_sectors)/10.) + "%)");
        progress_label2.setText("Gefundene Bilder: " + found_images);
    }
    
    void begin_rescue()
    {
        // die eigentliche Wiederherstellung findet hier statt...
        byte[] buffer = new byte[512];
        
        FileInputStream input = null;
        FileOutputStream output = null;
        
        try {
            input = new FileInputStream(image);
            output = null;
            
            boolean jpeg = false;
            int image_nr = 0;
            int max_image_sectors = max_image_size * 1024 / 512;
            int sectors = max_image_sectors;
            
            while(input.read(buffer) != -1) {
                current_sector++;
                update_progress();
                
                if (runner == null) {
                    input.close();
                    if (output != null) output.close();
                    break;
                }
                
                
                if (jpeg) {
                    if (sectors > 0) {
                        sectors--;
                        output.write(buffer);
                    } else {
                        jpeg = false;
                        output.close();
                    }
                }
                
                //if (buffer[0] != 0xff || buffer[1] != 0xd8) continue;
                if (buffer[0] != -1 || buffer[1] != -40) continue;
                
                if ((buffer[6] == 'E' && buffer[7] == 'x' && buffer[8] == 'i' && buffer[9] == 'f') ||
                    (buffer[6] == 'J' && buffer[7] == 'F' && buffer[8] == 'I' && buffer[9] == 'F')) {                  
                    
                    if (jpeg) output.close();
                    
                    jpeg = true;
                    found_images++;
                    image_nr++;
                    sectors = max_image_sectors;
                    String imageStr;
                    if (image_nr < 100 && image_nr >= 10) {
                        imageStr = "0" + image_nr;
                    } else if (image_nr < 10) {
                        imageStr = "00" + image_nr;
                    } else {
                        imageStr = "" + image_nr;
                    }
                    
                    output = new FileOutputStream("" + target + File.separator + "img" + imageStr + ".jpg");
                    sectors--;
                    output.write(buffer);
                }
            }
            
            input.close();
            if (output != null) output.close();
            
        } catch (IOException ex) {           
            System.err.println(ex);
            System.exit(1);
        }
        
        //..fertig:
        cancel_btn.setText("FERTIG!");          
    }
    
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("abbrechen")) {
            runner = null;
        } else {
            // "FERTIG"
            runner = null;
            this.dispose();
        }
    }
}

        
        
