import java.awt.event.*;
import java.io.File;
import javax.swing.*;

public class Frame1 extends JFrame implements ActionListener
{
    JButton image_button, target_button, rescue_button;
    JTextField image_txt, target_txt, max_txt;

    JFileChooser filechooser = new JFileChooser();
    
    
    Frame1() {
        super(PhotoUnformat.TITLE);
        
        
        JPanel contentpane = new JPanel();
        JPanel image_panel = new JPanel();
        JPanel target_panel = new JPanel();
        
        image_txt = new JTextField();
        target_txt = new JTextField();
        max_txt = new JTextField("1500");
        image_button = new JButton("...");
        image_button.addActionListener(this);
        target_button = new JButton("...");
        target_button.addActionListener(this);
        rescue_button = new JButton("Wiederherstellen!");
        rescue_button.addActionListener(this);
        
        
        contentpane.setLayout(new BoxLayout(contentpane, BoxLayout.Y_AXIS));
        image_panel.setLayout(new BoxLayout(image_panel, BoxLayout.X_AXIS));
        target_panel.setLayout(new BoxLayout(target_panel, BoxLayout.X_AXIS));
        
        
        contentpane.add(new JLabel("Datentrger-Image:"));
        image_panel.add(image_txt);
        image_panel.add(image_button);
        contentpane.add(image_panel);
        contentpane.add(new JLabel("Ausgabe-Verzeichnis:"));
        target_panel.add(target_txt);
        target_panel.add(target_button);
        contentpane.add(target_panel);
        contentpane.add(new JLabel("Maximale Bildgre: (in KiB)"));
        contentpane.add(max_txt);
        contentpane.add(rescue_button);
        
        addWindowListener(new WindowAdapter()
        {
            public void windowClosing(WindowEvent e)
            {
                System.exit(0);
            }
        });
        
        
        setContentPane(contentpane);
        pack();
        show();
    }
    
    public void actionPerformed(ActionEvent e)
    {
        JButton src = (JButton) e.getSource();
        if (src == image_button)
        {
            filechooser.setFileSelectionMode(JFileChooser.FILES_ONLY);
            if (filechooser.showOpenDialog(this) == JFileChooser.APPROVE_OPTION) {
                File f = filechooser.getSelectedFile();
                image_txt.setText(f.getAbsolutePath());
            }           
        } else if (src == target_button) {
            filechooser.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
            if (filechooser.showSaveDialog(this) == JFileChooser.APPROVE_OPTION) {
                File f = filechooser.getSelectedFile();
                target_txt.setText(f.getAbsolutePath());
            }
        } else if (src == rescue_button) {
            int max = 1500;
            try {
                max = Integer.parseInt(max_txt.getText());
            } catch (NumberFormatException ex) {}                        
            
            new Dialog1(this, image_txt.getText(), target_txt.getText(), max);
        }
    }
}

