unit main;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Ras;

const MAX_RASCONNECTIONS = 10;

type
  TMainForm = class(TForm)
    Label1: TLabel;
    Label2: TLabel;
    chkPWsave: TCheckBox;
    editUsername: TEdit;
    editPassword: TEdit;
    Label3: TLabel;
    comboConnections: TComboBox;
    btnSave: TButton;
    btnCancel: TButton;
    btnQuit: TButton;
    Label4: TLabel;
    Label5: TLabel;
    procedure FormCreate(Sender: TObject);
    procedure comboConnectionsChange(Sender: TObject);
    procedure btnSaveClick(Sender: TObject);
    procedure btnCancelClick(Sender: TObject);
    procedure btnQuitClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  MainForm: TMainForm;

implementation

{$R *.dfm}

procedure TMainForm.FormCreate(Sender: TObject);
var i, lpcb, lpcEntries, ret: Integer;
    entrynamesArray : Array[1..MAX_RASCONNECTIONS] of TRasEntryName;
begin
  (* RAS Verbindungen holen: *)
  (* Speicher vorbereiten *)
  for i := 1 to MAX_RASCONNECTIONS do begin
    FillChar(entrynamesArray[i], SizeOf(TRasEntryName), 0);
    entrynamesArray[i].dwSize := SizeOf(TRasEntryName);
  end;

  lpcb := SizeOf(TRasEntryName) * MAX_RASCONNECTIONS;
  lpcEntries := 0;

  (* Abfrage starten *)
  ret := RasEnumEntries(nil, nil, @entrynamesArray, lpcb, lpcEntries);

  (* Fehler aufgetreten? *)
  if (ret <> SUCCESS) then begin
    ShowMessage('RasEnumEntries, Fehlercode: ' + IntToStr(ret));
    Exit;
  end;

  (* Verbindungen der Auswahlliste hinzufgen *)
  for i := 1 to lpcEntries do begin
    comboConnections.Items.Add(entrynamesArray[i].szEntryName);
  end;
  comboConnections.ItemIndex := 0;
  comboConnectionsChange(nil);
end;


procedure TMainForm.comboConnectionsChange(Sender: TObject);
var ret : Integer;
    lpfPassword : LongBool;
    DialParams : TRasDialParams;
begin
  (* Speicher vorbereiten *)
  FillChar(DialParams, SizeOf(TRasDialParams), 0);
  DialParams.dwSize := SizeOf(TRasDialParams);
  StrPCopy(DialParams.szEntryName, comboConnections.Items[comboConnections.ItemIndex]);

  (* Daten holen *)
  ret := RasGetEntryDialParams(nil, DialParams, lpfPassword);

  (* Fehler? *)
  if (ret <> SUCCESS) then begin
    ShowMessage('RasGetEntryDialParams, Fehlercode: ' + IntToStr(ret));
    Exit;
  end;

  editUsername.Text := DialParams.szUserName;
  if lpfPassword = True then begin
    editPassword.Text := DialParams.szPassword;
  end else begin
    editPassword.Text := 'kein Passwort gespeichert...';
  end;
  chkPWsave.Checked := lpfPassword;


end;

procedure TMainForm.btnSaveClick(Sender: TObject);
var ret: Integer;
    DialParams: TRasDialParams;
    lpfPassword: LongBool;
begin
  (* Speicher vorbereiten *)
  FillChar(DialParams, SizeOf(TRasDialParams), 0);
  DialParams.dwSize := SizeOf(TRasDialParams);
  StrPCopy(DialParams.szEntryName, comboConnections.Items[comboConnections.ItemIndex]);

  (* alte Daten holen *)
  ret := RasGetEntryDialParams(nil, DialParams, lpfPassword);
  (* Fehler? *)
  if (ret <> SUCCESS) then begin
    ShowMessage('RasGetEntryDialParams, Fehlercode: ' + IntToStr(ret));
    Exit;
  end;

  (* Daten verndern *)
  StrPCopy(DialParams.szUserName, editUsername.Text);
  if chkPWsave.Checked = True then begin
    StrPCopy(DialParams.szPassword, editPassword.Text);
  end;
  lpfPassword := chkPWsave.Checked;

  (* neue Daten speichern *)
  ret := RasSetEntryDialParams(nil, DialParams, not lpfPassword);
  (* Fehler? *)
  if (ret <> SUCCESS) then begin
    ShowMessage('RasSetEntryDialParams, Fehlercode: ' + IntToStr(ret));
    Exit;
  end;
end;

procedure TMainForm.btnCancelClick(Sender: TObject);
begin
  (* einfach alte Daten nochmal auslesen (lassen) *)
  comboConnectionsChange(nil);
end;

procedure TMainForm.btnQuitClick(Sender: TObject);
begin
  Close;
end;

end.
