#!/usr/bin/perl -w
use strict;
use CGI;
use GD;
use CGI::Carp qw(fatalsToBrowser);

my $query = new CGI;

# Konstanten
my $L = 5 * 10**(-3);  # 5 mH
my $C = 2 * 10**(-6);  # 2 F

my $f = 1000 / (2 * 3.1415926535); # Hz
my $omega = 2 * 3.1415926535 * $f;
my $delta_t = 1 * 10**(-5);
#my $t_ende = 10 * $delta_t;
my $wiederholungen = 150;
my $t_ende = $wiederholungen * $delta_t;

my $U_1_dach = 1;
my $R = 5;


# Startwerte
my $t = 0;
my $I = 0;
my $Q = 0 * 10 * $C;


my $output = "text";

if ($query->param()) {
  $L = $query->param("L");
  $C = $query->param("C");
  $f = $query->param("f");
  $omega = 2 * 3.1415926535 * $f;
  $delta_t = $query->param("delta_t");
  $wiederholungen = $query->param("wiederholungen");
  $t_ende = $wiederholungen * $delta_t;
  $U_1_dach = $query->param("U_1_dach");
  $R = $query->param("R");
  $t = $query->param("t");
  $I = $query->param("I");
  $Q = $query->param("Q");
  $output = $query->param("output");
} else {
  print "Content-type: text/html\n\n";
  print <<HTML;
<html>
<head><title>Schwingungen</title></head>
  <body>
    <h1>Schwingungen</h1>
  <form method="post">
  Spule: L = <input type="text" value="0.005" name="L"> H<br>
  Kondensator: C = <input type="text" value="0.000002" name="C"> F<br>
  <p>
  Generator-Frequenz: f = <input type="text" value="1591" name="f"> Hz<br>
  Generator Maximalspannung: U_1_dach = <input type="text" value="1" name="U_1_dach"> V<br>
  <p>
  Zeitabschnitt: delta_t = <input type="text" value="0.00005" name="delta_t"> s<br>
  End-Bedingung: <input type="text" value="150" name="wiederholungen"> Wiederholungen<br>
  <p>
  Widerstand: R = <input type="text" value="5" name="R"> Ohm<br>
  <p>
  Startwert fr t: t = <input type="text" value="0" name="t"> s<br>
  Stromstrke: I = <input type="text" value="0" name="I"> A<br>
  Ladung: Q = <input type="text" value="0" name="Q"> C<br>
  <p>
  Ausgabe: <input type="radio" name="output" value="text" checked>Text
           <input type="radio" name="output" value="png">png-Grafik
  <p>
  <input type="submit"> <input type="reset">
  </form>
  </body>
  </html>
HTML

  exit;
}


my $image;
my $black;
my $white;
my $red;
my $width = $wiederholungen;
my $height = 200;
if ($Q > 0) {
  my $u_c = $Q / $C;
  $height = 20 * $u_c;
} else {
  $height = 200 * $U_1_dach;
}
if ($height > 1000) {
  $height = 1000;
}
if ($width > 1000) {
  $width = 1000;
}

my $pos = 0;

if ($output eq "text") {
  print "Content-type: text/plain\n";
  print "\n";
  print "Werte:\n";
  print "L = $L\n";
  print "C = $C\n";
  print "f = $f\n";
  print "U_1_dach = $U_1_dach\n";
  print "delta_t = $delta_t\n";
  print "t_ende = $t_ende\n";
  print "Wiederholungen = $wiederholungen\n";
  print "R = $R\n";
  print "t = $t\n";
  print "I = $I\n";
  print "Q = $Q\n";
  print "\n";
} elsif ($output eq "png") {
  print "Content-type: image/png\n\n";
  $image = new GD::Image($width, $height);
  $white = $image->colorAllocate(255,255,255);
  $black = $image->colorAllocate(0,0,0);
  $red = $image->colorAllocate(255,0,0);
  $image->rectangle(0,0,$width-1, $height-1, $black);
  $image->line(0,$height/2,$width-1, $height/2, $black); 
}
# startzeit sichern
my $t_start = $t;

my $U_1_alt = 0;
my $U_C_alt = 0;

while (($t - $t_start) <= $t_ende) {
  my $U_1 = $U_1_dach * sin($omega * $t);  # Generator
  my $U_C = $Q / $C;                       # Kondensator
  my $delta_I = ($U_1/$L-$Q/($L*$C)-$R*$I/$L) * $delta_t;   # nderung delta_I
  $I = $I + $delta_I;                  # neue Stromstrke
  $Q = $Q + $I * $delta_t;              # neue Ladung
  $t = $t + $delta_t;                  # neue Zeit

  # Ausgabe:
  #print "$t s -- U_C = $U_C\n";
  #printf "%8.6f, %5.2f\n", $t, $U_C;
  #printf "%8.6fs, %5.2fV, %5.2fV, %5.2fA, %5.2fA, %5.2fQ\n", $t, $U_1, $U_C, $delta_I, $I, $Q;

  #for (1..79) { print " " };
  #print "\r";

  if ($output eq "text") {
    for (1..(40+$U_C)) { print " " };
    print "#\n";
  } elsif ($output eq "png") {
    #$image->setPixel($pos, $height/2 + $U_C * 10, $black);
    #$image->setPixel($pos, $height/2 + $U_1 * 10, $red);
    $image->line($pos-1, $height/2 - $U_C_alt * 10, $pos, $height/2 - $U_C * 10, $black);
    $image->line($pos-1, $height/2 - $U_1_alt * 10, $pos, $height/2 - $U_1_alt * 10, $red);
    #if ($pos % 100 == 0) {
    #  $image->line($pos,0,$pos,$height,$black);
    #}
    $pos++;
    $U_1_alt = $U_1;
    $U_C_alt = $U_C;
  }

  #system("sleep 0.05");
}

if ($output eq "png") {
  binmode(STDOUT);
  print $image->png;
}

