#!/usr/bin/perl -w
# adduser.cgi: a utility to add users to the system
#
# Copyright (C) 1994 Ian A. Murdock <imurdock@shell.portal.com>
# Heavily modified by Thomas Bleher <thomas@gm.rt.schule-bw.de>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

use CGI;
use CGI::Carp qw(fatalsToBrowser);

my $q = new CGI;
print $q->header,$q->start_html(-title=>'Benutzereinrichtung');

if (not $q->param) { 
# noch keine Daten eingegeben
    print $q->h1('Benutzereinrichtung');
    print $q->p,'Hier k&ouml;nnen Sie neue Benutzer einrichten. ';
    &erzeuge_eingabefeld();
    print <<'HERE';
<hr /><h2>Anmerkungen</h2>

<p><em>Vollst&auml;ndiger Name</em>: Hier sollte der wirkliche Name angegeben 
werden, erlaubt sind alle Zeichen.</p>

<p><em>login-Name</em>: Unter diesem Namen muss sich der Benutzer am System 
anmelden. Erlaubt sind die Buchstaben a-z, A-Z, die Zahlen 0-9 sowie die
Zeichen ".", "-" und "_". Erstes Zeichen muss ein Buchstabe sein.</p>

<p><em>Passwort</em>: Das Passwort ist auf 8 Zeichen beschr&auml;nkt. Aus 
Gr&uuml;nden der Systemsicherheit muss es mindestens 5 Zeichen lang sein. Voreingestellt ist 
"<i>passwort</i>". Erlaubt sind alle Zeichen.</p>

HERE

    print $q->end_html;

} else { # es wurden schon Daten eingegeben

    $login=$q->param('login');
    $name=$q->param('fullname');
    $passwd=$q->param('passwort');
    @rechte=$q->param('rechte');
    create_user();
    if (%fehler) {
		print 
			"<h1>Fehlerhafte Eingabe!</h1>",
			"<p>Der Benutzer konnte leider nicht eingerichtet werden, da ihre Eingaben ",
			"fehlerhaft waren. Korrigieren Sie bitte ihre Eingabe und versuchen sie es noch ",
			"einmal.</p>",
			"<hr />",
			"<h2>Fehler:</h2>",
			"<strong>";
		foreach (keys %fehler) {
	    	print $_,"<br>\n";
		}
		print '</strong>';
		# Fehlermeldung: Format ungueltig    
		erzeuge_eingabefeld();

	} else {

		print "<h1>Erfolgreiche Benutzereinrichtung!</h1>
		<p>Der Benutzer <strong>$name</strong> wurde erfolgreich eingerichtet!\n";
		print $q->p;
		
		$rechte = '';
		foreach (keys %rechte) {
		    $rechte .= "$_ ";
		}
		$rechte = 'Sch&uuml;ler' if (not $rechte);
		print <<HERE;
<h2>Daten</h2>
<table>
<tr><td>Vollst&auml;ndiger Name</td><td>$name</td></tr>
<tr><td>Login-Name</td><td>$login</td></tr>
<tr><td>Passwort</td><td>$passwd</td></tr>
<tr><td>Home-Verzeichnis</td><td>$dhome</td></tr>
<tr><td>Rechte</td><td>$rechte</td></tr>
<tr><td>e-Mail-Adresse</td><td>$login\@gm.rt.schule-bw.de</td></tr>
</table>
HERE
$url=$q->url(-relative=>1);
print "<p><a href=\"$url\">Neuen Benutzer einrichten</a><p>";
print $q->a({-href=>'/'},'Zur&uuml;ck zur Hauptseite');
print $q->end_html;
    }
}

sub erzeuge_eingabefeld {
    print $q->start_form(-action=>$ENV{SCRIPT_NAME});
    print "\n",$q->p,'<table><tr><td>Vollst&auml;ndiger Name: </td><td>',$q->textfield(-name=>'fullname',
                    -default=>'',
		    -size=>'30',
		    -maxlength=>'60');
    print "\n</td></tr><tr><td>login-Name: </td><td>",$q->textfield(-name=>'login',
                    -default=>'',
		    -size=>'16',
		    -maxlength=>'32');

    print "\n</td></tr><tr><td>Passwort: </td><td>",$q->password_field(-name=>'passwort',
                         '-value'=>'passwort',
		         -size=>'8',
		         -maxlength=>'8');

    print "\n</td></tr></table><p><strong>Rechte: </strong>",$q->br,$q->checkbox_group(-name=>'rechte',
                         -values=>['Lehrer','Systemadministrator']);
			 
    print "\n",$q->p,$q->submit('send','Benutzer erzeugen');
    print $q->end_form;    
}





sub create_user {

use English;
use File::Copy;
$dhome="/home";

$login  = $q->param('login');
$name   = $q->param('fullname');
$passwd = $q->param('passwort');
@rechte_a = $q->param('rechte');
foreach (@rechte_a) {
    $rechte{$_}=1;
}
# Plausibilitaetspruefung:

if (length($passwd) > 8) {$fehler{'Passwort zu lang'}=1};
if (length($passwd) < 5) {$fehler{'Passwort zu kurz'}=1};
if ($login !~ /^[a-zA-Z][-a-zA-Z0-9._]+$/) {$fehler{'login-Name nicht g&uuml;ltig'}=1};
if ($login eq '') {$fehler{'login-Name zu kurz'}=1};
if ($name eq '') {$fehler{'Name zu kurz'}=1};
if (length($login) > 16) {$fehler{'login-Name zu lang'}=1};
if (length($name) > 60) {$fehler{'Name zu lang'}=1};
if (getpwnam $login) {$fehler{'Benutzer existiert schon'}=1};
if (%fehler) {return()};

# And now the program begins: 
# Checkboxen auswerten (in Hash umwandeln?)

#Home-Verzeichnis
if (defined $rechte{'Lehrer'}) 	{$dhome .= "/lehrer/";} 
else 	{$dhome .= "/schueler/";}

$dhome .= $login;	

# Gruppenzugehrigkeit
$add_groups = $login;
add2group('users');
# $add_groups = 'users';
if (defined $rechte{'Lehrer'}) {
    add2group('lehrer');
    add2group('internet');
} else {
    add2group('schueler');
}
if (defined $rechte{'Systemadministrator'}) {
    add2group('admin')
}

$output = `sudo /usr/sbin/groupadd $login 2>&1`;
#print "Gruppe erzeugt (Output:\n$output\n)";
$enc_passwd = crypt ($passwd, join('',('.','/', 0..9, 'A'..'Z', 'a'..'z')[rand 64, rand 64]));
setgrent;
eval {
	local $SIG{ALRM} = sub { die "Gruppe konnte nicht eingerichtet werden! (Timeout)\n" };
	alarm 120;
	while (not defined($gid = getgrnam $login)) {endgrent;setgrent;} #warten, bis die group vom System erkannt wird...
	# Gefahr eines Deadlocks?
	alarm 0;
};
endgrent;
if ($@) {$fehler{"$@"}=1; return();};
#print "User existiert\n";
$output = `sudo /usr/sbin/useradd -c \'$name\' -d $dhome -g $gid -G $add_groups -p $enc_passwd -s \'/bin/false\' -m $login 2>&1`;
#print "useradd-output:\n$output\n";
if ($?) {$fehler{'<i>useradd</i> funktioniert nicht richtig!'}=1; return();}
#print "Benutzer erzeugt(Output:\n$output)\n";
system("sudo mkdir -m 0755 /home/public_html/$login");
eval {
	local $SIG{ALRM} = sub { die "Benutzer konnte nicht eingerichtet werden! (Timeout)\n" };
	alarm 120;
	while (not defined($uid = getpwnam $login)) {}
	alarm 0;
};
if ($@) {$fehler{"$@"}=1; return();};
#print "Benutzer existiert\n";
system("sudo chown $uid:$gid /home/public_html/$login");
system("sudo ln -s /home/public_html/$login /$dhome/public_html");
#system("sudo mkdir /usr/local/samba/profiles/$login");
#quotas setzen
system("sudo /usr/sbin/setquota $login 51200 51200 0 0 /dev/md0");
#print "Verzeichnisse erzeugt\n";
open PIPE, "|sudo smbpasswd -s -a $login > /dev/null" or $fehler{"<i>smbpasswd</i> funktioniert nicht richtig (on PIPE-Open) ($!)"}=1, return();
print PIPE $passwd,"\n",$passwd,"\n" or $fehler{"<i>smbpasswd</i> funktioniert nicht richtig (on passwd-print) ($!)"}=1, return();
close PIPE; #  or $fehler{"<i>smbpasswd</i> funktioniert nicht richtig (on PIPE-close) ($!)"}=1, return();
#print "Samba-Passwort\n";
system "sudo /usr/local/sbin/generate_apache_auth";
system "sudo /usr/local/sbin/make_mozilla_config.pl $dhome/Mozilla \'$login\' \'$name\'";
#print "Rest erzeugt!";
}
sub add2group {
    $add_groups .= ','.$_[0];
}
__END__ of adduser.cgi
