#!/usr/bin/perl

print "Content-type: text/html\n\n";

my $uhrzeit = localtime();

print <<HTML;
<html>
<head>
  <title>Netzstatus</title>
</head>
<body>
<h1>Netzstatus</h1>

<i>$uhrzeit</i><p>

<table border="1">
<tr><th>Host</th><th>Beschreibung</th><th>Erreichbar?</th></tr>
HTML

my %hosts;
my %reachable;
$hosts{"192.168.0.1"} = "server";
$hosts{"192.168.0.136"} = "Access Point";
$hosts{"192.168.0.137"} = "PrintServer R23 hpdj930c";
$hosts{"192.168.0.138"} = "Drucker magicolor 2350 R23";
$hosts{"192.168.0.139"} = "Drucker OkiPage R23";
$hosts{"192.168.0.254"} = "Drucker HP LJ5 R104";

foreach (keys(%hosts)) {
  my $ip = $_;
  system("ping -nc1 $ip > /dev/null 2>&1");
  my $ret = $?;
  $reachable{$ip} = not $ret;
}

foreach (keys(%hosts)) {
  my $ip = $_;
  print qq(<tr><td>$ip</td><td>$hosts{$ip}</td>);
  print qq(<td bgcolor="green">Ja</td>) if ($reachable{$ip});
  print qq(<td bgcolor="red">Nein</td>) if (not $reachable{$ip});
  print qq(</tr>);
}

print <<HTML;
</table>
</body>
</html>
HTML

