#!/usr/bin/perl

# samba-logger.cgi
# 2002/03/20
# leichte nderung: 2004/07/19 fr debian
# Andreas Dangel <a.dangel@gmx.de>

use CGI;

#########################################################
################## MAIN PROGRAM #########################
#########################################################

$q = new CGI;
print "Content-type: text/html\n\n";
print "<html>\n";
print "<head>\n";
print "    <title>samba-logger</title>\n";
print "</head>\n";
print "<body>\n";
print "<h1>samba-logger</h1>\n";

$url = $q->url();
print "<p>\n";
print "<a href=\"$url\">samba-logger.cgi</a>\n";
print "<p>\n";


if (defined($q->param('logfile'))) {
    $logfile = $q->param('logfile');
    @loglines = &openLogfile($logfile);
    &analyze_loglines(\@loglines);
} else {
    @SambaLogfiles = &getSambaLogfiles();
    print "<form method=\"post\">\n";
    foreach(@SambaLogfiles) {
        print "<input type=\"radio\" name=\"logfile\" value=\"$_\">$_<br>\n";
    }
    print "<input type=\"submit\" name=\"submit\">\n";
    print "</form>\n";
}

print "<p>\n";
print "<a href=\"$url\">samba-logger.cgi</a>\n";
print "<p>\n";

print "<hr>\n";
print "2002/03/20 - Andreas Dangel\n";

print "</body>\n";
print "</html>";

#print @SambaLogfiles;

#open(LOGFILE, "zcat $SambaLogfiles[1] |");
#@lines = <LOGFILE>;
#close(LOGFILE);
#print @lines;




#########################################################
#########################################################
sub getSambaLogfiles {
    @array = glob("/var/log/samba/log.smb*");
    my @array2 = grep(!/smbd/, @array);
    return @array2;
}

sub openLogfile {
    $file = shift;
    if ( $file =~ s/\.gz// ) {
        open(FHANDLE, "zcat $file |");
    } else {
        open(FHANDLE, "$file");
    }
    @lines = <FHANDLE>;
    close(FHANDLE);
    return @lines;
}

sub analyze_loglines {
    $samba_lines = shift;
    @input = @$samba_lines;
    #print @input;
    $zeilen = @input;
    @data = ();
    %logins = {};

for ($i = 0; $i < $zeilen; $i++) {
    $zeile1 = $input[$i];
    $i++;
    $zeile2 = $input[$i];

    if ($zeile1 =~ m/smbd\/service\.c\:make\_connection\(/) {
        if ($zeile2 =~ m/connect\ to\ service\ netlogon\ as\ user\ /) {
            $zeile1 =~ s/smbd\/service\.c\:make\_connection\(//;
            $zeile2 =~ s/connect\ to\ service\ netlogon\ as\ user\ //;

            $datum = substr($zeile1, 0, 24);
            $datum = substr($datum, 1, 19);
            #chomp($datum = `date -d \"$datum\" +\%s`);
            $adresse = substr($zeile2, index($zeile2, "("));
            $adresse = substr($adresse, 1, index($adresse, ")")-1);
	    $rechner = substr($zeile2, 2, index($zeile2, "(")-3);
	    #$adresse .= " ($rechner)";
            #$adresse = substr($zeile2, 2, 23);
            #$login = substr($zeile2, 25);
            #$login = substr($login, 0, index($login, "("));
            $login = substr($zeile2, index($zeile2, ")")+1);
            $login = substr($login, 0, index($login, "("));

            $logins{$adresse} = ["$adresse ($rechner)", $datum, $login];
        }
    }
    elsif ($zeile1 =~ m/smbd\/service\.c\:close\_cnum\(/) {
        if ($zeile2 =~ m/closed\ connection\ to\ service\ pub/) {
            $zeile1 =~ s/smbd\/service\.c\:close\_cnum\(//;
            $zeile2 =~ s/closed\ connection\ to\ service\ pub//;

            $datum = substr($zeile1, 0, 24);
            $datum = substr($datum, 1, 19);
            #chomp($datum = `date -d \"$datum\" +\%s`);
            #$adresse = substr($zeile2, 2, 23);
            $adresse = substr($zeile2, index($zeile2, "("));
            $adresse = substr($adresse, 1, index($adresse, ")")-1);


            if (exists($logins{$adresse})) {
                $ref = $logins{$adresse};
                push(@$ref, $datum);

                delete($logins{$adresse});

                push(@data, $ref);
             }

        }
    } else {
        $i--;
    }

}
    &sort(\@data);
    &output(\@data);
}

sub sort {
    $ref = shift;
    @data = @$ref;
    $lines = @data;
    #print STDERR "$lines\n";
    for ($i = 0; $i < $lines - 1; $i++) {
        #printf STDERR "%d of %d (%.1f%%)\r", $i, $lines-1, 100*$i/($lines-1);

        for ($k = 0; $k < $lines -1; $k++) {
            $ref_a = $data[$k];
            $ref_b = $data[$k + 1];

            $time_a = @$ref_a[1];
            #chomp($time_a = `date -d \"$time_a\" +%s`);
            $time_b = @$ref_b[1];
            #chomp($time_b = `date -d \"$time_b\" +%s`);


            if ($time_a gt $time_b) {
                #print "$time_a $time_b\n";

                $data[$k] = $ref_b;
                $data[$k + 1] = $ref_a;
            }

        }

        #exit;
    }
}

sub output {
    $ref = shift;
    @data = @$ref;

    print "<table border=1>\n";
    print "<tr><th>Anmeldung</th><th>Benutzer</th><th>IP-Adresse</th><th>Abmeldung</th></tr>\n";

    foreach (@data) {
        $ref = $_;
        $newline  = "<tr><td>" . @$ref[1] . "</td>";
        $newline .=     "<td>" . @$ref[2] . "</td>";
        $newline .=     "<td>" . @$ref[0] . "</td>";
        $newline .=     "<td>" . @$ref[3] . "</td></tr>";

        print $newline;

    }
    print "</table>\n";
}
