#!/usr/bin/perl -Tw
# GNU GPL (C) Thomas Bleher <ThomasBleher@gmx.de>
# zuletzt verndert am 19.01.2001
use strict;
use CGI;
use CGI::Carp;
use User::grent;
# Initialisation
my %valid_user = map { $_ => {} } @{(getgrnam('users'))->members};
my %valid_rights = map { $_ => 1 } qw(schueler lehrer internet);
my (%users, $userlist);

delete @ENV{'IFS','CDPATH','ENV','BASH_ENV'};
$ENV{'PATH'} = '/bin:/usr/bin:/usr/local/bin';

my $q = new CGI;
if ($q->param) {
	if ($q->param('abort')) {
		print_header('Benutzermanager');
		print_users();
	}
	%users = map { 
		/^(lock|unlock)\s+([-.\w]+)$/; 
		$valid_user{$2} ? ($2 => $1) : (); 
	} $q->param('users');
	if (not %users) {
		%users = map {
			((/([-.\w]+)/)[0] => 1)
		} split / /, $q->param('userlist');
	}
	$userlist = join ' ', keys %users;

	SWITCH: for ($q->param('action')) {
		/askpasswd/	&& do { ask_passwd();	last SWITCH; };
		/setpasswd/	&& do { set_passwd();	last SWITCH; };

		/askrights/	&& do { ask_rights();	last SWITCH; };
		/setrights/	&& do { set_rights();	last SWITCH; };

		/askremove/	&& do { ask_remove();	last SWITCH; };
		/setremove/	&& do { remove();		last SWITCH; };

		/lock/		&& do { lock_it();		last SWITCH; };

		print_header('Benutzermanager - ungltige Eingabe');
		print "<p>Action: '$_' (ungltig)\n";
		print_users();
	}
}
print_header('Benutzermanager');
print_users();


sub ask_passwd {
	print_header('Benutzermanager - Passwortnderung');

	print <<HERE;
<p>Von folgenden Benutzern soll das Passwort gendert werden: 
<b>$userlist</b>
<p>Bitte geben sie das neue Passwort ein:
<input type="password" name="password" size="8" maxlength="8" value="passwort" >
<input type="hidden"   name="action"   value="setpasswd">
<p>
<input type="submit"   name="do_it"    value="Passwort ndern">
<input type="submit"   name="abort"    value="Abbrechen">
<input type="hidden"   name="userlist" value="$userlist">
<p>Zurck zur <a href="./">Startseite</a>
HERE

	print $q->end_html, $q->end_html;
	exit;
}
sub set_passwd {
	print_header('Benutzermanager - Passwortnderung');
	my $passwd = ($q->param('password') =~ m@^([-\w#*,;:.+!$%&/|?{\[()\]}]+)$@)[0] or fehler('Das Passwort ist ung&uuml;ltig');
        open PIPE, '| /usr/bin/sudo /usr/local/sbin/chpw.pl'
            or fehler('Interner Fehler bei Passwortnderung (pipe open)');

	for my $user (keys %users) {
            print PIPE "$user $passwd\n"
                or fehler('Interner Fehler bei Passwortnderung (pipe write)');
        }

        close PIPE
            or fehler('Interner Fehler bei Passwortnderung (pipe close)');

	print "Von folgenden Benutzern wurde das Passwort gendert: <b>$userlist</b>";
	print_users();
}

sub ask_rights {
	print_header('Benutzermanager - Rechtenderung');
	print <<HERE;
<p>Von folgenden Benutzern sollen die Rechte gendert werden: 
<b>$userlist</b>
<h2>Rechte</h2>
<input type="checkbox" name="rights"   value="schueler"  >Schler		<br>
<input type="checkbox" name="rights"   value="lehrer"    >Lehrer		<br>
<input type="checkbox" name="rights"   value="internet"  >Internet		<br>
<!-- <input type="checkbox" name="rights"   value="supervisor">Administrator	<br> -->
Quota (0 = unbegrenzt): <input name="quota" size="8" value="20">MB
<p>
<input type="hidden"   name="action"   value="setrights">
<input type="hidden"   name="userlist" value="$userlist">
<input type="submit"   name="do_it"    value="Rechte ndern">
<input type="submit"   name="abort"    value="Abbrechen">
<p>Zurck zur <a href="./">Startseite</a>
HERE
	print $q->end_form, $q->end_html;
	exit;
}

sub set_rights {
	print_header('Benutzermanager - Rechtenderung');
	my $rights = 'users';
	$rights .= join '', map {
		/([-.\w]+)/; # untaint me
		$valid_rights{$1} ? ','.$1 : '' # return if valid
	} $q->param('rights');
#	my $shell = ($rights =~ /\bsupervisor\b/) ? '/bin/bash' : '/bin/false';
	my $shell = '/bin/false';
	my $quota = ($q->param('quota') =~ /(\d+)/)[0] * 1024; # convert to kB
	for my $user (keys %users) { # ext. helper prog. ?
		`/usr/bin/sudo /usr/sbin/usermod -s $shell -G $rights,$user $user`;
		`/usr/bin/sudo /usr/sbin/setquota $user $quota $quota 0 0 /dev/md0`;
		`/usr/local/sbin/generate_apache_auth`;
	}
	print "Von folgenden Benutzern wurden die Rechte auf <i>$rights</i> 
		ge&auml;ndert: <b>$userlist</b>\n";
	print_users();
}

sub ask_remove {
	print_header('Benutzermanager - Benutzer lschen');
	print <<HERE;
<p><strong style="color:#FF0000;">ACHTUNG!</strong> Folgende Benutzer werden
gel&ouml;scht: <b>$userlist</b> 
<p>Auch die Homeverzeichnisse und alle pers&ouml;nlichen Daten werden 
gel&ouml;scht und <b>k&ouml;nnen nicht wiederhergestellt werden</b>. Nur die 
<tt>public_html</tt>-Verzeichnisse bleiben erhalten.
<p>Wollen sie wirklich fortfahren?
<p>
<input type="submit" name="do_it"    value="Benutzer lschen">
<input type="submit" name="abort"    value="Abbrechen">
<input type="hidden" name="action"   value="setremove">
<input type="hidden" name="userlist" value="$userlist">
<p>Zurck zur <a href="./">Startseite</a>
HERE
	print $q->end_form, $q->end_html;
	exit;
}

sub remove {
	print_header('Benutzermanager - Benutzer lschen');
	open PIPE, '| /usr/bin/sudo /usr/local/sbin/rmusr.pl'
		or fehler('Interner Fehler bei der Benutzerlschung (pipe open)');
	print PIPE join "\n", keys %users
		or fehler('Interner Fehler bei der Benutzerlschung (pipe write)');
	close PIPE
		or fehler('Interner Fehler bei der Benutzerlschung (pipe close)');
	print "Folgende Benutzer wurden gel&ouml;scht: <b>$userlist</b>\n";
	print_users();
}

sub lock_it {
	print_header('Benutzermanager - Benutzer sperren und freigeben');
	while (my ($user, $action) = each %users) { # ext. helper app ?
		if ($action eq 'lock') {
			print "Sperre $user<br>";
			`/usr/bin/sudo /usr/bin/passwd -l $user`;
			`/usr/bin/sudo /usr/bin/smbpasswd -d $user`;
		} elsif ($action eq 'unlock') {
			print "Gebe $user frei<br>";
			`/usr/bin/sudo /usr/bin/passwd -u $user`;
			`/usr/bin/sudo /usr/bin/smbpasswd -e $user`;
		}
	}
	`/usr/bin/sudo /usr/local/sbin/generate_apache_auth`;

	print_users();
}

# ----
sub print_header {
	my $title = shift;
	print $q->header, $q->start_html($title), $q->h1($title), $q->start_form;
}
sub fehler {
	my $fehler = shift;
	print "<p><b>Folgender Fehler ist aufgetreten: <i>$fehler</i></b>. &Uuml;berpr&uuml;fen sie ihre Eingabe oder kontaktieren sie den Systemadministrator.<p>";
	print_users();
}

sub print_users {
	get_data();
	print <<HERE;
<p>Zurck zur <a href="./">Startseite</a>
<table border="1">
<thead>
<tr>
<th>Login</th> <th>Name</th> <th>Gruppen (Rechte)</th> <th>Quota</th> <th>Status</th>
</thead>
<tbody>
HERE
	my @sorted_users = sort 
			{$valid_user{$a}{'sort'} cmp $valid_user{$b}{'sort'}} 
		keys %valid_user;
	for my $user (@valid_user{@sorted_users}) {
		print <<HERE;
<tr $user->{'bgcolor'}>
	<td>$user->{'login'}</td>
	<td>$user->{'name'}</td>
	<td>$user->{'groups'}</td>
	<td>$user->{'quota'}</td>
	<td>$user->{'status'} $user->{'action'}</td>
</tr>
HERE
	}
	print <<HERE;
</tbody>
</table>
<h2>Aktion</h2>
<input type="radio"  name="action" value="lock"     >Benutzer sperren/freigeben<br>
<input type="radio"  name="action" value="askpasswd">Passwort ndern<br>
<input type="radio"  name="action" value="askrights">Rechte ndern<br>
<input type="radio"  name="action" value="askremove">Benutzer lschen<br>
<input type="submit" name="do_it"  value="Befehl ausfhren">
<input type="reset"  name="dont"   value="Befehl verwerfen">
<p>Zurck zur <a href="./">Startseite</a>
HERE
	
	print $q->end_form, $q->end_html;
	exit;
}

sub get_data {
	USER: foreach (`/usr/bin/sudo /usr/local/sbin/user-status users`) {
		my ($login,$status,$used,$quota) = (/^([-\w.]+) (\w) (\d+) (\d+)/);
											# Name     Status used quota
		next USER unless $valid_user{$login};
		for my $user ($valid_user{$login}) {
			if ($status eq 'L') {
				$user->{'status'} = 'gesperrt';
				$user->{'bgcolor'} = 'bgcolor="#EEEEEE"';
				$user->{'action'} = '<input type="checkbox" name="users" value="unlock '.$login.'">';
			} else {
				$user->{'status'} = 'aktiviert';
				$user->{'bgcolor'} = 'bgcolor="#FFFFDD"';
				$user->{'action'} = '<input type="checkbox" name="users" value="lock '.$login.'">';
			}				
			$user->{'quota'}  = int($used/1000). '/'. int($quota/1000). 'MB';
			$user->{'name'}   = (getpwnam($login))[6];
			$user->{'login'}  = $login;
			$user->{'sort'}   = 
				($login =~ /^([a-z])\.([-a-z]+)$/) ? ".$2.$1" # Lehrer
					: ($login =~ /^([a-z])([-a-z]+)(\d\d)$/) ? "$3$2.$1" # Schler
					: 'zzz'.$login; # sonstige Benutzer
		}
	}

	setgrent;
	GROUP: while (my $group = getgrent) {
		next GROUP if $group->name eq 'users';
		for my $user (@{$group->members}) {
			$valid_user{$user}{'groups'} .= $group->name . ' ' if $valid_user{$user};
		}
	}
	endgrent;
			
}
__END__ of usermanager.cgi

