#!/usr/bin/perl -w
#
# /usr/local/httpd/internet/index.cgi
#
# browser-frontend fr proxy-manager
#
# (c) 2001 Thomas Bleher <ThomasBleher@gmx.de>
# (c) 2002 Andreas Dangel
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#

use strict;
use CGI;

my $q = new CGI;

my $login;
my $user;
my $lehrer;
my $ip;
my $welche;
my $dauer;
my $status1;
my $status2;
my $status3;

$login = $q->remote_user;
if (not $user = (getpwnam($login))[6]) {
    die "Unauthorized access to internet/index.cgi! Username: $login";
}
$lehrer = ((getgrnam('lehrer'))[3] =~ /\b\Q$login\E\b/);
$ip = $ENV{REMOTE_ADDR} or die "No REMOTE_ADDR!";

if ($q->param()) {

    if ($q->param('aktivieren')) {
        if ($lehrer) {
            if ($q->param('welche') eq 'alle') {
                $welche = 'all';
            } else {
                $welche = $ip;
            }
        } else {
            $welche = $ip;
        }

        $dauer = $q->param('dauer');
        $dauer += 0;  # In Zahl umwandeln
        if (($dauer < 1) or ($dauer > 180)) {
            $dauer = 45;
        }
        $dauer *= 60;
        $dauer += time;

        system("/usr/bin/sudo /usr/local/sbin/proxy-manager -o $login $welche $dauer"); # IPs freischalten
    } elsif ($q->param('deaktivieren')) {
        if ($lehrer) {
            if ($q->param('welche') eq 'alle') {
                $welche = 'all';
            } else {
                $welche = $ip;
            }
        } else {
            $welche = $ip;
        }

        system("/usr/bin/sudo /usr/local/sbin/proxy-manager -c $welche");
    }
} else {
    # keine Parameter gegeben:
}


$status1 = `/usr/bin/sudo /usr/local/sbin/proxy-manager -a $ip`;
$status2 = `/usr/bin/sudo /usr/local/sbin/proxy-manager -a all`;
`/usr/bin/sudo /usr/local/sbin/firewall status > /dev/null 2>&1`;
$status3 = $?;

#######################
##### AUSGABEN ########
#######################

print $q->header;

if ( $status3 != "0" ) {
    print
        $q->start_html( -title=>'Internet-Einwahl - Internet aktiviert',
                        -author=>'webmaster@gm.rt.schule-bw.de'),
        $q->h1('Internet-Einwahl - Internet aktiviert'),
        "Da die Firewall deaktiviert ist, ist das Internet <strong>immer</strong> und fr <strong>jeden</strong> Computer aktiviert!!";
} elsif ($status1 eq $ip) {
    print
        $q->start_html( -title=>'Internet-Einwahl - Internet aktiviert',
                        -author=>'webmaster@gm.rt.schule-bw.de'),
        $q->h1('Internet-Einwahl - Internet aktiviert'),
        $q->p, $q->startform,
        $q->em("Hallo $user, der Internetzugang ist <b>fr diesen Computer aktiviert</b>.");
    if ($status2 eq "all") {
        print $q->br, $q->em("Auerdem ist der Internetzugang <b>fr alle aktiviert</b>.");
    }
    print $q->p;

    if ($status2 && $lehrer) {
        print $q->popup_menu('welche',['eigener', 'alle'], 'eigener'), 'Computer';
    } elsif (not $lehrer) {
        print $q->popup_menu('welche',['eigener'], 'eigener'), 'Computer';
    }

    print $q->br, $q->submit(-name=>'deaktivieren', -value=>'Zugang deaktivieren');
} elsif ($status2 eq "all") {
    print
        $q->start_html( -title=>'Internet-Einwahl - Internet fr alle aktiviert',
                        -author=>'webmaster@gm.rt.schule-bw.de'),
        $q->h1('Internet-Einwahl - Internet fr alle aktiviert'),
        $q->p, $q->startform,
        $q->em("Hallo $user, der Internetzugang ist <b>fr alle aktiviert</b>.");
 
    if ($lehrer) {
        print $q->p;
        print $q->popup_menu('welche', ['alle'], 'alle'), 'Computer';
        print $q->br, $q->submit(-name=>'deaktivieren', -value=>'Zugang deaktivieren');
    }
} else {
    print
        $q->start_html( -title=>'Internet-Einwahl - Internet deaktiviert',
                        -author=>'webmaster@gm.rt.schule-bw.de'),
        $q->h1('Internet-Einwahl - Internet deaktiviert'),
        $q->p, $q->startform,
        $q->em("Hallo $user, der Internetzugang ist nicht aktiviert."),
        $q->p;

    print "<br>Dauer: ", $q->popup_menu('dauer', [5,10,15,20,30,45,60,75,90,120,150,180],45),"min.";
    print $q->br;
    if ($lehrer) {
        print $q->popup_menu('welche',['eigener', 'alle'], 'eigener'), 'Computer';
    } else {
        print $q->popup_menu('welche',['eigener'], 'eigener'), 'Computer';
    }
    print $q->br,$q->submit(-name=>'aktivieren', -value=>'Zugang aktivieren');
}

print '<p><strong>Zur&uuml;ck zur <a href="../">Startseite</a></strong>';
print <<HERE;
<hr><strong>Anmerkung zum Internetzugang</strong>: Dass der Internetzugang
eingeschaltet ist bedeutet nicht notwendigerweise, dass eine
Verbindung ins Internet besteht. Vielmehr wird die Verbindung nur
aufgebaut, wenn Daten aus dem Internet angefordert werden und die
Verbindung wird nach einiger Zeit der Inaktivit&auml;t (zur Zeit 120
Sekunden) von selbst wieder abgebaut. Die Zeitangabe gibt an, wie lange
der Internetzugang maximal aktiv sein darf, bevor er zwangsweise beendet wird.
Er kann natrlich auch frher beendet werden.
HERE

print $q->endform,
      $q->end_html;
