#!/usr/bin/perl -wT
# (C) 2001 Thomas Bleher (ThomasBleher@gmx.de) under the GNU GPL
#
# Erlaubt Benutzern, eine Mail-Weiterleitung anzugeben
# Letzte nderung: 19.01.2001
use strict;
use CGI;
use CGI::Carp;

# Initialization
$ENV{'PATH'} = '/bin:/usr/bin';
delete @ENV{'IFS', 'CDPATH', 'ENV', 'BASHENV'};
$ENV{'SHELL'} = '/bin/sh' if exists $ENV{'SHELL'};

my $login = ($ENV{'REMOTE_USER'} =~ /^([-\w.]+)$/)[0];
my $user = (getpwnam($login))[6]; # untainting ???

my ($alias, $qlogin, $qalias, $cmdline);

my $q = new CGI;
print $q->header, $q->start_html('eMail-Weiterleitung'),
	  $q->h1('eMail-Weiterleitung'), $q->start_form;

if (defined ($alias = $q->param('alias'))) {
	if ($alias !~ /^([-\w.]+\@[-.a-zA-Z0-9]+)?$/) { # entweder gltige Mail-Adresse oder gar keine
		print <<HERE;
<h1 style="color:#FF0000;">Ung&uuml;ltige eMail-Adresse!</h1>
<p>Ihre eMail-Adresse ($alias) scheint ung&uuml;ltig zu sein! Sollte es sich
tats&auml;chlich um eine g&uuml;ltige Adresse handeln, setzen sie sich bitte
mit dem <a href="mailto:sysadmin\@gm.rt.schule-bw.de">Administrator</a> in
Verbindung, damit ihre Adresse manuell eingetragen werden kann!
HERE

	} else {
# construct commandline
#		$qlogin = quotemeta($login);
#		$qalias = quotemeta($alias);
#		$cmdline = 'undef $/; $_ = <>; s/^'.$qlogin.':.*?\\\\'.$qlogin.'$/'.$qlogin.': '.$qalias.', \\\\'.$qlogin.'/m or $_ .= "\n'.$qlogin.': '.$qalias.', \\\\'.$qlogin.'"; print; system "/usr/bin/newaliases > /dev/null 2>&1";'; # some magic here ...

		system '/usr/bin/sudo','/usr/local/sbin/change-aliases',$login,$alias;
#			or die 'Error while executing /usr/local/sbin/change-aliases';

		if ($alias) {
			print <<HERE;
<p><b>Mail-Weiterleitung erfolgreich ge&auml;ndert; eMail an 
<i>$login\@gm.rt.schule-bw.de</i> wird ab sofort an <i>$alias</i> 
weitergeleitet.</b>
HERE
		} else {
			print <<HERE;
<p><b>Mail-Weiterleitung erfolgreich gel&ouml;scht.</b>
HERE
		}
	}
} else {
	# bestimme aktuellen Alias
	open INPUT, '</etc/aliases';
	my $input = join '', <INPUT>;
	close INPUT;	
	$alias = ($input =~ /^\s*?$login:\s*?([-\w.]+\@[-.a-zA-Z0-9]+),\s*?\\$login\s*?$/m)[0] || '';

	print <<HERE;
<p>Hallo <b>$user</b>. Ihre aktuelle eMail-Adresse ist 
<i>$login\@gm.rt.schule-bw.de</i>. Hier k&ouml;nnen sie eine zus&auml;tzliche
externe eMail-Adresse angeben (zum Beispiel bei GMX, T-Online, ...), um ihre
eMails auch au&szlig;erhalb der Schule zu empfangen. Alle eMails an ihre 
Schuladresse werden automatisch an ihre externe Adresse weitergeleitet.
<p>eMail-Weiterleitung an: <input type="text" name="alias" value="$alias" 
size="40">
<p><input type="submit" value="Mail-Weiterleitung ndern">
<hr><p>Bei Problemen melden sie sich bitte beim <a 
href="mailto:sysadmin\@gm.rt.schule-bw.de">Systemadministrator</a>
HERE

}
print '<p>Zur&uuml;ck zur <a href="/">Startseite</a>';
print $q->end_form, $q->end_html;
__END__

