#!/usr/bin/perl -wT
# (C) 2001 Thomas Bleher <ThomasBleher@gmx.de> under the GNU GPL
# Zuletzt gendert am 22.01.2001

use CGI;# qw(:standard);
use CGI::Carp qw(fatalsToBrowser);
#use Crypt::Cracklib;

# Konfiguration:
$PASSWORD_STRENGTH_CHECK = 0; # soll Passwort auf Sicherheit berprft werdem?
                              # 1: Ja; 0: Nein
# Konfiguration Ende

my $q = new CGI;
my $login = ($ENV{REMOTE_USER} =~ /^([-\w.]+)$/)[0]; # untaint me
my $user = ((getpwnam($login))[6] =~ /^([- \w]+)$/i)[0]; # me too (accents bercksichtigen?)

delete @ENV{'IFS', 'CDPATH', 'ENV', 'BASH_ENV'};
$ENV{'PATH'} = '/bin:/usr/bin:/usr/local/bin';

my %errors = (
	'difference'	=> 'Die beiden eingegebenen Passw&ouml;rter waren leider nicht identisch! :-( ',
	'too short'		=> 'Das Passwort ist leider zu kurz! Es muss mindestens 5 Zeichen lang sein! ', 
	'too long'		=> 'Das Passwort ist leider zu lang! Es darf h&ouml;chstens 8 Zeichen lang sein! ',
	'ungueltig'		=> 'Das Paswort enthlt ungltige Zeichen! Erlaubt sind die Zeichen <b>a-z</b>, <b>A-Z</b>, <b>0-9</b> sowie <b>#*,;:._-+$%&amp;/|?{[()]}</b>! ',
	'too easy'		=> 'Das Passwort ist zu leicht erratbar! W&auml;hlen sie ein schwierigeres Passwort!!! Genauer Fehler: ',
);

print $q->header,
	$q->start_html( -title=>'Passwortnderung',
					-author=>'webmaster@gm.rt.schule-bw.de'),	
	$q->h1('Passwortnderung'),
	"Hallo Benutzer <b>$user</b> ($login)! (Wenn Sie nicht Benutzer 
	<b>$user</b> sind, melden sie sich bitte beim <A 
	HREF=\"mailto:webmaster\@gm.rt.schule-bw.de\">Systemadministrator</A>!)",
	$q->p, $q->startform;

if ($q->param()) { # Passwort aendern
	$pw1=$q->param('pw1');
	$pw2=$q->param('pw2');
# Error-checking
	$pw1 ne $pw2		&& fehler($errors{'difference'});
	length($pw1) < 5	&& fehler($errors{'too short'});
	length($pw1) > 8	&& fehler($errors{'too long'});
	$pw1 =~ m@[^-\w#*,;:.+!$%&/|?{[()]}]@ && fehler($errors{'ungueltig'});
	if ($PASSWORD_STRENGTH_CHECK) {
		my $fehler = fascist_check($pw1, '/usr/lib/cracklib_dict');
		$fehler !~ /^ok$/	&& fehler($errors{'too easy'}.'<b>"'.$fehler.'"</b>');
	}

# change passwd
#	my $pw = ($pw1 =~ m@^([-\w#*,;:.+!\$\%&/|?{\[()\]}]+)$@)[0]; # untaint me
	my $pw = ($pw1 =~ /(.+)/)[0]; # was already checked
	$enc_passwd = crypt($pw,join('',('.','/',0..9,'A'..'Z','a'..'z')[rand 64, rand 64]));
	system('sudo','/usr/sbin/usermod','-p',$enc_passwd,$login);
	fehler_bei_aenderung() if ($! or $?);
	
	system('sudo','/usr/local/sbin/generate_apache_auth');

	open PIPE, "|sudo smbpasswd -a -s $login > /dev/null" or fehler_bei_aenderung();
	print PIPE $pw,"\n",$pw,"\n" or fehler_bei_aenderung();
	close PIPE or fehler_bei_aenderung();
				
	print "<p><strong>Passwort erfolgreich gendert!</strong>";
	
	sub fehler_bei_aenderung {
		print "<p><strong>Bei der Passwortnderung ist leider etwas 
			schiefgegangen. (Fehlermeldung: $!). Bitte melden sie den Fehler dem
			<a href=\"mailto:webmaster\@gm.rt.schule-bw.de\">Systemadministrator
			</a>!</strong>";
		ende();
	}
} else { 
    print <<HERE;
Hier haben sie die M&ouml;glichkeit, ihr Passwort zu ndern.
Geben Sie es bitte zweimal ein, damit sichergestellt ist, dass sie sich 
nicht vertippt haben.
<p><strong>Achtung:</strong> Ihr Passwort muss zwischen 5 und 8 Zeichen lang 
sein und darf die Buchstaben <b>a-z</b>, <b>A-Z</b>, die Zahlen <b>0-9</b> 
sowie die Zeichen <b>#*,;:._-+!\$\%\&/|?{[()]}</b> enthalten. 

<p style="color:red"><strong>Whlen sie 
ein Passwort, das nicht leicht zu erraten ist! Die 
Sicherheit ihrer Daten hngt entscheidend von der 
Sicherheit ihres Passworts ab!</strong>
<p style="color:red">Ihr Passwort sollte nicht nur Kleinbuchstaben, sondern auch Grobuchstaben,
Zahlen und Sonderzeichen beinhalten!
<p>Passwort eingeben:<br>
HERE

    print $q->password_field(-name=>"pw1",-size=>"8",-maxlength=>"8"),$q->br;
    print $q->password_field(-name=>"pw2",-size=>"8",-maxlength=>"8"),$q->br;
    print $q->submit(-name=>"eingeben",-value=>'Passwort verndern');
    ende();
}

sub fehler {
	my $fehler = shift;
   	print <<HERE;
<h1>Fehler</h1>
<p><strong style="color:#FF0000;">$fehler</strong>
<p>Geben Sie entweder die Passw&ouml;rter noch einmal ein oder gehen sie 
zur&uuml;ck zur <a href="/">Startseite</a>.

<p><strong>Achtung:</strong> Ihr Passwort muss zwischen 5 und 8 Zeichen lang 
sein und darf die Buchstaben <b>a-z</b>, <b>A-Z</b>, die Zahlen <b>0-9</b> 
sowie die Zeichen <b>#*,;:._-+!\$\%\&/|?{[()]}</b> enthalten. 

<p>
HERE
   	print $q->password_field(-name=>"pw1",-size=>"8",-maxlength=>"8"),$q->br;
   	print $q->password_field(-name=>"pw2",-size=>"8",-maxlength=>"8"),$q->br;
   	print $q->submit(-name=>"eingeben",-value=>'Passwort verndern');
	ende();
}

sub ende {
	print '<p>Zur&uuml;ck zur <a href="/">Startseite</a>';
	print $q->endform, $q->end_html;
	exit;
}
