#!/bin/sh

# Andreas Dangel <adabolo@adabolo.de>
# 2003/09/19

# Wiederherstellung:
# Beim Backup werden Dateien mit der Endung aa ab ac usw. erstellt.
# mit "cat userdir-backup-%datum.tar.bz2.* > eine_datei.tar.bz2" kann
# eine einzige Datei erstellt werden. Da die Datei wahrscheinlich
# grer als 2 GB (reiserfs-grenze??) ist, funktioniert das nicht.
# Daher kann nur mit "cat userdir-backup-%datum.tar.bz2.* | bunzip2 | tar xv"
# das Backup im aktuellen Verzeichnis entpackt werden.

# Liste der alten Backup-Dateien erstellen...
filelist=`ls /usr/local/samba/admin/userdir-backup/userdir-backup-*`


tmpfile=`mktemp /tmp/backup-filelist.XXXXXX`

echo 'Backup home-directories (/home) ...'
echo
tar cv /home 2> $tmpfile | bzip2 | split -b 2047m - /usr/local/samba/admin/userdir-backup/userdir-backup-`date +%Y%m%d`.tar.bz2.

if [ $? -ne 0 ]; then
  # es ist ein Fehler aufgetreten
  cat $tmpfile
else
  # kein Fehler
  # jetzt die (ganz) alten Backups lschen
  rm /usr/local/samba/admin/userdir-backup/old/*
  # die alten Backups verschieben
  mv $filelist /usr/local/samba/admin/userdir-backup/old/
fi

echo `cat $tmpfile | wc -l` files backup up.
rm $tmpfile

df -h

