'************************************************
' File:    UserLog.vbs (WSH sample in VBScript) 
' Author:  Gnter Born
'
' Writes the user name during each login into a
' log record. The script add itself into the Run
' key of the Registry.
'
' In no way shall the author be liable for any
' losses or damages resulting from the use of this
' program. Use AS-IS at your own risk.
'
' The code is the property of the author. You may
' use the code and modify it, as far as this header
' remains intact. Further updates and other samples
' may be found on my site:
' http://www.borncity.de
' http://www.borncity.com/WSHBazaar/WSHRecordUser.htm
'************************************************
'
' erweitert: 2004 Andreas Dangel www.adabolo.de
' mit Hilfe von http://msdn.microsoft.com/library/default.asp?url=/library/en-us/script56/html/wsconcreatingautomatingloginscrip.asp
'
'*********************************************+
Option Explicit
On Error Resume Next

Dim Text
Dim sUser
Dim WshNetwork         ' object variable

'# Add script into Run key !!!
'# so it will be executed during each logon
AddRun                 

' Create a new WshNetwork object to access Network properties
Set WshNetwork = WScript.CreateObject("WScript.Network")


' Username holen
sUser = WshNetwork.UserName

' Wenn nicht eingeloggt, beenden
if sUser = "" Then
  Text = date & " " & time &": Computer: " & _
       WshNetwork.ComputerName & vbTab
  Text = Text & "NICHT EINGELOGGT"
  ' remove for silent use !!!!
  'Wscript.Echo Text
  AddLog (Text)
  WScript.Quit
End if


' Eingeloggt
Text = date & "  " & time & ": Computer: " & _
      WshNetwork.ComputerName & vbTab
Text = Text & "User: " & _
      sUser

AddLog (Text)            ' write log file entry

' remove for silent use !!!!
'WScript.Echo Text        ' show result

'#### some Helpers ####
Sub AddRun()
' add the batchfile to launch the script into  
' the Run key of the Registry
DIM Root, key, valname, Command
Dim WshShell

 Root = "HKEY_LOCAL_MACHINE"
 key = "\Software\Microsoft\Windows\CurrentVersion\Run\"
 valname = "UserLog"
 Command = WScript.ScriptFullName
 Set WshShell = WScript.CreateObject("WScript.Shell")
 WSHShell.RegWrite Root+Key+valname, Command, "REG_SZ"
End Sub

Sub AddLog (txt)
Const file1 = "C:\Windows\UserLog.txt"   ' Log file name
Const ForAppending = 8           ' Append mode
Dim fso, fi                      ' object variable

' Creates a FileSystemObject object 
 Set fso = CreateObject("Scripting.FileSystemObject")

' open file, force create, if not exists
 Set fi = fso.OpenTextFile(file1, ForAppending, true)

 fi.WriteLine (txt)              ' append log
 Set fi = Nothing
End Sub
'*** End