import java.io.*;
import java.util.Vector;

public class Assembler2 {
	
	
	public static void main(String[] args)
	throws Exception {
		StringBuffer sb = new StringBuffer();
		BufferedReader br = new BufferedReader(new FileReader("programm.asm"));
		String line;
		while((line = br.readLine()) != null) {
			sb.append(line);
			sb.append("\n");
		}
		br.close();
		
		Scanner s = new Scanner(sb);
		
		/* 
		Vector tokens = s.scan();
		for(int i = 0; i < tokens.size(); i++) {
			Token t = (Token) tokens.get(i);
			System.out.println(Scanner.getTokenDescription(t.id) + " at line " + t.line + ", column " + t.column + ": " + t.data);
		}
		*/
		
		Parser p = new Parser();
		if (p.parse(s) == true) {
			System.out.println("PARSER RESULT: TRUE");
		} else {
			System.out.println("PARSER RESULT: FALSE!!!");
		}
		
		
	}
	
	private static class Statement {
		String keyword;
		Vector arguments;
		Vector arguments_tokens;
		short address;
		Short machinecode = null;
		
		Statement(String key, Vector args, Vector args_t, int a) {
			keyword = key;
			arguments = args;
			arguments_tokens = args_t;
			address = (short) a;
		}
		
		Statement(short code, int a) {
			address = (short) a;
			machinecode = new Short(code);
		}
		
		public String toString() {
			String s;
			if (machinecode == null) {
				s = "" + address + " " + keyword;
				if (arguments != null) {
					for(int i = 0; i < arguments.size(); i++) {
						s += " arg" + i + ": " + arguments.get(i);
						s += " (" + Scanner.getTokenDescription(((Integer) arguments_tokens.get(i)).intValue()) + ")";
					}
				}			
			} else {
				s = "machinecode: " + Integer.toHexString(machinecode.intValue() & 0xFFFF);
			}
			return s;
		}
	}
	
	private static class Label {
		String identifier;
		int pointer;
		
		Label(String id, int i) {
			identifier = id;
			pointer = i;
		}
		
		public String toString() {
			return identifier + " -> " + pointer;
		}
	}
	
	private static class Definition {
		String identifier;
		String keyword;
		Vector arguments;
		Vector arguments_tokens;
		int pointer;
		
		Definition(String id, String key, Vector args, Vector args_t, int i) {
			identifier = id;
			keyword = key;
			arguments = args;
			arguments_tokens = args_t;
			pointer = i;
		}
		
		public String toString() {
			String s = keyword + " " + identifier;
			s += " =";
			for(int i = 0; i < arguments.size(); i++) {
				s += " " + arguments.get(i);
				s += " (" + Scanner.getTokenDescription(((Integer) arguments_tokens.get(i)).intValue()) + ")";
				s += " [" + pointer + "]";
			}
			
			return s;
		}
		
		public int getWordSize() {
			int size = 0;
			if (keyword.toLowerCase().equals("dw")
					|| keyword.toLowerCase().equals("dc")) {
				for(int i = 0; i < arguments.size(); i++) {
					int tokenclass = ((Integer) arguments_tokens.get(i)).intValue();
					switch (tokenclass) {
					case Scanner.T_NUMBER:
					case Scanner.T_IDENTIFIER:
						size++;
					case Scanner.T_STRING:
						size += ((String) arguments.get(i)).length() - 2;
					}
				}
			} else if (keyword.toLowerCase().equals("db")) {
				size += arguments.size()/ 2 + 1;
			}
			
			return size;
		}
		
	}
	
	private static class Token {
		int id;
		String data;
		int line;
		int column;
	}
	
	
	public static class Parser {
		/*
		 * Parser:
		 * grammatic:
		 * 
		 * P    ::= line P1
		 * P    ::= NEWLINE P1
		 * P1   ::= P
		 * P1   ::= epsilon
		 * line ::= LABEL statement_optional comment_optional NEWLINE
		 * line ::= statement comment_optional NEWLINE
		 * line ::= comment_optional NEWLINE
		 * line ::= definition comment_optional NEWLINE
		 * line ::= NEWLINE
		 * comment_optional ::= COMMENT
		 * comment_optional ::= epsilon
		 * statement_optional ::= statement
		 * statement_optional ::= epsilon
		 * statement ::= KEYWORD argument_optional
		 * argument_optional ::= argument
		 * argument_optional ::= epsilon
		 * argument ::= NUMBER | STRING | IDENTIFIER
		 * argument2 ::= NUMBER argument3
		 * argument2 ::= STRING argument3
		 * argument2 ::= IDENTIFIER argument3
		 * argument3 ::= COMMA argument2
		 * argument3 ::= epsilon
		 * definition ::= IDENTIFIER KEYWORD argument2
		 */
		
		private int lookahead;
		private Scanner s;
		private String last_identifier = null;
		private String last_keyword = null;
		private Vector last_arguments = null;
		private Vector last_arguments_tokens = null;
		
		private Vector statements = null;
		private Vector labels = null;
		private Vector definitions = null;
		private int current_address = 0;
				
		public boolean parse(Scanner scanner) {
			s = scanner;
			
			statements = new Vector();
			labels = new Vector();
			definitions = new Vector();
			
			lookahead = s.getNextToken();
			boolean b = P();
			
			if (b) {
				System.out.println("\nStatements:");
				for(int i = 0; i < statements.size(); i++) {
					System.out.println("" + i + ": " + statements.get(i));
				}
				
				System.out.println("\nLabels:");
				for(int i = 0; i < labels.size(); i++) {
					System.out.println("" + i + ": " + labels.get(i));
				}
				
				
				System.out.println("\nDefinitions:");
				for(int i = 0; i < definitions.size(); i++) {
					System.out.println("" + i + ": " + definitions.get(i));
				}
				
				
				// elimintate constants (equ keyword)
				for(int i = 0; i < definitions.size(); i++) {
					if (((Definition) definitions.get(i)).keyword.toLowerCase().equals("equ")) {
						String identifier = ((Definition) definitions.get(i)).identifier;
						String value = (String) ((Definition) definitions.get(i)).arguments.get(0);
						Integer token = (Integer) ((Definition) definitions.get(i)).arguments_tokens.get(0);
						
						// eliminate in definitions
						for(int j = 0; j < definitions.size(); j++) {
							for (int k = 0; k < ((Definition) definitions.get(j)).arguments_tokens.size(); k++) {
								if (((Integer) ((Definition) definitions.get(j)).arguments_tokens.get(k)).intValue() == Scanner.T_IDENTIFIER) {
									if (((String) ((Definition) definitions.get(j)).arguments.get(k)).equals(identifier)) {
										((Definition) definitions.get(j)).arguments.set(k, value);
										((Definition) definitions.get(j)).arguments_tokens.set(k, token);
									}
									
								}
							}
						}
						
						// elimintate in statements, only if equ is a number!!
						if (token.intValue() == Scanner.T_NUMBER) {
							for(int j = 0; j < statements.size(); j++) {
								if ((((Statement) statements.get(j)).arguments_tokens != null)
										&& ((Integer) ((Statement) statements.get(j)).arguments_tokens.get(0)).intValue() == Scanner.T_IDENTIFIER) {
									if (((String) ((Statement) statements.get(j)).arguments.get(0)).equals(identifier)) {
										((Statement) statements.get(j)).arguments.set(0, value);
										((Statement) statements.get(j)).arguments_tokens.set(0, token);
									}
								}
							}
						}
					}
				}
				
				System.out.println("\nDefinitions2:");
				for(int i = 0; i < definitions.size(); i++) {
					System.out.println("" + i + ": " + definitions.get(i));
				}
				
				System.out.println("\nStatements2:");
				for(int i = 0; i < statements.size(); i++) {
					System.out.println("" + i + ": " + statements.get(i));
				}

				// convert the labels in the statemens into addresses
				
				// convert the definitions to addresses
				
				// replace the identifiers in the statements with the addresses
				

			}
			
			return b;
		}

		public static int parseNumber(String s) {
			int number = 0xF0000;
			
			try {
				if (s.startsWith("0x") || s.startsWith("0X")) {
					number = Integer.parseInt(s.substring(2), 16);
				} else if (s.startsWith("$")) {
					number = Integer.parseInt(s.substring(1), 16);
				} else if (s.endsWith("b") || s.endsWith("B")) {
					number = Integer.parseInt(s.substring(0, s.length()-1), 2);
				} else {
					number = Integer.parseInt(s);
				}
			} catch (NumberFormatException e) {
				e.printStackTrace();
			}
			
			return number;
		}
		
		private void syntaxError() {
			System.err.println("Parser Error at line " + s.line + ", column " + (s.column - s.getToken().length()));
		}
		
		private void syntaxError(String msg) {
			System.err.print("Parser Error at line " + s.line + ", column " + (s.column - s.getToken().length()));
			System.err.println(": " + msg);
		}
		
		private boolean P() {
			if (lookahead == Scanner.T_LABEL
					|| lookahead == Scanner.T_KEYWORD
					|| lookahead == Scanner.T_COMMENT
					|| lookahead == Scanner.T_IDENTIFIER) {
				return line() & P1();
			} else if (lookahead == Scanner.T_NEWLINE) {
				return NEWLINE() & P1();
			} else {
				syntaxError();
				return false;
			}
		}
		
		private boolean P1() {
			if (lookahead == Scanner.T_LABEL
					|| lookahead == Scanner.T_KEYWORD
					|| lookahead == Scanner.T_COMMENT
					|| lookahead == Scanner.T_IDENTIFIER
					|| lookahead == Scanner.T_NEWLINE) {
				return P();
			} else {
				return true;
			}
		}
			
		private boolean line() {
			if (lookahead == Scanner.T_LABEL) {
				return LABEL() & statement_optional() & comment_optional() & NEWLINE();
			} else if (lookahead == Scanner.T_KEYWORD) {
				return statement() & comment_optional() & NEWLINE();
			} else if (lookahead == Scanner.T_COMMENT) {
				return comment_optional() & NEWLINE();
			} else if (lookahead == Scanner.T_IDENTIFIER) {
				return definition() & comment_optional() & NEWLINE();
			} else if (lookahead == Scanner.T_NEWLINE) {
				return NEWLINE();
			} else {
				syntaxError();
				return false;
			}
		}
		
		private boolean comment_optional() {
			if (lookahead == Scanner.T_COMMENT) {
				return COMMENT();
			} else {
				return true;
			}
		}
		
		private boolean statement_optional() {
			if (lookahead == Scanner.T_KEYWORD) {
				return statement();
			} else {
				return true;
			}
		}
		
		private boolean statement() {
			if (lookahead == Scanner.T_KEYWORD) {
				boolean b = KEYWORD() & argument_optional();
				if (last_keyword.toLowerCase().equals("org")) {
					if (last_arguments == null) {
						syntaxError("address expected");
						return false;
					} else if (((Integer) last_arguments_tokens.get(0)).intValue() != Scanner.T_NUMBER) {
						syntaxError("number expected");
						return false;
					} else if (parseNumber((String) last_arguments.get(0)) > 0xfff) {
						syntaxError("address is too big");
						return false;
					} else {
						current_address = (short) parseNumber((String) last_arguments.get(0));
					}
				} else {
					// add the statement
					statements.add(new Statement(last_keyword, last_arguments, last_arguments_tokens, current_address++));
				}
				return b;
			} else {
				syntaxError();
				return false;
			}
		}
		
		private boolean argument_optional() {
			if (lookahead == Scanner.T_NUMBER
					|| lookahead == Scanner.T_STRING
					|| lookahead == Scanner.T_IDENTIFIER) {
				return argument();
			} else {
				last_arguments =  null;
				return true;
			}
		}
		
		private boolean argument() {
			if (last_arguments == null) {
				last_arguments = new Vector();
				last_arguments_tokens = new Vector();
			}
			if (lookahead == Scanner.T_NUMBER) {
				last_arguments.add(s.getToken());
				last_arguments_tokens.add(new Integer(Scanner.T_NUMBER));
				return NUMBER();
			} else if (lookahead == Scanner.T_STRING) {
				last_arguments.add(s.getToken());
				last_arguments_tokens.add(new Integer(Scanner.T_STRING));
				return STRING();
			} else if (lookahead == Scanner.T_IDENTIFIER) {
				last_arguments.add(s.getToken());
				last_arguments_tokens.add(new Integer(Scanner.T_IDENTIFIER));
				return IDENTIFIER();
			} else {
				syntaxError();
				return false;
			}
		}

		
		private boolean argument2() {
			if (last_arguments == null) {
				last_arguments = new Vector();
				last_arguments_tokens = new Vector();
			}
			if (lookahead == Scanner.T_NUMBER) {
				last_arguments.add(s.getToken());
				last_arguments_tokens.add(new Integer(Scanner.T_NUMBER));
				return NUMBER() & argument3();
			} else if (lookahead == Scanner.T_STRING) {
				last_arguments.add(s.getToken());
				last_arguments_tokens.add(new Integer(Scanner.T_STRING));
				boolean b = STRING();
				return b & argument3();
			} else if (lookahead == Scanner.T_IDENTIFIER) {
				last_arguments.add(s.getToken());
				last_arguments_tokens.add(new Integer(Scanner.T_IDENTIFIER));
				boolean b = IDENTIFIER();
				return b & argument3();
			} else {
				syntaxError();
				return false;
			}
		}
		
		private boolean argument3() {
			if (lookahead == Scanner.T_COMMA) {
				return COMMA() & argument2();
			} else {
				return true;
			}
		}
		
		private boolean definition() {
			if (lookahead == Scanner.T_IDENTIFIER) {
				boolean r = IDENTIFIER();
				if (r == true) {
					String id = last_identifier;
					r = r & KEYWORD() & argument2();
					
					Definition d = new Definition(id, last_keyword, last_arguments, last_arguments_tokens, current_address);
					current_address += d.getWordSize();
					
					definitions.add(d);
					last_arguments = null;
					last_arguments_tokens = null;
				}
				return r;
			} else {
				syntaxError();
				return false;
			}
		}
		
		private boolean IDENTIFIER() {
			if (lookahead == Scanner.T_IDENTIFIER) {
				last_identifier = s.getToken();
				lookahead = s.getNextToken();
				return true;
			} else {
				syntaxError();
				return false;
			}
		}
		
		private boolean KEYWORD() {
			if (lookahead == Scanner.T_KEYWORD) {
				last_keyword = s.getToken();
				last_arguments = null;
				last_arguments_tokens = null;
				lookahead = s.getNextToken();
				return true;
			} else {
				syntaxError();
				return false;
			}
		}
		
		private boolean COMMA() {
			if (lookahead == Scanner.T_COMMA) {
				lookahead = s.getNextToken();
				return true;
			} else {
				syntaxError();
				return false;
			}
		}
		
		private boolean NUMBER() {
			if (lookahead == Scanner.T_NUMBER) {
				lookahead = s.getNextToken();
				return true;
			} else {
				syntaxError();
				return false;
			}
		}
		
		private boolean STRING() {
			if (lookahead == Scanner.T_STRING) {
				lookahead = s.getNextToken();
				return true;
			} else {
				syntaxError();
				return false;
			}
		}
		
		private boolean COMMENT() {
			if (lookahead == Scanner.T_COMMENT) {
				lookahead = s.getNextToken();
				return true;
			} else {
				syntaxError();
				return false;
			}
		}
		
		private boolean NEWLINE() {
			if (lookahead == Scanner.T_NEWLINE) {
				lookahead = s.getNextToken();
				return true;
			} else {
				syntaxError();
				return false;
			}
		}
		
		private boolean LABEL() {
			if (lookahead == Scanner.T_LABEL) {
				labels.add(new Label(s.getToken(), current_address));
				lookahead = s.getNextToken();
				return true;
			} else {
				syntaxError();
				return false;
			}
		}
		
	}
	
	public static class Scanner {
		/*
		 * Scanner:
		 * Tokens:
		 *  Comment   : (;[^\n]*)|(//[^\n]*)
		 *  Newline   : \n
		 *  Label     : [a-zA-Z][a-zA-Z0-9]*:
		 *  Identifier: [a-zA-Z][a-zA-Z0-9]*
		 *  Keyword   : org|equ|dc|dw|db|STO|LDA|BRZ|ADD|SUB|OR|AND|XOR|LDAR|
		 *              INCAR|LDI|STI|CPI|SHL|SHR|BRC
		 *              --> case insensitive!
		 *  Number    : 0[0-9]*|[1-9]+|0x[0-9a-fA-F]+|$[0-9a-fA-F]+|[01]+b
		 *  String    : '[^'\n]*'|"[^"\n]*"
		 *  Comma     : ,
		 *  
		 *  States:
		 *   1: ;
		 *   2: /
		 *   3: a
		 *   4: b
		 *   5: c
		 *   6: d
		 *   7: e
		 *   8: l
		 *   9: 0
		 *  10: s
		 *  11: i
		 *  12: f|g|h|j|k|m|n|p|q|r|t|u|v|w|y|z
		 *  13: 0
		 *  14: 1
		 *  15: [2-9]|decimal
		 *  16: $
		 *  17: '
		 *  18: "
		 *  19: ad
		 *  20: an
		 *  21: br
		 *  22: cp
		 *  23: -> Keyword | Label | Identifier
		 *  24: eq
		 *  25: ld
		 *  26: or
		 *  27: su
		 *  28: st
		 *  29: sh
		 *  30: in
		 *  31: octal|binary
		 *  32: octal
		 *  33: hexadecimal
		 *  34: decimal|binary
		 *  35: inc
		 *  36: inca
		 */
		
		
		public static final int T_EOF = -1;
		// Tokens
		public static final int T_UNKNOWN = 0;
		public static final int T_COMMENT = 1;
		public static final int T_LABEL = 2;
		public static final int T_IDENTIFIER = 3;
		public static final int T_KEYWORD = 4;
		public static final int T_NUMBER = 5;
		public static final int T_STRING = 6;
		public static final int T_COMMA = 7;
		public static final int T_NEWLINE = 8;

		private StringBuffer in;
		private int index = 0;
		private int state = 0;
		private String token = "";
		private int line = 1;
		private int column = 0;
		
		public Scanner(StringBuffer i) {
			in = i;
		}
		
		public static String getTokenDescription(int i) {
			switch (i) {
			case T_EOF: return "T_EOF";
			case T_UNKNOWN: return "T_UNKNWON";
			case T_COMMENT: return "T_COMMENT";
			case T_LABEL: return "T_LABEL";
			case T_IDENTIFIER: return "T_IDENTIFIER";
			case T_KEYWORD: return "T_KEYWORD";
			case T_NUMBER: return "T_NUMBER";
			case T_STRING: return "T_STRING";
			case T_COMMA: return "T_COMMA";
			case T_NEWLINE: return "T_NEWLINE";
			}
			
			return "unknown token id!";
		}
		
		public String getToken() {
			return token;
		}
		
		public Vector scan() {
			Vector tokens = new Vector();
			Token t;
			int token;
			
			while((token = getNextToken()) != T_EOF) {
				t = new Token();
				t.id = token;
				t.data = getToken();
				t.line = line;
				t.column = column - t.data.length();
				tokens.add(t);
			}
			
			return tokens;
		}
		
		public int getNextToken() {
			char c = in.charAt(index);
			index++;
				
			column++;
			
			if (index == in.length()) {
				// reset
				index = 0;
				line = 1;
				column = 0;
				return T_EOF;
			}
			
			switch (state) {
			case 0:
				token = "";
				switch (c) {
				case ';':
					state = 1;
					token += c;
					return getNextToken();
				case '/':
					state = 2;
					token += c;
					return getNextToken();
				case '\n':
					state = 0;
					line++;
					column = 0;
					return T_NEWLINE;
				case 'a':
				case 'A':
					state = 3;
					token += c;
					return getNextToken();
				case 'b':
				case 'B':
					state = 4;
					token += c;
					return getNextToken();
				case 'c':
				case 'C':
					state = 5;
					token += c;
					return getNextToken();
				case 'd':
				case 'D':
					state = 6;
					token += c;
					return getNextToken();
				case 'e':
				case 'E':
					state = 7;
					token += c;
					return getNextToken();
				case 'l':
				case 'L':
					state = 8;
					token += c;
					return getNextToken();
				case 'o':
				case 'O':
					state = 9;
					token += c;
					return getNextToken();
				case 's':
				case 'S':
					state = 10;
					token += c;
					return getNextToken();
				case 'i':
				case 'I':
					state = 11;
					token += c;
					return getNextToken();
				case 'f':
				case 'F':
				case 'g':
				case 'G':
				case 'h':
				case 'H':
				case 'j':
				case 'J':
				case 'k':
				case 'K':
				case 'm':
				case 'M':
				case 'n':
				case 'N':
				case 'p':
				case 'P':
				case 'q':
				case 'Q':
				case 'r':
				case 'R':
				case 't':
				case 'T':
				case 'u':
				case 'U':
				case 'v':
				case 'V':
				case 'w':
				case 'W':
				case 'y':
				case 'Y':
				case 'z':
				case 'Z':
					state = 12;
					token += c;
					return getNextToken();
				case '0':
					state = 13;
					token += c;
					return getNextToken();
				case '1':
					state = 14;
					token += c;
					return getNextToken();
				case '2':
				case '3':
				case '4':
				case '5':
				case '6':
				case '7':
				case '8':
				case '9':
					state = 15;
					token += c;
					return getNextToken();
				case '$':
					state = 16;
					token += c;
					return getNextToken();
				case '\'':
					state = 17;
					token += c;
					return getNextToken();
				case '"':
					state = 18;
					token += c;
					return getNextToken();
				case ',':
					state = 0;
					token += c;
					return T_COMMA;
				case ' ':
				case '\t':
					state = 0;
					return getNextToken();
				default:
					state = 0;
					token += c;
					return T_UNKNOWN;
				}
				
				
			case 1:
				switch (c) {
				case '\n':
					state = 0;
					index--;
					return T_COMMENT;
				default:
					state = 1;
					token += c;
					return getNextToken();
				}
				
			case 2:
				switch (c) {
				case '/':
					state = 1;
					token += c;
					return getNextToken();
				default:
					state = 0;
					token += c;
					return T_UNKNOWN;
				}
				
			case 3:
				switch (c) {
				case 'd':
				case 'D':
					state = 19;
					token += c;
					return getNextToken();
				case 'n':
				case 'N':
					state = 20;
					token += c;
					return getNextToken();
				case 'a':
				case 'A':
				case 'b':
				case 'B':
				case 'c':
				case 'C':
				case 'e':
				case 'E':
				case 'f':
				case 'F':
				case 'g':
				case 'G':
				case 'h':
				case 'H':
				case 'i':
				case 'I':
				case 'j':
				case 'J':
				case 'k':
				case 'K':
				case 'l':
				case 'L':
				case 'm':
				case 'M':
				case 'o':
				case 'O':
				case 'p':
				case 'P':
				case 'q':
				case 'Q':
				case 'r':
				case 'R':
				case 's':
				case 'S':
				case 't':
				case 'T':
				case 'u':
				case 'U':
				case 'v':
				case 'V':
				case 'w':
				case 'W':
				case 'x':
				case 'X':
				case 'y':
				case 'Y':
				case 'z':
				case 'Z':
				case '0':
				case '1':
				case '2':
				case '3':
				case '4':
				case '5':
				case '6':
				case '7':
				case '8':
				case '9':
					state = 12;
					token += c;
					return getNextToken();
				case ',':	
				case ';':
				case '/':
				case '\n':
					index--;					
				case ' ':
				case '\t':
					state = 0;
					return T_IDENTIFIER;
				case ':':
					state = 0;
					return T_LABEL;
				default:
					state = 0;
					token += c;
					return T_UNKNOWN;
				}
				
			case 4:
				switch (c) {
				case 'r':
				case 'R':
					state = 21;
					token += c;
					return getNextToken();
				case 'a':
				case 'A':
				case 'b':
				case 'B':
				case 'c':
				case 'C':
				case 'd':
				case 'D':
				case 'e':
				case 'E':
				case 'f':
				case 'F':
				case 'g':
				case 'G':
				case 'h':
				case 'H':
				case 'i':
				case 'I':
				case 'j':
				case 'J':
				case 'k':
				case 'K':
				case 'l':
				case 'L':
				case 'm':
				case 'M':
				case 'n':
				case 'N':
				case 'o':
				case 'O':
				case 'p':
				case 'P':
				case 'q':
				case 'Q':
				case 's':
				case 'S':
				case 't':
				case 'T':
				case 'u':
				case 'U':
				case 'v':
				case 'V':
				case 'w':
				case 'W':
				case 'x':
				case 'X':
				case 'y':
				case 'Y':
				case 'z':
				case 'Z':
				case '0':
				case '1':
				case '2':
				case '3':
				case '4':
				case '5':
				case '6':
				case '7':
				case '8':
				case '9':
					state = 12;
					token += c;
					return getNextToken();
				case ',':	
				case ';':
				case '/':
				case '\n':
					index--;					
				case ' ':
				case '\t':
					state = 0;
					return T_IDENTIFIER;
				case ':':
					state = 0;
					return T_LABEL;
				default:
					state = 0;
					token += c;
					return T_UNKNOWN;				
				}
				
			case 5:
				switch (c) {
				case 'p':
				case 'P':
					state = 22;
					token += c;
					return getNextToken();
				case 'a':
				case 'A':
				case 'b':
				case 'B':
				case 'c':
				case 'C':
				case 'd':
				case 'D':
				case 'e':
				case 'E':
				case 'f':
				case 'F':
				case 'g':
				case 'G':
				case 'h':
				case 'H':
				case 'i':
				case 'I':
				case 'j':
				case 'J':
				case 'k':
				case 'K':
				case 'l':
				case 'L':
				case 'm':
				case 'M':
				case 'n':
				case 'N':
				case 'o':
				case 'O':
				case 'q':
				case 'Q':
				case 'r':
				case 'R':
				case 's':
				case 'S':
				case 't':
				case 'T':
				case 'u':
				case 'U':
				case 'v':
				case 'V':
				case 'w':
				case 'W':
				case 'x':
				case 'X':
				case 'y':
				case 'Y':
				case 'z':
				case 'Z':
				case '0':
				case '1':
				case '2':
				case '3':
				case '4':
				case '5':
				case '6':
				case '7':
				case '8':
				case '9':
					state = 12;
					token += c;
					return getNextToken();
				case ',':	
				case ';':
				case '/':
				case '\n':
					index--;					
				case ' ':
				case '\t':
					state = 0;
					return T_IDENTIFIER;
				case ':':
					state = 0;
					return T_LABEL;
				default:
					state = 0;
					token += c;
					return T_UNKNOWN;				
				}
				
			case 6:
				switch (c) {
				case 'c':
				case 'C':
				case 'w':
				case 'W':
				case 'b':
				case 'B':
					state = 23;
					token += c;
					return getNextToken();
				case 'a':
				case 'A':
				case 'd':
				case 'D':
				case 'e':
				case 'E':
				case 'f':
				case 'F':
				case 'g':
				case 'G':
				case 'h':
				case 'H':
				case 'i':
				case 'I':
				case 'j':
				case 'J':
				case 'k':
				case 'K':
				case 'l':
				case 'L':
				case 'm':
				case 'M':
				case 'n':
				case 'N':
				case 'o':
				case 'O':
				case 'p':
				case 'P':
				case 'q':
				case 'Q':
				case 'r':
				case 'R':
				case 's':
				case 'S':
				case 't':
				case 'T':
				case 'u':
				case 'U':
				case 'v':
				case 'V':
				case 'x':
				case 'X':
				case 'y':
				case 'Y':
				case 'z':
				case 'Z':
				case '0':
				case '1':
				case '2':
				case '3':
				case '4':
				case '5':
				case '6':
				case '7':
				case '8':
				case '9':
					state = 12;
					token += c;
					return getNextToken();
				case ',':	
				case ';':
				case '/':
				case '\n':
					index--;					
				case ' ':
				case '\t':
					state = 0;
					return T_IDENTIFIER;
				case ':':
					state = 0;
					return T_LABEL;
				default:
					state = 0;
					token += c;
					return T_UNKNOWN;				
				}
				
			case 7:
				switch (c) {
				case 'q':
				case 'Q':
					state = 24;
					token += c;
					return getNextToken();
				case 'a':
				case 'A':
				case 'b':
				case 'B':
				case 'c':
				case 'C':
				case 'd':
				case 'D':
				case 'e':
				case 'E':
				case 'f':
				case 'F':
				case 'g':
				case 'G':
				case 'h':
				case 'H':
				case 'i':
				case 'I':
				case 'j':
				case 'J':
				case 'k':
				case 'K':
				case 'l':
				case 'L':
				case 'm':
				case 'M':
				case 'n':
				case 'N':
				case 'o':
				case 'O':
				case 'p':
				case 'P':
				case 'r':
				case 'R':
				case 's':
				case 'S':
				case 't':
				case 'T':
				case 'u':
				case 'U':
				case 'v':
				case 'V':
				case 'w':
				case 'W':
				case 'x':
				case 'X':
				case 'y':
				case 'Y':
				case 'z':
				case 'Z':
				case '0':
				case '1':
				case '2':
				case '3':
				case '4':
				case '5':
				case '6':
				case '7':
				case '8':
				case '9':
					state = 12;
					token += c;
					return getNextToken();
				case ',':	
				case ';':
				case '/':
				case '\n':
					index--;					
				case ' ':
				case '\t':
					state = 0;
					return T_IDENTIFIER;
				case ':':
					state = 0;
					return T_LABEL;
				default:
					state = 0;
					token += c;
					return T_UNKNOWN;				
				}
				
			case 8:
				switch (c) {
				case 'd':
				case 'D':
					state = 25;
					token += c;
					return getNextToken();
				case 'a':
				case 'A':
				case 'b':
				case 'B':
				case 'c':
				case 'C':
				case 'e':
				case 'E':
				case 'f':
				case 'F':
				case 'g':
				case 'G':
				case 'h':
				case 'H':
				case 'i':
				case 'I':
				case 'j':
				case 'J':
				case 'k':
				case 'K':
				case 'l':
				case 'L':
				case 'm':
				case 'M':
				case 'n':
				case 'N':
				case 'o':
				case 'O':
				case 'p':
				case 'P':
				case 'q':
				case 'Q':
				case 'r':
				case 'R':
				case 's':
				case 'S':
				case 't':
				case 'T':
				case 'u':
				case 'U':
				case 'v':
				case 'V':
				case 'w':
				case 'W':
				case 'x':
				case 'X':
				case 'y':
				case 'Y':
				case 'z':
				case 'Z':
				case '0':
				case '1':
				case '2':
				case '3':
				case '4':
				case '5':
				case '6':
				case '7':
				case '8':
				case '9':
					state = 12;
					token += c;
					return getNextToken();
				case ',':	
				case ';':
				case '/':
				case '\n':
					index--;					
				case ' ':
				case '\t':
					state = 0;
					return T_IDENTIFIER;
				case ':':
					state = 0;
					return T_LABEL;
				default:
					state = 0;
					token += c;
					return T_UNKNOWN;				
				}

			case 9:
				switch (c) {
				case 'r':
				case 'R':
					state = 26;
					token += c;
					return getNextToken();
				case 'a':
				case 'A':
				case 'b':
				case 'B':
				case 'c':
				case 'C':
				case 'd':
				case 'D':
				case 'e':
				case 'E':
				case 'f':
				case 'F':
				case 'g':
				case 'G':
				case 'h':
				case 'H':
				case 'i':
				case 'I':
				case 'j':
				case 'J':
				case 'k':
				case 'K':
				case 'l':
				case 'L':
				case 'm':
				case 'M':
				case 'n':
				case 'N':
				case 'o':
				case 'O':
				case 'p':
				case 'P':
				case 'q':
				case 'Q':
				case 's':
				case 'S':
				case 't':
				case 'T':
				case 'u':
				case 'U':
				case 'v':
				case 'V':
				case 'w':
				case 'W':
				case 'x':
				case 'X':
				case 'y':
				case 'Y':
				case 'z':
				case 'Z':
				case '0':
				case '1':
				case '2':
				case '3':
				case '4':
				case '5':
				case '6':
				case '7':
				case '8':
				case '9':
					state = 12;
					token += c;
					return getNextToken();
				case ',':	
				case ';':
				case '/':
				case '\n':
					index--;					
				case ' ':
				case '\t':
					state = 0;
					return T_IDENTIFIER;
				case ':':
					state = 0;
					return T_LABEL;
				default:
					state = 0;
					token += c;
					return T_UNKNOWN;				
				}
				
			case 10:
				switch (c) {
				case 'u':
				case 'U':
					state = 27;
					token += c;
					return getNextToken();
				case 't':
				case 'T':
					state = 28;
					token += c;
					return getNextToken();
				case 'h':
				case 'H':
					state = 29;
					token += c;
					return getNextToken();
				case 'a':
				case 'A':
				case 'b':
				case 'B':
				case 'c':
				case 'C':
				case 'd':
				case 'D':
				case 'e':
				case 'E':
				case 'f':
				case 'F':
				case 'g':
				case 'G':
				case 'i':
				case 'I':
				case 'j':
				case 'J':
				case 'k':
				case 'K':
				case 'l':
				case 'L':
				case 'm':
				case 'M':
				case 'n':
				case 'N':
				case 'o':
				case 'O':
				case 'p':
				case 'P':
				case 'q':
				case 'Q':
				case 'r':
				case 'R':
				case 's':
				case 'S':
				case 'v':
				case 'V':
				case 'w':
				case 'W':
				case 'x':
				case 'X':
				case 'y':
				case 'Y':
				case 'z':
				case 'Z':
				case '0':
				case '1':
				case '2':
				case '3':
				case '4':
				case '5':
				case '6':
				case '7':
				case '8':
				case '9':
					state = 12;
					token += c;
					return getNextToken();
				case ',':	
				case ';':
				case '/':
				case '\n':
					index--;					
				case ' ':
				case '\t':
					state = 0;
					return T_IDENTIFIER;
				case ':':
					state = 0;
					return T_LABEL;
				default:
					state = 0;
					token += c;
					return T_UNKNOWN;
				}
				
			case 11:
				switch (c) {
				case 'n':
				case 'N':
					state = 30;
					token += c;
					return getNextToken();
				case 'a':
				case 'A':
				case 'b':
				case 'B':
				case 'c':
				case 'C':
				case 'd':
				case 'D':
				case 'e':
				case 'E':
				case 'f':
				case 'F':
				case 'g':
				case 'G':
				case 'h':
				case 'H':
				case 'i':
				case 'I':
				case 'j':
				case 'J':
				case 'k':
				case 'K':
				case 'l':
				case 'L':
				case 'm':
				case 'M':
				case 'o':
				case 'O':
				case 'p':
				case 'P':
				case 'q':
				case 'Q':
				case 'r':
				case 'R':
				case 's':
				case 'S':
				case 't':
				case 'T':
				case 'u':
				case 'U':
				case 'v':
				case 'V':
				case 'w':
				case 'W':
				case 'x':
				case 'X':
				case 'y':
				case 'Y':
				case 'z':
				case 'Z':
				case '0':
				case '1':
				case '2':
				case '3':
				case '4':
				case '5':
				case '6':
				case '7':
				case '8':
				case '9':
					state = 12;
					token += c;
					return getNextToken();
				case ',':	
				case ';':
				case '/':
				case '\n':
					index--;					
				case ' ':
				case '\t':
					state = 0;
					return T_IDENTIFIER;
				case ':':
					state = 0;
					return T_LABEL;
				default:
					state = 0;
					token += c;
					return T_UNKNOWN;				
				}
				
			case 12:
				switch (c) {
				case 'a':
				case 'A':
				case 'b':
				case 'B':
				case 'c':
				case 'C':
				case 'd':
				case 'D':
				case 'e':
				case 'E':
				case 'f':
				case 'F':
				case 'g':
				case 'G':
				case 'h':
				case 'H':
				case 'i':
				case 'I':
				case 'j':
				case 'J':
				case 'k':
				case 'K':
				case 'l':
				case 'L':
				case 'm':
				case 'M':
				case 'n':
				case 'N':
				case 'o':
				case 'O':
				case 'p':
				case 'P':
				case 'q':
				case 'Q':
				case 'r':
				case 'R':
				case 's':
				case 'S':
				case 't':
				case 'T':
				case 'u':
				case 'U':
				case 'v':
				case 'V':
				case 'w':
				case 'W':
				case 'x':
				case 'X':
				case 'y':
				case 'Y':
				case 'z':
				case 'Z':
				case '0':
				case '1':
				case '2':
				case '3':
				case '4':
				case '5':
				case '6':
				case '7':
				case '8':
				case '9':
					state = 12;
					token += c;
					return getNextToken();
				case ',':	
				case ';':
				case '/':
				case '\n':
					index--;					
				case ' ':
				case '\t':
					state = 0;
					return T_IDENTIFIER;
				case ':':
					state = 0;
					return T_LABEL;
				default:
					state = 0;
					token += c;
					return T_UNKNOWN;
				}
				
			case 13:
				switch (c) {
				case '0':
				case '1':
					state = 31;
					token += c;
					return getNextToken();
				case '2':
				case '3':
				case '4':
				case '5':
				case '6':
					state = 32;
					token += c;
					return getNextToken();
				case 'x':
				case 'X':
					state = 33;
					token += c;
					return getNextToken();
				case 'b':
				case 'B':
					state = 0;
					token += c;
					return T_NUMBER;
				case ',':	
				case ';':
				case '/':
				case '\n':
					index--;
				case '\t':
				case ' ':
					state = 0;
					return T_NUMBER;
				default:
					state = 0;
					token += c;
					return T_UNKNOWN;
				}
				
			case 14:
				switch (c) {
				case '0':
				case '1':
					state = 34;
					token += c;
					return getNextToken();
				case '2':
				case '3':
				case '4':
				case '5':
				case '6':
				case '7':
				case '8':
				case '9':
					state = 15;
					token += c;
					return getNextToken();
				case 'b':
				case 'B':
					state = 0;
					token += c;
					return T_NUMBER;
				case ',':	
				case ';':
				case '/':
				case '\n':
					index--;
				case '\t':
				case ' ':
					state = 0;
					return T_NUMBER;
				default:
					state = 0;
					token += c;
					return T_UNKNOWN;
				}
				
			case 15:
				switch (c) {
				case '0':
				case '1':
				case '2':
				case '3':
				case '4':
				case '5':
				case '6':
				case '7':
				case '8':
				case '9':
					state = 15;
					token += c;
					return getNextToken();
				case ',':	
				case ';':
				case '/':
				case '\n':
					index--;
				case '\t':
				case ' ':
					state = 0;
					return T_NUMBER;
				default:
					state = 0;
					token += c;
					return T_UNKNOWN;
				}
				
			case 16:
				switch (c) {
				case '0':
				case '1':
				case '2':
				case '3':
				case '4':
				case '5':
				case '6':
				case '7':
				case '8':
				case '9':
				case 'a':
				case 'A':
				case 'b':
				case 'B':
				case 'c':
				case 'C':
				case 'd':
				case 'D':
				case 'e':
				case 'E':
				case 'f':
				case 'F':
					state = 33;
					token += c;
					return getNextToken();
				default:
					state = 0;
					token += c;
					return T_UNKNOWN;
				}
				
			case 17:
				switch (c) {
				case '\'':
					state = 0;
					token += c;
					return T_STRING;
				case '\n':
					state = 0;
					token += c;
					return T_UNKNOWN;
				default:
					state = 17;
					token += c;
					return getNextToken();
				}
				
			case 18:
				switch (c) {
				case '"':
					state = 0;
					token += c;
					return T_STRING;
				case '\n':
					state = 0;
					token += c;
					return T_UNKNOWN;
				default:
					state = 18;
					token += c;
					return getNextToken();
				}
				
			case 19:
				switch (c) {
				case 'd':
				case 'D':
					state = 23;
					token += c;
					return getNextToken();
				case 'a':
				case 'A':
				case 'b':
				case 'B':
				case 'c':
				case 'C':
				case 'e':
				case 'E':
				case 'f':
				case 'F':
				case 'g':
				case 'G':
				case 'h':
				case 'H':
				case 'i':
				case 'I':
				case 'j':
				case 'J':
				case 'k':
				case 'K':
				case 'l':
				case 'L':
				case 'm':
				case 'M':
				case 'n':
				case 'N':
				case 'o':
				case 'O':
				case 'p':
				case 'P':
				case 'q':
				case 'Q':
				case 'r':
				case 'R':
				case 's':
				case 'S':
				case 't':
				case 'T':
				case 'u':
				case 'U':
				case 'v':
				case 'V':
				case 'w':
				case 'W':
				case 'x':
				case 'X':
				case 'y':
				case 'Y':
				case 'z':
				case 'Z':
				case '0':
				case '1':
				case '2':
				case '3':
				case '4':
				case '5':
				case '6':
				case '7':
				case '8':
				case '9':
					state = 12;
					token += c;
					return getNextToken();
				case ',':	
				case ';':
				case '/':
				case '\n':
					index--;					
				case ' ':
				case '\t':
					state = 0;
					return T_IDENTIFIER;
				case ':':
					state = 0;
					return T_LABEL;
				default:
					state = 0;
					token += c;
					return T_UNKNOWN;
				
				}
				
			case 20:
				switch (c) {
				case 'd':
				case 'D':
					state = 23;
					token += c;
					return getNextToken();
				case 'a':
				case 'A':
				case 'b':
				case 'B':
				case 'c':
				case 'C':
				case 'e':
				case 'E':
				case 'f':
				case 'F':
				case 'g':
				case 'G':
				case 'h':
				case 'H':
				case 'i':
				case 'I':
				case 'j':
				case 'J':
				case 'k':
				case 'K':
				case 'l':
				case 'L':
				case 'm':
				case 'M':
				case 'n':
				case 'N':
				case 'o':
				case 'O':
				case 'p':
				case 'P':
				case 'q':
				case 'Q':
				case 'r':
				case 'R':
				case 's':
				case 'S':
				case 't':
				case 'T':
				case 'u':
				case 'U':
				case 'v':
				case 'V':
				case 'w':
				case 'W':
				case 'x':
				case 'X':
				case 'y':
				case 'Y':
				case 'z':
				case 'Z':
				case '0':
				case '1':
				case '2':
				case '3':
				case '4':
				case '5':
				case '6':
				case '7':
				case '8':
				case '9':
					state = 12;
					token += c;
					return getNextToken();
				case '\n':
					index--;					
				case ',':	
				case ';':
				case '/':
				case ' ':
				case '\t':
					state = 0;
					return T_IDENTIFIER;
				case ':':
					state = 0;
					return T_LABEL;
				default:
					state = 0;
					token += c;
					return T_UNKNOWN;

				}
				
			case 21:
				switch (c) {
				case 'c':
				case 'C':
				case 'z':
				case 'Z':
					state = 23;
					token += c;
					return getNextToken();
				case 'a':
				case 'A':
				case 'b':
				case 'B':
				case 'd':
				case 'D':
				case 'e':
				case 'E':
				case 'f':
				case 'F':
				case 'g':
				case 'G':
				case 'h':
				case 'H':
				case 'i':
				case 'I':
				case 'j':
				case 'J':
				case 'k':
				case 'K':
				case 'l':
				case 'L':
				case 'm':
				case 'M':
				case 'n':
				case 'N':
				case 'o':
				case 'O':
				case 'p':
				case 'P':
				case 'q':
				case 'Q':
				case 'r':
				case 'R':
				case 's':
				case 'S':
				case 't':
				case 'T':
				case 'u':
				case 'U':
				case 'v':
				case 'V':
				case 'w':
				case 'W':
				case 'x':
				case 'X':
				case 'y':
				case 'Y':
				case '0':
				case '1':
				case '2':
				case '3':
				case '4':
				case '5':
				case '6':
				case '7':
				case '8':
				case '9':
					state = 12;
					token += c;
					return getNextToken();
				case ',':	
				case ';':
				case '/':
				case '\n':
					index--;					
				case ' ':
				case '\t':
					state = 0;
					return T_IDENTIFIER;
				case ':':
					state = 0;
					return T_LABEL;
				default:
					state = 0;
					token += c;
					return T_UNKNOWN;
				}
				
			case 22:
				switch (c) {
				case 'i':
				case 'I':
					state = 23;
					token += c;
					return getNextToken();
				case 'a':
				case 'A':
				case 'b':
				case 'B':
				case 'c':
				case 'C':
				case 'd':
				case 'D':
				case 'e':
				case 'E':
				case 'f':
				case 'F':
				case 'g':
				case 'G':
				case 'h':
				case 'H':
				case 'j':
				case 'J':
				case 'k':
				case 'K':
				case 'l':
				case 'L':
				case 'm':
				case 'M':
				case 'n':
				case 'N':
				case 'o':
				case 'O':
				case 'p':
				case 'P':
				case 'q':
				case 'Q':
				case 'r':
				case 'R':
				case 's':
				case 'S':
				case 't':
				case 'T':
				case 'u':
				case 'U':
				case 'v':
				case 'V':
				case 'w':
				case 'W':
				case 'x':
				case 'X':
				case 'y':
				case 'Y':
				case 'z':
				case 'Z':
				case '0':
				case '1':
				case '2':
				case '3':
				case '4':
				case '5':
				case '6':
				case '7':
				case '8':
				case '9':
					state = 12;
					token += c;
					return getNextToken();
				case ',':	
				case ';':
				case '/':
				case '\n':
					index--;					
				case ' ':
				case '\t':
					state = 0;
					return T_IDENTIFIER;
				case ':':
					state = 0;
					return T_LABEL;
				default:
					state = 0;
					token += c;
					return T_UNKNOWN;
				}
				
			case 23:
				switch (c) {
				case 'a':
				case 'A':
				case 'b':
				case 'B':
				case 'c':
				case 'C':
				case 'd':
				case 'D':
				case 'e':
				case 'E':
				case 'f':
				case 'F':
				case 'g':
				case 'G':
				case 'h':
				case 'H':
				case 'i':
				case 'I':
				case 'j':
				case 'J':
				case 'k':
				case 'K':
				case 'l':
				case 'L':
				case 'm':
				case 'M':
				case 'n':
				case 'N':
				case 'o':
				case 'O':
				case 'p':
				case 'P':
				case 'q':
				case 'Q':
				case 'r':
				case 'R':
				case 's':
				case 'S':
				case 't':
				case 'T':
				case 'u':
				case 'U':
				case 'v':
				case 'V':
				case 'w':
				case 'W':
				case 'x':
				case 'X':
				case 'y':
				case 'Y':
				case 'z':
				case 'Z':
				case '0':
				case '1':
				case '2':
				case '3':
				case '4':
				case '5':
				case '6':
				case '7':
				case '8':
				case '9':
					state = 12;
					token += c;
					return getNextToken();
				case ',':	
				case ';':
				case '/':
				case '\n':
					index--;					
				case ' ':
				case '\t':
					state = 0;
					return T_KEYWORD;
				case ':':
					state = 0;
					return T_LABEL;
				default:
					state = 0;
					token += c;
					return T_UNKNOWN;

				}
				
			case 24:
				switch (c) {
				case 'u':
				case 'U':
					state = 23;
					token += c;
					return getNextToken();
				case 'a':
				case 'A':
				case 'b':
				case 'B':
				case 'c':
				case 'C':
				case 'd':
				case 'D':
				case 'e':
				case 'E':
				case 'f':
				case 'F':
				case 'g':
				case 'G':
				case 'h':
				case 'H':
				case 'i':
				case 'I':
				case 'j':
				case 'J':
				case 'k':
				case 'K':
				case 'l':
				case 'L':
				case 'm':
				case 'M':
				case 'n':
				case 'N':
				case 'o':
				case 'O':
				case 'p':
				case 'P':
				case 'q':
				case 'Q':
				case 'r':
				case 'R':
				case 's':
				case 'S':
				case 't':
				case 'T':
				case 'v':
				case 'V':
				case 'w':
				case 'W':
				case 'x':
				case 'X':
				case 'y':
				case 'Y':
				case 'z':
				case 'Z':
				case '0':
				case '1':
				case '2':
				case '3':
				case '4':
				case '5':
				case '6':
				case '7':
				case '8':
				case '9':
					state = 12;
					token += c;
					return getNextToken();
				case ',':	
				case ';':
				case '/':
				case '\n':
					index--;					
				case ' ':
				case '\t':
					state = 0;
					return T_IDENTIFIER;
				case ':':
					state = 0;
					return T_LABEL;
				default:
					state = 0;
					token += c;
					return T_UNKNOWN;

				}
				
			case 25:
				switch (c) {
				case 'a':
				case 'A':
				case 'i':
				case 'I':
					state = 23;
					token += c;
					return getNextToken();
				case 'b':
				case 'B':
				case 'c':
				case 'C':
				case 'd':
				case 'D':
				case 'e':
				case 'E':
				case 'f':
				case 'F':
				case 'g':
				case 'G':
				case 'h':
				case 'H':
				case 'j':
				case 'J':
				case 'k':
				case 'K':
				case 'l':
				case 'L':
				case 'm':
				case 'M':
				case 'n':
				case 'N':
				case 'o':
				case 'O':
				case 'p':
				case 'P':
				case 'q':
				case 'Q':
				case 'r':
				case 'R':
				case 's':
				case 'S':
				case 't':
				case 'T':
				case 'u':
				case 'U':
				case 'v':
				case 'V':
				case 'w':
				case 'W':
				case 'x':
				case 'X':
				case 'y':
				case 'Y':
				case 'z':
				case 'Z':
				case '0':
				case '1':
				case '2':
				case '3':
				case '4':
				case '5':
				case '6':
				case '7':
				case '8':
				case '9':
					state = 12;
					token += c;
					return getNextToken();
				case ',':	
				case ';':
				case '/':
				case '\n':
					index--;					
				case ' ':
				case '\t':
					state = 0;
					return T_IDENTIFIER;
				case ':':
					state = 0;
					return T_LABEL;
				default:
					state = 0;
					token += c;
					return T_UNKNOWN;
				}
				
			case 26:
				switch (c) {
				case 'g':
				case 'G':
					state = 23;
					token += c;
					return getNextToken();
				case 'a':
				case 'A':
				case 'b':
				case 'B':
				case 'c':
				case 'C':
				case 'd':
				case 'D':
				case 'e':
				case 'E':
				case 'f':
				case 'F':
				case 'h':
				case 'H':
				case 'i':
				case 'I':
				case 'j':
				case 'J':
				case 'k':
				case 'K':
				case 'l':
				case 'L':
				case 'm':
				case 'M':
				case 'n':
				case 'N':
				case 'o':
				case 'O':
				case 'p':
				case 'P':
				case 'q':
				case 'Q':
				case 'r':
				case 'R':
				case 's':
				case 'S':
				case 't':
				case 'T':
				case 'u':
				case 'U':
				case 'v':
				case 'V':
				case 'w':
				case 'W':
				case 'x':
				case 'X':
				case 'y':
				case 'Y':
				case 'z':
				case 'Z':
				case '0':
				case '1':
				case '2':
				case '3':
				case '4':
				case '5':
				case '6':
				case '7':
				case '8':
				case '9':
					state = 12;
					token += c;
					return getNextToken();
				case ',':	
				case ';':
				case '/':
				case '\n':
					index--;					
				case ' ':
				case '\t':
					state = 0;
					return T_KEYWORD;
				case ':':
					state = 0;
					return T_LABEL;
				default:
					state = 0;
					token += c;
					return T_UNKNOWN;

				}
				
			case 27:
				switch (c) {
				case 'b':
				case 'B':
					state = 23;
					token += c;
					return getNextToken();
				case 'a':
				case 'A':
				case 'c':
				case 'C':
				case 'd':
				case 'D':
				case 'e':
				case 'E':
				case 'f':
				case 'F':
				case 'g':
				case 'G':
				case 'h':
				case 'H':
				case 'i':
				case 'I':
				case 'j':
				case 'J':
				case 'k':
				case 'K':
				case 'l':
				case 'L':
				case 'm':
				case 'M':
				case 'n':
				case 'N':
				case 'o':
				case 'O':
				case 'p':
				case 'P':
				case 'q':
				case 'Q':
				case 'r':
				case 'R':
				case 's':
				case 'S':
				case 't':
				case 'T':
				case 'u':
				case 'U':
				case 'v':
				case 'V':
				case 'w':
				case 'W':
				case 'x':
				case 'X':
				case 'y':
				case 'Y':
				case 'z':
				case 'Z':
				case '0':
				case '1':
				case '2':
				case '3':
				case '4':
				case '5':
				case '6':
				case '7':
				case '8':
				case '9':
					state = 12;
					token += c;
					return getNextToken();
				case ',':	
				case ';':
				case '/':
				case '\n':
					index--;					
				case ' ':
				case '\t':
					state = 0;
					return T_IDENTIFIER;
				case ':':
					state = 0;
					return T_LABEL;
				default:
					state = 0;
					token += c;
					return T_UNKNOWN;
				}
				
			case 28:
				switch (c) {
				case 'i':
				case 'I':
				case 'o':
				case 'O':
					state = 23;
					token += c;
					return getNextToken();
				case 'a':
				case 'A':
				case 'b':
				case 'B':
				case 'c':
				case 'C':
				case 'd':
				case 'D':
				case 'e':
				case 'E':
				case 'f':
				case 'F':
				case 'g':
				case 'G':
				case 'h':
				case 'H':
				case 'j':
				case 'J':
				case 'k':
				case 'K':
				case 'l':
				case 'L':
				case 'm':
				case 'M':
				case 'n':
				case 'N':
				case 'p':
				case 'P':
				case 'q':
				case 'Q':
				case 'r':
				case 'R':
				case 's':
				case 'S':
				case 't':
				case 'T':
				case 'u':
				case 'U':
				case 'v':
				case 'V':
				case 'w':
				case 'W':
				case 'x':
				case 'X':
				case 'y':
				case 'Y':
				case 'z':
				case 'Z':
				case '0':
				case '1':
				case '2':
				case '3':
				case '4':
				case '5':
				case '6':
				case '7':
				case '8':
				case '9':
					state = 12;
					token += c;
					return getNextToken();
				case ',':	
				case ';':
				case '/':
				case '\n':
					index--;					
				case ' ':
				case '\t':
					state = 0;
					return T_IDENTIFIER;
				case ':':
					state = 0;
					return T_LABEL;
				default:
					state = 0;
					token += c;
					return T_UNKNOWN;
				}
				
			case 29:
				switch (c) {
				case 'l':
				case 'L':
				case 'r':
				case 'R':
					state = 23;
					token += c;
					return getNextToken();
				case 'a':
				case 'A':
				case 'b':
				case 'B':
				case 'c':
				case 'C':
				case 'd':
				case 'D':
				case 'e':
				case 'E':
				case 'f':
				case 'F':
				case 'g':
				case 'G':
				case 'h':
				case 'H':
				case 'i':
				case 'I':
				case 'j':
				case 'J':
				case 'k':
				case 'K':
				case 'm':
				case 'M':
				case 'n':
				case 'N':
				case 'o':
				case 'O':
				case 'p':
				case 'P':
				case 'q':
				case 'Q':
				case 's':
				case 'S':
				case 't':
				case 'T':
				case 'u':
				case 'U':
				case 'v':
				case 'V':
				case 'w':
				case 'W':
				case 'x':
				case 'X':
				case 'y':
				case 'Y':
				case 'z':
				case 'Z':
				case '0':
				case '1':
				case '2':
				case '3':
				case '4':
				case '5':
				case '6':
				case '7':
				case '8':
				case '9':
					state = 12;
					token += c;
					return getNextToken();
				case ',':	
				case ';':
				case '/':
				case '\n':
					index--;					
				case ' ':
				case '\t':
					state = 0;
					return T_IDENTIFIER;
				case ':':
					state = 0;
					return T_LABEL;
				default:
					state = 0;
					token += c;
					return T_UNKNOWN;
				}
				
			case 30:
				switch (c) {
				case 'c':
				case 'C':
					state = 35;
					token += c;
					return getNextToken();
				case 'a':
				case 'A':
				case 'b':
				case 'B':
				case 'd':
				case 'D':
				case 'e':
				case 'E':
				case 'f':
				case 'F':
				case 'g':
				case 'G':
				case 'h':
				case 'H':
				case 'i':
				case 'I':
				case 'j':
				case 'J':
				case 'k':
				case 'K':
				case 'l':
				case 'L':
				case 'm':
				case 'M':
				case 'n':
				case 'N':
				case 'o':
				case 'O':
				case 'p':
				case 'P':
				case 'q':
				case 'Q':
				case 'r':
				case 'R':
				case 's':
				case 'S':
				case 't':
				case 'T':
				case 'u':
				case 'U':
				case 'v':
				case 'V':
				case 'w':
				case 'W':
				case 'x':
				case 'X':
				case 'y':
				case 'Y':
				case 'z':
				case 'Z':
				case '0':
				case '1':
				case '2':
				case '3':
				case '4':
				case '5':
				case '6':
				case '7':
				case '8':
				case '9':
					state = 12;
					token += c;
					return getNextToken();
				case ',':	
				case ';':
				case '/':
				case '\n':
					index--;					
				case ' ':
				case '\t':
					state = 0;
					return T_IDENTIFIER;
				case ':':
					state = 0;
					return T_LABEL;
				default:
					state = 0;
					token += c;
					return T_UNKNOWN;
				}
				
			case 31:
				switch (c) {
				case '0':
				case '1':
					state = 31;
					token += c;
					return getNextToken();
				case '2':
				case '3':
				case '4':
				case '5':
				case '6':
					state = 32;
					token += c;
					return getNextToken();
				case 'b':
				case 'B':
					state = 0;
					token += c;
					return T_NUMBER;
				case ',':	
				case ';':
				case '/':
				case '\n':
					index--;
				case '\t':
				case ' ':
					state = 0;
					return T_NUMBER;
				default:
					state = 0;
					token += c;
					return T_UNKNOWN;
				}
				
			case 32:
				switch (c) {
				case '0':
				case '1':
				case '2':
				case '3':
				case '4':
				case '5':
				case '6':
					state = 32;
					token += c;
					return getNextToken();
				case ',':	
				case ';':
				case '/':
				case '\n':
					index--;
				case '\t':
				case ' ':
					state = 0;
					return T_NUMBER;
				default:
					state = 0;
					token += c;
					return T_UNKNOWN;
				}
			
			case 33:
				switch (c) {
				case '0':
				case '1':
				case '2':
				case '3':
				case '4':
				case '5':
				case '6':
				case '7':
				case '8':
				case '9':
				case 'a':
				case 'A':
				case 'b':
				case 'B':
				case 'c':
				case 'C':
				case 'd':
				case 'D':
				case 'e':
				case 'E':
				case 'f':
				case 'F':
					state = 33;
					token += c;
					return getNextToken();
				case ',':	
				case ';':
				case '/':
				case '\n':
					index--;
				case '\t':
				case ' ':
					state = 0;
					return T_NUMBER;
				default:
					state = 0;
					token += c;
					return T_UNKNOWN;
				}
				
			case 34:
				switch (c) {
				case '0':
				case '1':
					state = 34;
					token += c;
					return getNextToken();
				case '2':
				case '3':
				case '4':
				case '5':
				case '6':
				case '7':
				case '8':
				case '9':
					state = 15;
					token += c;
					return getNextToken();
				case 'b':
				case 'B':
					state = 0;
					token += c;
					return T_NUMBER;
				case ',':	
				case ';':
				case '/':
				case '\n':
					index--;
				case '\t':
				case ' ':
					state = 0;
					return T_NUMBER;
				default:
					state = 0;
					token += c;
					return T_UNKNOWN;
				}
				
			case 35:
				switch (c) {
				case 'a':
				case 'A':
					state = 36;
					token += c;
					return getNextToken();
				case 'b':
				case 'B':
				case 'c':
				case 'C':
				case 'd':
				case 'D':
				case 'e':
				case 'E':
				case 'f':
				case 'F':
				case 'g':
				case 'G':
				case 'h':
				case 'H':
				case 'i':
				case 'I':
				case 'j':
				case 'J':
				case 'k':
				case 'K':
				case 'l':
				case 'L':
				case 'm':
				case 'M':
				case 'n':
				case 'N':
				case 'o':
				case 'O':
				case 'p':
				case 'P':
				case 'q':
				case 'Q':
				case 'r':
				case 'R':
				case 's':
				case 'S':
				case 't':
				case 'T':
				case 'u':
				case 'U':
				case 'v':
				case 'V':
				case 'w':
				case 'W':
				case 'x':
				case 'X':
				case 'y':
				case 'Y':
				case 'z':
				case 'Z':
				case '0':
				case '1':
				case '2':
				case '3':
				case '4':
				case '5':
				case '6':
				case '7':
				case '8':
				case '9':
					state = 12;
					token += c;
					return getNextToken();
				case ',':	
				case ';':
				case '/':
				case '\n':
					index--;					
				case ' ':
				case '\t':
					state = 0;
					return T_IDENTIFIER;
				case ':':
					state = 0;
					return T_LABEL;
				default:
					state = 0;
					token += c;
					return T_UNKNOWN;
				}
				
			case 36:
				switch (c) {
				case 'r':
				case 'R':
					state = 23;
					token += c;
					return getNextToken();
				case 'a':
				case 'A':
				case 'b':
				case 'B':
				case 'c':
				case 'C':
				case 'd':
				case 'D':
				case 'e':
				case 'E':
				case 'f':
				case 'F':
				case 'g':
				case 'G':
				case 'h':
				case 'H':
				case 'i':
				case 'I':
				case 'j':
				case 'J':
				case 'k':
				case 'K':
				case 'l':
				case 'L':
				case 'm':
				case 'M':
				case 'n':
				case 'N':
				case 'o':
				case 'O':
				case 'p':
				case 'P':
				case 'q':
				case 'Q':
				case 's':
				case 'S':
				case 't':
				case 'T':
				case 'u':
				case 'U':
				case 'v':
				case 'V':
				case 'w':
				case 'W':
				case 'x':
				case 'X':
				case 'y':
				case 'Y':
				case 'z':
				case 'Z':
				case '0':
				case '1':
				case '2':
				case '3':
				case '4':
				case '5':
				case '6':
				case '7':
				case '8':
				case '9':
					state = 12;
					token += c;
					return getNextToken();
				case ',':	
				case ';':
				case '/':
				case '\n':
					index--;					
				case ' ':
				case '\t':
					state = 0;
					return T_IDENTIFIER;
				case ':':
					state = 0;
					return T_LABEL;
				default:
					state = 0;
					token += c;
					return T_UNKNOWN;
				}
			}
			
			return T_UNKNOWN;
		}
	}
}
