import java.io.*;
import java.util.*;

public class AssemblerOld {

	public static StringBuffer assemble(StringBuffer in) {
		StringBuffer code = new StringBuffer();
		// Java 1.5
		//Hashtable<String,Short> labels = new Hashtable<String,Short>();
		Hashtable labels = new Hashtable();
		// Java 1.5
		//Vector<Statement> statements = new Vector<Statement>();
		Vector statements = new Vector();
		Scanner sc = new AssemblerOld.Scanner(in);
		int token;
		short address = 0;
		String laststatement = null;
		while ((token = sc.getNextToken()) > 0) {
			switch (token) {
			case Scanner.TOKEN_ARGUMENT:
				if (laststatement != null) {
					statements.add(new Statement(laststatement, sc.getTokenString()));
					address++;
					laststatement = null;
				}
				break;
			case Scanner.TOKEN_STATEMENT:
				if (laststatement != null) {
					statements.add(new Statement(laststatement, "0"));
					address++;
				}
				laststatement = sc.getTokenString();
				break;
			case Scanner.TOKEN_LABEL:
				if (laststatement != null) {
					statements.add(new Statement(laststatement, "0"));
					address++;
					laststatement = null;
				}
				labels.put(sc.getTokenString(), new Short(address));
				break;
				
			}
		}
		
		
		for(int i = 0; i < statements.size(); i++) {
			String opcode = ((Statement) statements.get(i)).statement;
			String argument = ((Statement) statements.get(i)).argument;
			short machinecode;
			
			// Argument (Adresse) umwandeln:
			if (labels.get(argument) != null) {
				machinecode = ((Short) labels.get(argument)).shortValue();
			} else {
				if (argument.startsWith("0X")) {
					machinecode = (short) Integer.parseInt(argument.substring(2), 16);
				} else if (argument.endsWith("B")) {
					machinecode = (short) Integer.parseInt(argument.substring(0, argument.length()-1), 2);
				} else {
					machinecode = (short) Integer.parseInt(argument);
				}
			}
			
			// Zu groe Adressen einfach kleiner machen
			// auer bei Daten
			if (!opcode.equals("DW")) {
				machinecode = (short) (machinecode & 0x0FFF);
			}
			
			if (opcode.equals("STO")) {
				machinecode += 0x0000;
			} else if (opcode.equals("LDA")) {
				machinecode += 0x1000;
			} else if (opcode.equals("BRZ")) {
				machinecode += 0x2000;
			} else if (opcode.equals("ADD")) {
				machinecode += 0x3000;
			} else if (opcode.equals("SUB")) {
				machinecode += 0x4000;
			} else if (opcode.equals("OR")) {
				machinecode += 0x5000;
			} else if (opcode.equals("AND")) {
				machinecode += 0x6000;
			} else if (opcode.equals("XOR")) {
				machinecode += 0x7000;
			} else if (opcode.equals("LDAR")) {
				machinecode += 0x8000;
			} else if (opcode.equals("INCAR")) {
				machinecode += 0x9000;
			} else if (opcode.equals("LDI")) {
				machinecode += 0xa000;
			} else if (opcode.equals("STI")) {
				machinecode += 0xb000;
			} else if (opcode.equals("CPI")) {
				machinecode += 0xc000;
			} else if (opcode.equals("SHL")) {
				machinecode += 0xd000;
			} else if (opcode.equals("SHR")) {
				machinecode += 0xe000;
			} else if (opcode.equals("BRC")) {
				machinecode += 0xf000;
			}

			code.append((char) ((machinecode & 0xFF00) >> 8));
			code.append((char) (machinecode & 0x00FF));

		}
		
		return code;
	}
	
	public static StringBuffer assemble(String filename) 
	throws IOException {
		StringBuffer in = new StringBuffer();
		BufferedReader r = new BufferedReader(new FileReader(filename));
		String line;
		
		while((line = r.readLine()) != null) {
			in.append(line);
			in.append("\n");
		}
		r.close();
		
		return assemble(in);		
	}
	
	public static void main(String[] args)
	throws Exception {
		StringBuffer in = new StringBuffer();
		BufferedReader r;
		String line;
		
		if (args.length == 0) {
			// read from stdin
			// output to stdout
			r = new BufferedReader(new InputStreamReader(System.in));
			while((line = r.readLine()) != null) {
				in.append(line);
				in.append("\n");
			}
			System.out.print(assemble(in).toString());
		} else if (args.length == 2) {
			// read from file
			// output to file
			r = new BufferedReader(new FileReader(args[0]));
			while((line = r.readLine()) != null) {
				in.append(line);
				in.append("\n");
			}
			r.close();
			FileWriter out = new FileWriter(args[1]);
			out.write(assemble(in).toString());
			out.close();
		} else {
			System.err.println("Syntax: Assembler [inputfile] [outputfile]");
			System.exit(1);
		}		
	}
	
	private static class Statement {
		String statement;
		String argument;
		
		Statement(String s, String a) {
			statement = s;
			argument = a;
		}
	}
	
	private static class Scanner {
		StringBuffer in = null;
		int index = 0;
		int line = 1;
		int column = 0;
		String token = "";
		int state = 0;
		
		
		static final int TOKEN_ERROR 		= -2;
		static final int TOKEN_END 			= -1;
		static final int TOKEN_STATEMENT 	= 1;
		static final int TOKEN_LABEL 		= 2;
		static final int TOKEN_ARGUMENT 		= 3;
		static final int TOKEN_COMMENT 		= 4;
		static final int TOKEN_WHITESPACE 	= 5;
		
		
		
		Scanner(StringBuffer i) {
			in = i;
		}
		
		String getTokenDescription(int t) {
			switch (t) {
			case TOKEN_ERROR:
				return "TOKEN_ERROR";
			case TOKEN_END:
				return "TOKEN_END";
			case TOKEN_STATEMENT:
				return "TOKEN_STATEMENT";
			case TOKEN_LABEL:
				return "TOKEN_LABEL";
			case TOKEN_ARGUMENT:
				return "TOKEN_ARGUMENT";
			case TOKEN_COMMENT:
				return "TOKEN_COMMENT";
			case TOKEN_WHITESPACE:
				return "TOKEN_WHITESPACE";
			}
			
			return "unknown token";
		}
		
		String getTokenString() {
			return token;
		}
		
        /*
         * Here are the scanner regular expressions used
         * to construct the state machine...
         *
         ADD|AND|BRC|BRZ|CPI|DW|INCAR|LDA|LDAR|LDI|OR|SHL|SHR|STI|STO|SUB|XOR
            --> return TOKEN_STATEMENT
         [A-Z][A-Z0-9]*:
            --> return TOKEN_LABEL
         [0-9]+|0X[0-9A-F]{1,3}|[01]+B|[A-Z][A-Z0-9]*
            --> return TOKEN_ARGUMENT
         (\;|\#|\/\/)[^\n]*
            --> return TOKEN_COMMENT
         [\ \t\n]
            --> return TOKEN_WHITESPACE
          */
        
		int getNextToken() {
			if (index >= in.length()) return TOKEN_END;
			
			
			char c = in.charAt(index++);
			column++;
			
			c = Character.toUpperCase(c);

			switch (state) {
			case 0:
				token = "";
				switch (c) {
				case '\n':
					column = 0;
					line++;
				case ' ':
				case '\t':
					token = " ";
					return TOKEN_WHITESPACE;
				case 'A':
					state = 1;
					token += c;
					return getNextToken();
				case 'B':
					state = 2;
					token += c;
					return getNextToken();
				case 'C':
					state = 3;
					token += c;
					return getNextToken();
				case 'D':
					state = 4;
					token += c;
					return getNextToken();
				case 'E':
				case 'F':
				case 'G':
				case 'H':
				case 'J':
				case 'K':
				case 'M':
				case 'N':
				case 'P':
				case 'Q':
				case 'R':
				case 'T':
				case 'U':
				case 'V':
				case 'W':
				case 'Y':
				case 'Z':
					state = 5;
					token += c;
					return getNextToken();
				case 'I':
					state = 6;
					token += c;
					return getNextToken();
				case 'L':
					state = 7;
					token += c;
					return getNextToken();
				case 'O':
					state = 8;
					token += c;
					return getNextToken();
				case 'S':
					state = 9;
					token += c;
					return getNextToken();
				case 'X':
					state = 10;
					token += c;
					return getNextToken();
				case '0':
					state = 11;
					token += c;
					return getNextToken();
				case '1':
					state = 12;
					token += c;
					return getNextToken();
				case '2':
				case '3':
				case '4':
				case '5':
				case '6':
				case '7':
				case '8':
				case '9':
					state = 13;
					token += c;
					return getNextToken();
				case ';':
				case '#':
					state = 14;
					return getNextToken();
				case '/':
					state = 15;
					return getNextToken();
				default:
					showError();
					return TOKEN_ERROR;
				}
				
			case 1:
				switch (c) {
				case 'D':
					state = 16;
					token += c;
					return getNextToken();
				case 'N':
					state = 17;
					token += c;
					return getNextToken();
				case 'A':
				case 'B':
				case 'C':
				case 'E':
				case 'F':
				case 'G':
				case 'H':
				case 'I':
				case 'J':
				case 'K':
				case 'L':
				case 'M':
				case 'O':
				case 'P':
				case 'Q':
				case 'R':
				case 'S':
				case 'T':
				case 'U':
				case 'V':
				case 'W':
				case 'X':
				case 'Y':
				case 'Z':
				case '0':
				case '1':
				case '2':
				case '3':
				case '4':
				case '5':
				case '6':
				case '7':
				case '8':
				case '9':
					state = 5;
					token += c;
					return getNextToken();
				case '\n':
					column = 0;
					line++;
				case ' ':
				case '\t':
					state = 0;
					return TOKEN_ARGUMENT;
				case ':':
					state = 0;
					return TOKEN_LABEL;
				case ';':
				case '#':
					state = 14;
					return TOKEN_ARGUMENT;
				case '/':
					state = 15;
					return TOKEN_ARGUMENT;
				default:
					showError();
					return TOKEN_ERROR;
				}
			case 2:
				switch (c) {
				case 'R':
					state = 18;
					token += c;
					return getNextToken();
				case 'A':
				case 'B':
				case 'C':
				case 'D':
				case 'E':
				case 'F':
				case 'G':
				case 'H':
				case 'I':
				case 'J':
				case 'K':
				case 'L':
				case 'M':
				case 'N':
				case 'O':
				case 'P':
				case 'Q':
				case 'S':
				case 'T':
				case 'U':
				case 'V':
				case 'W':
				case 'X':
				case 'Y':
				case 'Z':
				case '0':
				case '1':
				case '2':
				case '3':
				case '4':
				case '5':
				case '6':
				case '7':
				case '8':
				case '9':
					state = 5;
					token += c;
					return getNextToken();
				case '\n':
					column = 0;
					line++;
				case ' ':
				case '\t':
					state = 0;
					return TOKEN_ARGUMENT;
				case ':':
					state = 0;
					return TOKEN_LABEL;
				case ';':
				case '#':
					state = 14;
					return TOKEN_ARGUMENT;
				case '/':
					state = 15;
					return TOKEN_ARGUMENT;
				default:
					showError();
					return TOKEN_ERROR;
				}
			
			case 3:
				switch (c) {
				case 'P':
					state = 19;
					token += c;
					return getNextToken();
				case 'A':
				case 'B':
				case 'C':
				case 'D':
				case 'E':
				case 'F':
				case 'G':
				case 'H':
				case 'I':
				case 'J':
				case 'K':
				case 'L':
				case 'M':
				case 'N':
				case 'O':
				case 'Q':
				case 'R':
				case 'S':
				case 'T':
				case 'U':
				case 'V':
				case 'W':
				case 'X':
				case 'Y':
				case 'Z':
				case '0':
				case '1':
				case '2':
				case '3':
				case '4':
				case '5':
				case '6':
				case '7':
				case '8':
				case '9':
					state = 5;
					token += c;
					return getNextToken();
				case '\n':
					column = 0;
					line++;
				case ' ':
				case '\t':
					state = 0;
					return TOKEN_ARGUMENT;
				case ':':
					state = 0;
					return TOKEN_LABEL;
				case ';':
				case '#':
					state = 14;
					return TOKEN_ARGUMENT;
				case '/':
					state = 15;
					return TOKEN_ARGUMENT;
				default:
					showError();
					return TOKEN_ERROR;				
				}
			
			case 4:
				switch (c) {
				case 'W':
					state = 20;
					token += c;
					return getNextToken();
				
				case 'A':
				case 'B':
				case 'C':
				case 'D':
				case 'E':
				case 'F':
				case 'G':
				case 'H':
				case 'I':
				case 'J':
				case 'K':
				case 'L':
				case 'M':
				case 'N':
				case 'O':
				case 'P':
				case 'Q':
				case 'R':
				case 'S':
				case 'T':
				case 'U':
				case 'V':
				case 'X':
				case 'Y':
				case 'Z':
				case '0':
				case '1':
				case '2':
				case '3':
				case '4':
				case '5':
				case '6':
				case '7':
				case '8':
				case '9':
					state = 5;
					token += c;
					return getNextToken();
				case '\n':
					column = 0;
					line++;
				case ' ':
				case '\t':
					state = 0;
					return TOKEN_ARGUMENT;
				case ':':
					state = 0;
					return TOKEN_LABEL;
				case ';':
				case '#':
					state = 14;
					return TOKEN_ARGUMENT;
				case '/':
					state = 15;
					return TOKEN_ARGUMENT;
				default:
					showError();
					return TOKEN_ERROR;
				}
				
			case 5:
				switch (c) {
				case 'A':
				case 'B':
				case 'C':
				case 'D':
				case 'E':
				case 'F':
				case 'G':
				case 'H':
				case 'I':
				case 'J':
				case 'K':
				case 'L':
				case 'M':
				case 'N':
				case 'O':
				case 'P':
				case 'Q':
				case 'R':
				case 'S':
				case 'T':
				case 'U':
				case 'V':
				case 'W':
				case 'X':
				case 'Y':
				case 'Z':
				case '0':
				case '1':
				case '2':
				case '3':
				case '4':
				case '5':
				case '6':
				case '7':
				case '8':
				case '9':
					state = 5;
					token += c;
					return getNextToken();
				case '\n':
					column = 0;
					line++;
				case ' ':
				case '\t':
					state = 0;
					return TOKEN_ARGUMENT;
				case ':':
					state = 0;
					return TOKEN_LABEL;
				case ';':
				case '#':
					state = 14;
					return TOKEN_ARGUMENT;
				case '/':
					state = 15;
					return TOKEN_ARGUMENT;
				default:
					showError();
					return TOKEN_ERROR;
				}
				
			case 6:
				switch (c) {
				case 'N':
					state = 21;
					token += c;
					return getNextToken();
				case 'A':
				case 'B':
				case 'C':
				case 'D':
				case 'E':
				case 'F':
				case 'G':
				case 'H':
				case 'I':
				case 'J':
				case 'K':
				case 'L':
				case 'M':
				case 'O':
				case 'P':
				case 'Q':
				case 'R':
				case 'S':
				case 'T':
				case 'U':
				case 'V':
				case 'W':
				case 'X':
				case 'Y':
				case 'Z':
				case '0':
				case '1':
				case '2':
				case '3':
				case '4':
				case '5':
				case '6':
				case '7':
				case '8':
				case '9':
					state = 5;
					token += c;
					return getNextToken();
				case '\n':
					column = 0;
					line++;
				case ' ':
				case '\t':
					state = 0;
					return TOKEN_ARGUMENT;
				case ':':
					state = 0;
					return TOKEN_LABEL;
				case ';':
				case '#':
					state = 14;
					return TOKEN_ARGUMENT;
				case '/':
					state = 15;
					return TOKEN_ARGUMENT;
				default:
					showError();
					return TOKEN_ERROR;
				}
			
			case 7:
				switch (c) {
				case 'D':
					state = 22;
					token += c;
					return getNextToken();
				case 'A':
				case 'B':
				case 'C':
				case 'E':
				case 'F':
				case 'G':
				case 'H':
				case 'I':
				case 'J':
				case 'K':
				case 'L':
				case 'M':
				case 'N':
				case 'O':
				case 'P':
				case 'Q':
				case 'R':
				case 'S':
				case 'T':
				case 'U':
				case 'V':
				case 'W':
				case 'X':
				case 'Y':
				case 'Z':
				case '0':
				case '1':
				case '2':
				case '3':
				case '4':
				case '5':
				case '6':
				case '7':
				case '8':
				case '9':
					state = 5;
					token += c;
					return getNextToken();
				case '\n':
					column = 0;
					line++;
				case ' ':
				case '\t':
					state = 0;
					return TOKEN_ARGUMENT;
				case ':':
					state = 0;
					return TOKEN_LABEL;
				case ';':
				case '#':
					state = 14;
					return TOKEN_ARGUMENT;
				case '/':
					state = 15;
					return TOKEN_ARGUMENT;
				default:
					showError();
					return TOKEN_ERROR;
					
				}
				
			case 8:
				switch (c) {
				case 'R':
					state = 20;
					token += c;
					return getNextToken();
				case 'A':
				case 'B':
				case 'C':
				case 'D':
				case 'E':
				case 'F':
				case 'G':
				case 'H':
				case 'I':
				case 'J':
				case 'K':
				case 'L':
				case 'M':
				case 'N':
				case 'O':
				case 'P':
				case 'Q':
				case 'S':
				case 'T':
				case 'U':
				case 'V':
				case 'W':
				case 'X':
				case 'Y':
				case 'Z':
				case '0':
				case '1':
				case '2':
				case '3':
				case '4':
				case '5':
				case '6':
				case '7':
				case '8':
				case '9':
					state = 5;
					token += c;
					return getNextToken();
				case '\n':
					column = 0;
					line++;
				case ' ':
				case '\t':
					state = 0;
					return TOKEN_ARGUMENT;
				case ':':
					state = 0;
					return TOKEN_LABEL;
				case ';':
				case '#':
					state = 14;
					return TOKEN_ARGUMENT;
				case '/':
					state = 15;
					return TOKEN_ARGUMENT;
				default:
					showError();
					return TOKEN_ERROR;
				
				}
				
			case 9:
				switch (c) {
				case 'H':
					state = 24;
					token += c;
					return getNextToken();
				case 'T':
					state = 25;
					token += c;
					return getNextToken();
				case 'U':
					state = 26;
					token += c;
					return getNextToken();
				case 'A':
				case 'B':
				case 'C':
				case 'D':
				case 'E':
				case 'F':
				case 'G':
				case 'I':
				case 'J':
				case 'K':
				case 'L':
				case 'M':
				case 'N':
				case 'O':
				case 'P':
				case 'Q':
				case 'R':
				case 'S':
				case 'V':
				case 'W':
				case 'X':
				case 'Y':
				case 'Z':
				case '0':
				case '1':
				case '2':
				case '3':
				case '4':
				case '5':
				case '6':
				case '7':
				case '8':
				case '9':
					state = 5;
					token += c;
					return getNextToken();
				case '\n':
					column = 0;
					line++;
				case ' ':
				case '\t':
					state = 0;
					return TOKEN_ARGUMENT;
				case ':':
					state = 0;
					return TOKEN_LABEL;
				case ';':
				case '#':
					state = 14;
					return TOKEN_ARGUMENT;
				case '/':
					state = 15;
					return TOKEN_ARGUMENT;
				default:
					showError();
					return TOKEN_ERROR;
				
				}
				
			case 10:
				switch (c) {
				case 'O':
					state = 27;
					token += c;
					return getNextToken();
				case 'A':
				case 'B':
				case 'C':
				case 'D':
				case 'E':
				case 'F':
				case 'G':
				case 'H':
				case 'I':
				case 'J':
				case 'K':
				case 'L':
				case 'M':
				case 'N':
				case 'P':
				case 'Q':
				case 'R':
				case 'S':
				case 'T':
				case 'U':
				case 'V':
				case 'W':
				case 'X':
				case 'Y':
				case 'Z':
				case '0':
				case '1':
				case '2':
				case '3':
				case '4':
				case '5':
				case '6':
				case '7':
				case '8':
				case '9':
					state = 5;
					token += c;
					return getNextToken();
				case '\n':
					column = 0;
					line++;
				case ' ':
				case '\t':
					state = 0;
					return TOKEN_ARGUMENT;
				case ':':
					state = 0;
					return TOKEN_LABEL;
				case ';':
				case '#':
					state = 14;
					return TOKEN_ARGUMENT;
				case '/':
					state = 15;
					return TOKEN_ARGUMENT;
				default:
					showError();
					return TOKEN_ERROR;
					
				}
			
			case 11:
				switch (c) {
				case 'X':
					state = 28;
					token += c;
					return getNextToken();
				case 'B':
					state = 0;
					token += c;
					return TOKEN_ARGUMENT;
				case '0':
				case '1':
					state = 29;
					token += c;
					return getNextToken();
				case '2':
				case '3':
				case '4':
				case '5':
				case '6':
				case '7':
				case '8':
				case '9':
					state = 13;
					token += c;
					return getNextToken();
				case '\n':
					column = 0;
					line++;
				case ' ':
				case '\t':
					state = 0;
					return TOKEN_ARGUMENT;
				case ';':
				case '#':
					state = 14;
					return TOKEN_ARGUMENT;
				case '/':
					state = 15;
					return TOKEN_ARGUMENT;
				default:
					showError();
					return TOKEN_ERROR;
				
				}
				
			case  12:
				switch (c) {
				case '0':
				case '1':
					state = 29;
					token += c;
					return getNextToken();
				case '2':
				case '3':
				case '4':
				case '5':
				case '6':
				case '7':
				case '8':
				case '9':
					state = 13;
					token += c;
					return getNextToken();
				case '\n':
					column = 0;
					line++;
				case ' ':
				case '\t':
					state = 0;
					return TOKEN_ARGUMENT;
				case ';':
				case '#':
					state = 14;
					return TOKEN_ARGUMENT;
				case '/':
					state = 15;
					return TOKEN_ARGUMENT;
				default:
					showError();
					return TOKEN_ERROR;
				}
			
			case 13:
				switch (c) {
				case '0':
				case '1':
				case '2':
				case '3':
				case '4':
				case '5':
				case '6':
				case '7':
				case '8':
				case '9':
					token += c;
					return getNextToken();
				case '\n':
					column = 0;
					line++;
				case ' ':
				case '\t':
					state = 0;
					return TOKEN_ARGUMENT;
				case ';':
				case '#':
					state = 14;
					return TOKEN_ARGUMENT;
				case '/':
					state = 15;
					return TOKEN_ARGUMENT;
				default:
					showError();
					return TOKEN_ERROR;
				}
				
			case 14:
				switch(c) {
				case '\n':
					column = 0;
					line++;
					return TOKEN_COMMENT;
				default:
					token = "";
					state = 30;
					return getNextToken();
				}
			
			
			case 15:
				switch(c) {
				case '/':
					state = 30;
					token = "";
					return getNextToken();
				default:
					showError();
					return TOKEN_ERROR;
				}
				
				
			case 16:
				switch (c) {
				case 'D':
					state = 20;
					token += c;
					return getNextToken();
				case 'A':
				case 'B':
				case 'C':
				case 'E':
				case 'F':
				case 'G':
				case 'H':
				case 'I':
				case 'J':
				case 'K':
				case 'L':
				case 'M':
				case 'N':
				case 'O':
				case 'P':
				case 'Q':
				case 'R':
				case 'S':
				case 'T':
				case 'U':
				case 'V':
				case 'W':
				case 'X':
				case 'Y':
				case 'Z':
				case '0':
				case '1':
				case '2':
				case '3':
				case '4':
				case '5':
				case '6':
				case '7':
				case '8':
				case '9':
					state = 5;
					token += c;
					return getNextToken();
				case '\n':
					column = 0;
					line++;
				case ' ':
				case '\t':
					state = 0;
					return TOKEN_ARGUMENT;
				case ':':
					state = 0;
					return TOKEN_LABEL;
				case ';':
				case '#':
					state = 14;
					return TOKEN_ARGUMENT;
				case '/':
					state = 15;
					return TOKEN_ARGUMENT;
				default:
					showError();
					return TOKEN_ERROR;
				}

			case 17:
				switch (c) {
				case 'D':
					state = 20;
					token += c;
					return getNextToken();
				case 'A':
				case 'B':
				case 'C':
				case 'E':
				case 'F':
				case 'G':
				case 'H':
				case 'I':
				case 'J':
				case 'K':
				case 'L':
				case 'M':
				case 'N':
				case 'O':
				case 'P':
				case 'Q':
				case 'R':
				case 'S':
				case 'T':
				case 'U':
				case 'V':
				case 'W':
				case 'X':
				case 'Y':
				case 'Z':
				case '0':
				case '1':
				case '2':
				case '3':
				case '4':
				case '5':
				case '6':
				case '7':
				case '8':
				case '9':
					state = 5;
					token += c;
					return getNextToken();
				case '\n':
					column = 0;
					line++;
				case ' ':
				case '\t':
					state = 0;
					return TOKEN_ARGUMENT;
				case ':':
					state = 0;
					return TOKEN_LABEL;
				case ';':
				case '#':
					state = 14;
					return TOKEN_ARGUMENT;
				case '/':
					state = 15;
					return TOKEN_ARGUMENT;
				default:
					showError();
					return TOKEN_ERROR;

				}

			case 18:
				switch (c) {
				case 'C':
				case 'Z':
					state = 20;
					token += c;
					return getNextToken();
				case 'A':
				case 'B':
				case 'D':
				case 'E':
				case 'F':
				case 'G':
				case 'H':
				case 'I':
				case 'J':
				case 'K':
				case 'L':
				case 'M':
				case 'N':
				case 'O':
				case 'P':
				case 'Q':
				case 'R':
				case 'S':
				case 'T':
				case 'U':
				case 'V':
				case 'W':
				case 'X':
				case 'Y':
				case '0':
				case '1':
				case '2':
				case '3':
				case '4':
				case '5':
				case '6':
				case '7':
				case '8':
				case '9':
					state = 5;
					token += c;
					return getNextToken();
				case '\n':
					column = 0;
					line++;
				case ' ':
				case '\t':
					state = 0;
					return TOKEN_ARGUMENT;
				case ':':
					state = 0;
					return TOKEN_LABEL;
				case ';':
				case '#':
					state = 14;
					return TOKEN_ARGUMENT;
				case '/':
					state = 15;
					return TOKEN_ARGUMENT;
				default:
					showError();
					return TOKEN_ERROR;
				}

				
			case 19:
				switch (c) {
				case 'I':
					state = 20;
					token += c;
					return getNextToken();
				case 'A':
				case 'B':
				case 'C':
				case 'D':
				case 'E':
				case 'F':
				case 'G':
				case 'H':
				case 'J':
				case 'K':
				case 'L':
				case 'M':
				case 'N':
				case 'O':
				case 'P':
				case 'Q':
				case 'R':
				case 'S':
				case 'T':
				case 'U':
				case 'V':
				case 'W':
				case 'X':
				case 'Y':
				case 'Z':
				case '0':
				case '1':
				case '2':
				case '3':
				case '4':
				case '5':
				case '6':
				case '7':
				case '8':
				case '9':
					state = 5;
					token += c;
					return getNextToken();
				case '\n':
					column = 0;
					line++;
				case ' ':
				case '\t':
					state = 0;
					return TOKEN_ARGUMENT;
				case ':':
					state = 0;
					return TOKEN_LABEL;
				case ';':
				case '#':
					state = 14;
					return TOKEN_ARGUMENT;
				case '/':
					state = 15;
					return TOKEN_ARGUMENT;
				default:
					showError();
					return TOKEN_ERROR;
				
				}
				
			case 20:
				switch (c) {
				case 'A':
				case 'B':
				case 'C':
				case 'D':
				case 'E':
				case 'F':
				case 'G':
				case 'H':
				case 'I':
				case 'J':
				case 'K':
				case 'L':
				case 'M':
				case 'N':
				case 'O':
				case 'P':
				case 'Q':
				case 'R':
				case 'S':
				case 'T':
				case 'U':
				case 'V':
				case 'W':
				case 'X':
				case 'Y':
				case 'Z':
				case '0':
				case '1':
				case '2':
				case '3':
				case '4':
				case '5':
				case '6':
				case '7':
				case '8':
				case '9':
					state = 5;
					token += c;
					return getNextToken();
				case '\n':
					column = 0;
					line++;
				case ' ':
				case '\t':
					state = 0;
					return TOKEN_STATEMENT;
				case ':':
					state = 0;
					return TOKEN_LABEL;
				case ';':
				case '#':
					state = 14;
					return TOKEN_STATEMENT;
				case '/':
					state = 15;
					return TOKEN_STATEMENT;
				default:
					showError();
					return TOKEN_ERROR;

				}
				
			case 21:
				switch (c) {
				case 'C':
					state = 31;
					token += c;
					return getNextToken();
				case 'A':
				case 'B':
				case 'D':
				case 'E':
				case 'F':
				case 'G':
				case 'H':
				case 'I':
				case 'J':
				case 'K':
				case 'L':
				case 'M':
				case 'N':
				case 'O':
				case 'P':
				case 'Q':
				case 'R':
				case 'S':
				case 'T':
				case 'U':
				case 'V':
				case 'W':
				case 'X':
				case 'Y':
				case 'Z':
				case '0':
				case '1':
				case '2':
				case '3':
				case '4':
				case '5':
				case '6':
				case '7':
				case '8':
				case '9':
					state = 5;
					token += c;
					return getNextToken();
				case '\n':
					column = 0;
					line++;
				case ' ':
				case '\t':
					state = 0;
					return TOKEN_ARGUMENT;
				case ':':
					state = 0;
					return TOKEN_LABEL;
				case ';':
				case '#':
					state = 14;
					return TOKEN_ARGUMENT;
				case '/':
					state = 15;
					return TOKEN_ARGUMENT;
				default:
					showError();
					return TOKEN_ERROR;
				
				}
				
			case 22:
				switch (c) {
				case 'A':
					state = 32;
					token += c;
					return getNextToken();
				case 'I':
					state = 20;
					token += c;
					return getNextToken();
				case 'B':
				case 'C':
				case 'D':
				case 'E':
				case 'F':
				case 'G':
				case 'H':
				case 'J':
				case 'K':
				case 'L':
				case 'M':
				case 'N':
				case 'O':
				case 'P':
				case 'Q':
				case 'R':
				case 'S':
				case 'T':
				case 'U':
				case 'V':
				case 'W':
				case 'X':
				case 'Y':
				case 'Z':
				case '0':
				case '1':
				case '2':
				case '3':
				case '4':
				case '5':
				case '6':
				case '7':
				case '8':
				case '9':
					state = 5;
					token += c;
					return getNextToken();
				case '\n':
					column = 0;
					line++;
				case ' ':
				case '\t':
					state = 0;
					return TOKEN_ARGUMENT;
				case ':':
					state = 0;
					return TOKEN_LABEL;
				case ';':
				case '#':
					state = 14;
					return TOKEN_ARGUMENT;
				case '/':
					state = 15;
					return TOKEN_ARGUMENT;
				default:
					showError();
					return TOKEN_ERROR;
					
				}
				
		    // case 23: not used
			case 24:
				switch (c) {
				case 'L':
				case 'R':
					token += c;
					state = 20;
					return getNextToken();
				case 'A':
				case 'B':
				case 'C':
				case 'D':
				case 'E':
				case 'F':
				case 'G':
				case 'H':
				case 'I':
				case 'J':
				case 'K':
				case 'M':
				case 'N':
				case 'O':
				case 'P':
				case 'Q':
				case 'S':
				case 'T':
				case 'U':
				case 'V':
				case 'W':
				case 'X':
				case 'Y':
				case 'Z':
				case '0':
				case '1':
				case '2':
				case '3':
				case '4':
				case '5':
				case '6':
				case '7':
				case '8':
				case '9':
					state = 5;
					token += c;
					return getNextToken();
				case '\n':
					column = 0;
					line++;
				case ' ':
				case '\t':
					state = 0;
					return TOKEN_ARGUMENT;
				case ':':
					state = 0;
					return TOKEN_LABEL;
				case ';':
				case '#':
					state = 14;
					return TOKEN_ARGUMENT;
				case '/':
					state = 15;
					return TOKEN_ARGUMENT;
				default:
					showError();
					return TOKEN_ERROR;
				
				}
				
			case 25:
				switch (c) {
				case 'I':
				case 'O':
					token += c;
					state = 20;
					return getNextToken();
				case 'A':
				case 'B':
				case 'C':
				case 'D':
				case 'E':
				case 'F':
				case 'G':
				case 'H':
				case 'J':
				case 'K':
				case 'L':
				case 'M':
				case 'N':
				case 'P':
				case 'Q':
				case 'R':
				case 'S':
				case 'T':
				case 'U':
				case 'V':
				case 'W':
				case 'X':
				case 'Y':
				case 'Z':
				case '0':
				case '1':
				case '2':
				case '3':
				case '4':
				case '5':
				case '6':
				case '7':
				case '8':
				case '9':
					state = 5;
					token += c;
					return getNextToken();
				case '\n':
					column = 0;
					line++;
				case ' ':
				case '\t':
					state = 0;
					return TOKEN_ARGUMENT;
				case ':':
					state = 0;
					return TOKEN_LABEL;
				case ';':
				case '#':
					state = 14;
					return TOKEN_ARGUMENT;
				case '/':
					state = 15;
					return TOKEN_ARGUMENT;
				default:
					showError();
					return TOKEN_ERROR;
					
				}
				
			case 26:
				switch (c) {
				case 'B':
					token += c;
					state = 20;
					return getNextToken();
				case 'A':
				case 'C':
				case 'D':
				case 'E':
				case 'F':
				case 'G':
				case 'H':
				case 'I':
				case 'J':
				case 'K':
				case 'L':
				case 'M':
				case 'N':
				case 'O':
				case 'P':
				case 'Q':
				case 'R':
				case 'S':
				case 'T':
				case 'U':
				case 'V':
				case 'W':
				case 'X':
				case 'Y':
				case 'Z':
				case '0':
				case '1':
				case '2':
				case '3':
				case '4':
				case '5':
				case '6':
				case '7':
				case '8':
				case '9':
					state = 5;
					token += c;
					return getNextToken();
				case '\n':
					column = 0;
					line++;
				case ' ':
				case '\t':
					state = 0;
					return TOKEN_ARGUMENT;
				case ':':
					state = 0;
					return TOKEN_LABEL;
				case ';':
				case '#':
					state = 14;
					return TOKEN_ARGUMENT;
				case '/':
					state = 15;
					return TOKEN_ARGUMENT;
				default:
					showError();
					return TOKEN_ERROR;
					
				}
				
			case 27:
				switch (c) {
				case 'R':
					token += c;
					state = 20;
					return getNextToken();
				case 'A':
				case 'B':
				case 'C':
				case 'D':
				case 'E':
				case 'F':
				case 'G':
				case 'H':
				case 'I':
				case 'J':
				case 'K':
				case 'L':
				case 'M':
				case 'N':
				case 'O':
				case 'P':
				case 'Q':
				case 'S':
				case 'T':
				case 'U':
				case 'V':
				case 'W':
				case 'X':
				case 'Y':
				case 'Z':
				case '0':
				case '1':
				case '2':
				case '3':
				case '4':
				case '5':
				case '6':
				case '7':
				case '8':
				case '9':
					state = 5;
					token += c;
					return getNextToken();
				case '\n':
					column = 0;
					line++;
				case ' ':
				case '\t':
					state = 0;
					return TOKEN_ARGUMENT;
				case ':':
					state = 0;
					return TOKEN_LABEL;
				case ';':
				case '#':
					state = 14;
					return TOKEN_ARGUMENT;
				case '/':
					state = 15;
					return TOKEN_ARGUMENT;
				default:
					showError();
					return TOKEN_ERROR;

				}
				
			case 28:
				switch (c) {
				case '0':
				case '1':
				case '2':
				case '3':
				case '4':
				case '5':
				case '6':
				case '7':
				case '8':
				case '9':
				case 'A':
				case 'B':
				case 'C':
				case 'D':
				case 'E':
				case 'F':
					token += c;
					return getNextToken();
				case '\n':
					column = 0;
					line++;
				case ' ':
				case '\t':
					state = 0;
					return TOKEN_ARGUMENT;
				case ';':
				case '#':
					state = 14;
					return TOKEN_ARGUMENT;
				case '/':
					state = 15;
					return TOKEN_ARGUMENT;
				default:
					showError();
					return TOKEN_ERROR;
					
				}
				
			case 29:
				switch (c) {
				case '0':
				case '1':
					token += c;
					return getNextToken();
				case 'B':
					token += c;
					return TOKEN_ARGUMENT;
				case '2':
				case '3':
				case '4':
				case '5':
				case '6':
				case '7':
				case '8':
				case '9':
					state = 13;
					token += c;
					return getNextToken();
				case '\n':
					column = 0;
					line++;
				case ' ':
				case '\t':
					state = 0;
					return TOKEN_ARGUMENT;
				case ';':
				case '#':
					state = 14;
					return TOKEN_ARGUMENT;
				case '/':
					state = 15;
					return TOKEN_ARGUMENT;
				default:
					showError();
					return TOKEN_ERROR;
				
				}
				
			case 30:
				switch (c) {
				case '\n':
					state = 0;
					return TOKEN_COMMENT;
				default:
					token += c;
					return getNextToken();
				}
				
			case 31:
				switch (c) {
				case 'A':
					state = 33;
					token += c;
					return getNextToken();
				case 'B':
				case 'C':
				case 'D':
				case 'E':
				case 'F':
				case 'G':
				case 'H':
				case 'I':
				case 'J':
				case 'K':
				case 'L':
				case 'M':
				case 'N':
				case 'O':
				case 'P':
				case 'Q':
				case 'R':
				case 'S':
				case 'T':
				case 'U':
				case 'V':
				case 'W':
				case 'X':
				case 'Y':
				case 'Z':
				case '0':
				case '1':
				case '2':
				case '3':
				case '4':
				case '5':
				case '6':
				case '7':
				case '8':
				case '9':
					state = 5;
					token += c;
					return getNextToken();
				case '\n':
					column = 0;
					line++;
				case ' ':
				case '\t':
					state = 0;
					return TOKEN_ARGUMENT;
				case ':':
					state = 0;
					return TOKEN_LABEL;
				case ';':
				case '#':
					state = 14;
					return TOKEN_ARGUMENT;
				case '/':
					state = 15;
					return TOKEN_ARGUMENT;
				default:
					showError();
					return TOKEN_ERROR;
				}
				
			case 32:
				switch (c) {
				case 'R':
					state = 20;
					token += c;
					return getNextToken();
				case 'A':
				case 'B':
				case 'C':
				case 'D':
				case 'E':
				case 'F':
				case 'G':
				case 'H':
				case 'I':
				case 'J':
				case 'K':
				case 'L':
				case 'M':
				case 'N':
				case 'O':
				case 'P':
				case 'Q':
				case 'S':
				case 'T':
				case 'U':
				case 'V':
				case 'W':
				case 'X':
				case 'Y':
				case 'Z':
				case '0':
				case '1':
				case '2':
				case '3':
				case '4':
				case '5':
				case '6':
				case '7':
				case '8':
				case '9':
					state = 5;
					token += c;
					return getNextToken();
				case '\n':
					column = 0;
					line++;
				case ' ':
				case '\t':
					state = 0;
					return TOKEN_STATEMENT;
				case ':':
					state = 0;
					return TOKEN_LABEL;
				case ';':
				case '#':
					state = 14;
					return TOKEN_STATEMENT;
				case '/':
					state = 15;
					return TOKEN_STATEMENT;
				default:
					showError();
					return TOKEN_ERROR;
					
				}
				
			case 33:
				switch (c) {
				case 'R':
					state = 20;
					token += c;
					return getNextToken();
				case 'A':
				case 'B':
				case 'C':
				case 'D':
				case 'E':
				case 'F':
				case 'G':
				case 'H':
				case 'I':
				case 'J':
				case 'K':
				case 'L':
				case 'M':
				case 'N':
				case 'O':
				case 'P':
				case 'Q':
				case 'S':
				case 'T':
				case 'U':
				case 'V':
				case 'W':
				case 'X':
				case 'Y':
				case 'Z':
				case '0':
				case '1':
				case '2':
				case '3':
				case '4':
				case '5':
				case '6':
				case '7':
				case '8':
				case '9':
					state = 5;
					token += c;
					return getNextToken();
				case '\n':
					column = 0;
					line++;
				case ' ':
				case '\t':
					state = 0;
					return TOKEN_ARGUMENT;
				case ':':
					state = 0;
					return TOKEN_LABEL;
				case ';':
				case '#':
					state = 14;
					return TOKEN_ARGUMENT;
				case '/':
					state = 15;
					return TOKEN_ARGUMENT;
				default:
					showError();
					return TOKEN_ERROR;
					
				}
			}
		
			
			showError();
			return TOKEN_ERROR;
		}
		
		void showError() {
			System.err.println("scanner error: line: " + line + " column: " + column);
		}
	}
}
