import java.awt.BorderLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;


public class BreakpointsFrame extends JFrame implements ActionListener {
	private static final long serialVersionUID = 1234567891L;

	private DefaultListModel listmodel = new DefaultListModel();
	private JList list = new JList(listmodel);
	private JTextField address = new JTextField();
	
	public BreakpointsFrame() {
		super("Toy Simulator - Breakpoints");
		
		JPanel content = new JPanel();
		content.setLayout(new BorderLayout());
		
		content.add(new JScrollPane(list), BorderLayout.CENTER);
		
		JPanel south = new JPanel();
		south.setLayout(new GridLayout(2, 1));
		address.addActionListener(this);
		south.add(address);
		
		JPanel buttons = new JPanel();
		buttons.setLayout(new GridLayout(1, 2));
		JButton btn = new JButton("insert");
		btn.addActionListener(this);
		buttons.add(btn);
		btn = new JButton("delete");
		btn.addActionListener(this);
		buttons.add(btn);
		south.add(buttons);
		
		content.add(south, BorderLayout.SOUTH);
		
		setContentPane(content);
		pack();
		setVisible(false);
	}
	
	public void actionPerformed(ActionEvent e) {
		if (e.getSource() == address || e.getActionCommand().equals("insert")) {
			addBreakpoint(address.getText());
		} else if (e.getActionCommand().equals("delete")) {
			if (list.getSelectedIndex() > -1) {
				listmodel.remove(list.getSelectedIndex());
			}
		}
	}
	
	public void removeBreakpoint(String s) {
		for(int i = 0; i < listmodel.size(); i++) {
			if (listmodel.get(i).equals(s)) {
				listmodel.remove(i);
				return;
			}
		}
	}
	
	public void addBreakpoint(String s) {
		int i = 0;
		if (s.startsWith("0x") || s.startsWith("0X")) {
			try {
				i = Integer.parseInt(s.substring(2), 16);
			} catch (NumberFormatException e) {
				JOptionPane.showMessageDialog(this, "An exception occured: " + e);
				e.printStackTrace();
				return;
			}
		} else if (s.startsWith("$")) {
			try {
				i = Integer.parseInt(s.substring(1), 16);
			} catch (NumberFormatException e) {
				JOptionPane.showMessageDialog(this, "An exception occured: " + e);
				e.printStackTrace();
				return;
			}
		} else if (s.startsWith("0")) {
			try {
				i = Integer.parseInt(s, 7);
			} catch (NumberFormatException e) {
				JOptionPane.showMessageDialog(this, "An exception occured: " + e);
				e.printStackTrace();
				return;
			}			
		} else if (s.endsWith("b") || s.endsWith("B")) {
			try {
				i = Integer.parseInt(s.substring(0, s.length()-1), 2);
			} catch (NumberFormatException e) {
				JOptionPane.showMessageDialog(this, "An exception occured: " + e);
				e.printStackTrace();
				return;
			}
		} else {
			try {
				i = Integer.parseInt(s);
			} catch (NumberFormatException e) {
				JOptionPane.showMessageDialog(this, "An exception occured: " + e);
				e.printStackTrace();
				return;
			}
		}

		if (i > 0xfff) {
			JOptionPane.showMessageDialog(this, "The given breakpoint is too big. Only a 12 bit value is allowed.");
		} else {
			if (isBreakpoint(i)) {
				JOptionPane.showMessageDialog(this, "The breakpoint exists already.");
			} else {
				listmodel.addElement(toHexString(i, 12, true));
			}
		}
	}
	
	private String toHexString(int i, int bits, boolean prefix) {
		if (i < 0) i += Math.pow(2, bits);
		String s = Integer.toHexString(i);
		while (s.length() < (bits/4)) {
			s = "0" + s;
		}
		
		if (prefix) {
			return "$" + s;
		} else {
			return s;
		}
	}
	
	public boolean isBreakpoint(int s) {
		String bp = toHexString(s, 12, true);
		for(int i = 0; i < listmodel.getSize(); i++) {
			if (((String) listmodel.get(i)).equals(bp)) return true;
		}
	
		return false;
	}
	
}
