import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Font;

import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextArea;

public class Console extends JFrame {
	private static final long serialVersionUID = 1234567893L;

	private JTextArea text = new JTextArea(10, 40);
	private short[] mem;
	
	public Console(short[] ram) {
		super("Toy Simulator - Console");
		
		mem = ram;
		
		JPanel content = new JPanel();
		content.setLayout(new BorderLayout());
		
		text.setFont(new Font("monospaced", 0, 14));
		text.setEditable(false);
		text.setForeground(Color.gray);
		text.setBackground(Color.black);
		content.add(text, BorderLayout.CENTER);

		setContentPane(content);
		pack();
		setVisible(false);
	}
	
	public void showText() {
		// console is at the end of the memory
		// 40*10 = 400 bytes = 200 words
		// the first index should be 3896 (0xf38)
		
		String output = "";
		int index = 0xfff - 200 + 1;
		for(int row = 0; row < 10; row++) {
			int column = 0;
			while (column < 40) {
				short s = mem[index++];
				char c = (char) ((s & 0xFF00) >> 8);
				if (c < 31) c = ' ';
				output += c;
				c = (char) (s & 0xFF);
				if (c < 31) c = ' ';
				output += c;
				column += 2;
			}
			output += "\n";
		}
		
		text.setText(output);
	}
}
