import java.awt.event.*;
import javax.swing.JTextField;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JCheckBox;

public class EventListener implements ActionListener {
	private MainFrame mainframe = null;
	
	public EventListener(MainFrame mf) {
		mainframe = mf;
	}
	
	public void actionPerformed(ActionEvent e) {
		String action = e.getActionCommand();
		if (e.getSource() instanceof JButton) {
			if (action.equals("Reset")) {
				mainframe.action_reset();
			} else if (action.equals("Single Step")) {
				mainframe.action_singlestep();
			} else if (action.equals("Run")) {
				((JButton) e.getSource()).setText("Stop");
				mainframe.action_run();
			} else if (action.equals("Stop")) {
				((JButton) e.getSource()).setText("Run");
			} else if (action.equals("Breakpoints")) {
				mainframe.action_breakpoints();
			} else {
				System.out.println("Button-Action!!");
			}
		} else if (e.getSource() instanceof JTextField) {
			mainframe.setRegister((JTextField) e.getSource());
		} else if (e.getSource() instanceof JMenuItem) {
			if (action.equals("Exit")) {
				System.exit(0);
			} else if (action.equals("Open Object File...")) {
				mainframe.action_open_object_file();
			} else if (action.equals("Open Assembler File...")) {
				mainframe.action_open_asm_file();
			} else if (action.equals("New Assembler File...")) {
				mainframe.action_new_assembler_file();
			} else if (action.equals("RAM")) {
				mainframe.action_view_ram();
			} else if (action.equals("Console")) {
				mainframe.action_view_console();
			} else if (action.equals("LCD")) {
				mainframe.action_view_lcd();
			} else if (action.equals("Version")) {
				mainframe.action_about_version();
			} else {
				System.out.println("Menu-Action!!");
			}
		} else if (e.getSource() instanceof JCheckBox) {
			mainframe.setFlags();
		} else {
			System.out.println("Action!!");
		}

	}
	
}
