import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Font;

import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextArea;

public class LCD extends JFrame {
	private static final long serialVersionUID = 1234567899L;

	private JTextArea text = new JTextArea(1, 2);
	private short[] mem;
	
	public LCD(short[] ram) {
		super("Toy Simulator - LCD");
		
		mem = ram;
		
		JPanel content = new JPanel();
		content.setLayout(new BorderLayout());
		
		text.setFont(new Font("monospaced", Font.BOLD, 42));
		text.setEditable(false);
		text.setForeground(Color.black);
		text.setBackground(Color.yellow);
		content.add(text, BorderLayout.CENTER);
		
		setContentPane(content);
		pack();
		setVisible(false);
	}
	
	public void showText() {
		String output = "";
		int index = 0xffe;
		short s = mem[index++];
		char c = (char) ((s & 0xFF00) >> 8);
		if (c < 31) c = ' ';
		output += c;
		c = (char) (s & 0xFF);
		if (c < 31) c = ' ';
		output += c;
		
		s = mem[index];
		c = (char) ((s & 0xFF00) >> 8);
		if (c < 31) c = ' ';
		output += c;
		c = (char) (s & 0xFF);
		if (c < 31) c =  ' ';
		output += c;
				
		text.setText(output);
	}

}
