/*
 *  src/lesson.cpp
 *  2002-05-27
 *
 *  voctrain - a vocabulary trainer for linux and windows
 *  Copyright (C) 2002  Andreas Dangel <a.dangel@gmx.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "vocable.h"
#include "lesson.h"
#include <qstring.h>


/**
 * Konstruktor: Initialisiert alle Felder.
 */
Lesson::Lesson(Lesson * parent) : QListViewItem(parent)
{
    aTitle = "";
    toXML();
}

Lesson::Lesson(Vocabulary * parent) : QListViewItem(parent)
{
    aTitle = "";
    toXML();
}

/**
 * Destruktor: keine Funktion/Aufgabe
 */
Lesson::~Lesson() { }


/**
 * Verndert das Attribut aTitle
 */
void Lesson::setTitle(const QString& s)
{
    aTitle = s.latin1();
}


/**
 * Gibt aTitle zurck.
 */
const QString& Lesson::getTitle()
{
    return aTitle;
}


/**
 * Erstellt einen XML-Code.
 */
const QString& Lesson::toXML(int indent = 0)
{
    /* Zeileneinzug */
    QString sIndent = "";
    for (int i = 0; i < indent; i++) sIndent += " ";

    aXML  = "";
    aXML += sIndent + "<Lesson>\n";
    aXML += sIndent + "  <TitleOfLesson>" + aTitle + "</TitleOfLesson>\n";

    /* Lektionen */
    QListViewItem * it = this->firstChild();
    while (it != NULL)
    {
        Item * it2 = dynamic_cast<Item*> (it);
        if (it2->isLesson() == true) {
            aXML += ((Lesson *) it)->toXML(indent + 2);
        }
        it = it->nextSibling();
    }
    aXML += "\n";

    /* Vokabeln */
    it = this->firstChild();
    while (it != NULL)
    {
        Item * it2 = dynamic_cast<Item*> (it);
        if (it2->isVocable() == true) {
            aXML += ((Vocable *) it)->toXML(indent + 2);
        }
        it = it->nextSibling();
    }

    aXML += sIndent + "</Lesson>\n";

    return aXML;
}


/**
 * berschriebene Methode von QListViewItem
 */
QString Lesson::text(int column) const
{
    switch(column)
    {
        case 0: return "LESSON";
        case 1: return aTitle;
        default: return "";
    }
}

/**
 * berschriebene Methoden von Item
 */
bool Lesson::isVocable() { return false; }
bool Lesson::isLesson() { return true; }
    
