/*
 *  lesson.h
 *  2002-05-27
 *
 *  voctrain - a vocabulary trainer for linux and windows
 *  Copyright (C) 2002  Andreas Dangel <a.dangel@gmx.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef _LESSON_H_
#define _LESSON_H_

#include "item.h"
#include "vocabulary.h"

// verwendet die qt-Library 2.3 von trolltech.com
#include <qstring.h>
#include <qlistview.h>


/**
 * Klasse     : Lesson
 * Summary    : Reprsentiert den Datensatz einer Lektion
 * Description: Auch die Klasse Lesson wird von QListViewItem abgeleitet,
 *     damit sie leicht in einem QListView-Objekt dargestellt werden kann.
 */
class Lesson : public QListViewItem, public Item
{
    public:
        /**
         * Konstruktor: erstellt ein leeres Lesson-Objekt mit leeren Feldern.
         *     Das parent-Argument wird an den geerbten Konstruktor bergeben.
         */
        Lesson(Vocabulary * parent);
        Lesson(Lesson * parent);
        
        /**
         * Destruktor: keine Funktion/Aufgabe
         */
        ~Lesson();


        /**
         * Verndert das Attribut aTitle
         */
        void setTitle(const QString& s);

        /**
         * Gibt aTitle zurck.
         */
        const QString& getTitle();


        /**
         * Erstellt einen XML-Code.
         */
        const QString& toXML(int indent = 0);


        /**
         * berschriebene Methode von QListViewItem
         */
        QString text(int column) const;

        /**
         * berschriebene Methoden von Item
         */
        bool isVocable();
        bool isLesson();
        bool isVocabulary();

    private:
        /** Titel */
        QString aTitle;

        /** XML */
        QString aXML;
};

#endif _LESSON_H_
