/*
 *  test/test1.cpp
 *  2002-05-27
 *
 *  voctrain - a vocabulary trainer for linux and windows
 *  Copyright (C) 2002  Andreas Dangel <a.dangel@gmx.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "vocable.h"
#include "lesson.h"
#include "vocabulary.h"

#include <qapplication.h>


int main(int argc, char** argv)
{
    QApplication app (argc, argv);

    Vocabulary vocab;

    Lesson * les = NULL;
    Lesson * les2 = NULL;
    Vocable * voc = NULL;

    les = new Lesson(&vocab);
    les->setTitle("Title of 1st Lesson");
    voc = new Vocable(les);
    voc->setWord("Word of 1st Vocable");
    voc->getTranslations().append("Trans 1");
    voc->setRemark("Remark");

    voc = new Vocable(les);
    voc->setWord("Word of 2nd Vocable");
    voc->getTranslations().append("Trans 1");
    voc->getTranslations().append("Trans 2");
    voc->setRemark("Remark 2");

        
    les2 = new Lesson(les);
    voc = new Vocable(les2);
    voc->setWord("Word of 1st Vocable in les2");
    voc->setRemark("Remark 3");


    vocab.resize(200, 200);
    app.setMainWidget(&vocab);

    vocab.show();
    return app.exec();
}
