/*
 *  test/test2.cpp
 *  2002-05-27
 *
 *  voctrain - a vocabulary trainer for linux and windows
 *  Copyright (C) 2002  Andreas Dangel <a.dangel@gmx.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "vocabularyparser.h"
#include "vocabulary.h"
#include "lesson.h"
#include "vocable.h"

#include <qapplication.h>
//include <qfile.h>
//include <qtextstream.h>
#include <qstring.h>

#include <iostream>

int main(int argc, char** argv)
{
    if (argc < 3) {
        cerr << "Syntax: " << argv[0] << " in-file.xml out-file.xml" << endl;
        return 1;
    }

    QApplication app (argc, argv);

    cerr << "***vocab creating" << endl;
    Vocabulary vocab;

    cerr << "***vocab loadFromFile(" << argv[1] << ") starting" << endl;
    vocab.loadFromFile(argv[1]);
    cerr << "***vocab load complete" << endl;

    cerr << "***returned to main program" << endl;

    cerr << "***saving XML-Code to " << argv[2] << endl;

    vocab.saveToFile(argv[2]);

    cerr << "***saving done" << endl;

    vocab.resize(300, 200);
    
    app.setMainWidget(&vocab);

    vocab.show();
    return app.exec();
}
