/*
 *  vocabulary.h
 *  2002-05-27
 *
 *  voctrain - a vocabulary trainer for linux and windows
 *  Copyright (C) 2002  Andreas Dangel <a.dangel@gmx.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef _VOCABULARY_H_
#define _VOCABULARY_H_



// verwendet die qt-Library 2.3 von trolltech.com
#include <qstring.h>
#include <qlistview.h>
#include <qwidget.h>


/**
 * Klasse     : Vocabulary
 * Summary    : Reprsentiert eine ganze Vokabel-Datei.
 * Description: Die Klasse Vocabulary wird von QListView abgeleitet und
 *     kann dann also ein solches Objekt sehr leicht verwendet werden.
 */
class Vocabulary : public QListView
{
    public:
        /**
         * Konstruktor: erstellt ein leeres Objekt.
         */
        Vocabulary(QWidget * parent = 0, const char * name = 0);

        /**
         * Destruktor: keine Funktion/Aufgabe
         */
        ~Vocabulary();

        
        /**
         * Verndert das Attribut aTitle.
         */
        void setTitle(const QString& s);

        /**
         * Verndert das Attribut aDescription.
         */
        void setDescription(const QString& s);

        /**
         * Verndert das Attribut aDate.
         */
        void setDate(const QString& s);

        /**
         * Verndert das Attribut aAuthor.
         */
        void setAuthor(const QString& s);


        /**
         * Gibt aTitle zurck.
         */
        const QString& getTitle();

        /**
         * Gibt aDescription zurck.
         */
        const QString& getDescription();

        /**
         * Gibt aDate zurck.
         */
        const QString& getDate();

        /**
         * Gibt aAuthor zurck.
         */
        const QString& getAuthor();


        /**
         * Erstellt einen XML-Code.
         */
        const QString& toXML(int indent = 0);

        /**
         * Ldt einen XML-Code und erstellt entsprechende Vocable- und
         * Lesson-Objekte.
         */
        void parseXML(const QString& s);

        /**
         * Ldt eine Datei und parst diese.
         */
        void loadFromFile(const QString& s);

        /**
         * Speichert die reprsentierten Daten in eine Datei.
         */
        void saveToFile(const QString& s);

    private:
        /** Titel */
        QString aTitle;
        /** Beschreibung */
        QString aDescription;
        /** Datum */
        QString aDate;
        /** Autor */
        QString aAuthor;

        /** XML */
        QString aXML;
};

#endif _VOCABULARY_H_
