/*
 *  src/vocabularyparser.cpp
 *  2002-05-27
 *
 *  voctrain - a vocabulary trainer for linux and windows
 *  Copyright (C) 2002  Andreas Dangel <a.dangel@gmx.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "vocabularyparser.h"
#include "vocabulary.h"
#include "lesson.h"
#include "vocable.h"

#include <qstring.h>


/**
 * Konstruktor: Initialisiert das bergegebene Vocabulary-Objekt
 */
VocabularyParser::VocabularyParser(Vocabulary * v)
{
    aVocabulary = v;
    aVocabulary->setTitle("");
    aVocabulary->setDescription("");
    aVocabulary->setDate("");
    aVocabulary->setAuthor("");
    aVocabulary->clear();

    aLesson = NULL;
}

/**
 * Destruktor: keine Funktion/Aufgabe
 */
VocabularyParser::~VocabularyParser() { }


/**
 * Ereignisse
 */
bool VocabularyParser::startDocument()
{
    return true;
}

bool VocabularyParser::startElement(const QString&, const QString&,
                                    const QString& qName,
                                    const QXmlAttributes& atts)
{
    if (qName == "Vocabulary") {
        aElement = eVocabulary;
    } else if (qName == "TitleOfVocabulary") {
        aElement = eTitleOfVocabulary;
    } else if (qName == "Description") {
        aElement = eDescription;
    } else if (qName == "Date") {
        aElement = eDate;
    } else if (qName == "Author") {
        aElement = eAuthor;
    } else if (qName == "Lesson") {
        aElement = eLesson;
    } else if (qName == "TitleOfLesson") {
        aElement = eTitleOfLesson;
    } else if (qName == "Vocable") {
        aElement = eVocable;
    } else if (qName == "Word") {
        aElement = eWord;
    } else if (qName == "Translation") {
        aElement = eTranslation;
    } else if (qName == "Remark") {
        aElement = eRemark;
    } else {
        aElement = eNone;
    }

    if (aElement == eLesson) {
        /** ############ BUG !!!! #############
         * Die Verschachtelung von <Lesson> wird nicht
         * funktionieren!
         */
 
 
        /* Fall 1: aLesson == NULL:
         *       -> Neue Lesson erstellen und Vocabulary hinzufgen!
         */
        if (aLesson == NULL) {
            aLesson = new Lesson(aVocabulary);
        } else {
        /* Fall 2: aLesson != NULL:
         *      -> aLessonParent = aLesson
         *      -> Neue Lesson in aLesson erstellen und aLessonParent hinzufgen         */
            Lesson * aLessonParent = aLesson;
            aLesson = new Lesson(aLessonParent);
        }
 
    } else if (aElement == eVocable) {
        if (aLesson != NULL) {
            aVocable = new Vocable(aLesson);
        }
    } else if (aElement == eWord) {
        if (aVocable != NULL) {
            for (int i = 0; i < atts.length(); i++)
            {
                if (atts.qName(i) == "type") {
                    if (atts.value(i) == "noun") {
                        aVocable->setType(Vocable::eType_Noun);
                    } else if (atts.value(i) == "verb") {
                        aVocable->setType(Vocable::eType_Verb);
                    } else if (atts.value(i) == "adjective") {
                        aVocable->setType(Vocable::eType_Adjective);
                    } else if (atts.value(i) == "pronoun") {
                        aVocable->setType(Vocable::eType_Pronoun);
                    } else if (atts.value(i) == "invariable") {
                        aVocable->setType(Vocable::eType_Invariable);
                    } else {
                        aVocable->setType(Vocable::eType_Other);
                    }
                }
            }
        }
    }
 
    return true;
}
 
bool VocabularyParser::endElement(const QString&, const QString&,
                                  const QString& qName)
{
    aElement = eNone;
 
    if (qName == "Lesson") {
        aLesson = NULL;
    }
 
    return true;
}

bool VocabularyParser::characters(const QString& ch)
{
    switch(aElement)
    {
        case eTitleOfVocabulary:
            aVocabulary->setTitle(ch);
            break;
        case eTitleOfLesson:
            aLesson->setTitle(ch);
            break;
        case eWord:
            aVocable->setWord(ch);
            break;
        case eTranslation:
            aVocable->getTranslations().append(ch);
            break;
        case eRemark:
            aVocable->setRemark(ch);
            break;
        default:
            ;
    }
    return true;
}
