/*
 *  vocabularyparser.h
 *  2002-05-27
 *
 *  voctrain - a vocabulary trainer for linux and windows
 *  Copyright (C) 2002  Andreas Dangel <a.dangel@gmx.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef _VOCABULARYPARSER_H_
#define _VOCABULARYPARSER_H_

#include "vocable.h"
#include "lesson.h"
#include "vocabulary.h"

#include <qxml.h>
#include <qstring.h>


/**
 * Klasse: VocabularyParser.
 * Diese Klasse parst XML-Daten und erstellt Objekte
 * der Klassen Lesson und Vocable.
 */
class VocabularyParser : public QXmlDefaultHandler
{
    public:
        /**
         * Konstruktor: v ist das Vocabulary-Objekt, in dem Vokabeln
         * erstellt werden sollen.
         */
        VocabularyParser(Vocabulary * v);

        /**
         * Destruktor: keine Funktion/Aufgabe
         */
        ~VocabularyParser();

        /**
         * Aufzhlung von Elementen, um festzuhalten, wo wir uns gerade
         * befinden.
         */
        enum Elements
        {
            eVocabulary = 0,
            eTitleOfVocabulary,
            eDescription,
            eDate,
            eAuthor,
            eLesson,
            eTitleOfLesson,
            eVocable,
            eWord,
            eTranslation,
            eRemark,
            eNone
        };


        /** Ereignisse */
        bool startDocument();
        bool startElement(const QString&, const QString&, const QString&,
                          const QXmlAttributes&);
        bool endElement(const QString&, const QString&, const QString&);
        bool characters(const QString& ch);

    private:
        /* Zeiger, die auf die aktuellen Objekte zeigen */
        Vocabulary * aVocabulary;
        Lesson * aLesson;
        Vocable * aVocable;
        /* aktuelles Element */
        Elements aElement;
};

#endif _VOCABULARYPARSER_H_
