<!--
    vocabulary.xsl     0.9     2001/10/25

    Copyright (c) 2001 Andreas Dangel <a.dangel@gmx.de>


    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
-->

<!--
    Funktioniert mit maximal 3 Verschachtelungen von <Lesson>
-->

<xsl:stylesheet xmlns:xsl="http://www.w3.org/TR/WD-xsl">
<xsl:template>
<xsl:for-each select="Vocabulary">

    <H1><xsl:value-of select="TitleOfVocabulary"/></H1>

    <DL>
        <DT>Description</DT>
            <DD><xsl:value-of select="Description"/></DD>
        <DT>Date</DT>
            <DD><xsl:value-of select="Date"/></DD>
        <DT>Author</DT>
            <DD><xsl:value-of select="Author"/></DD>
    </DL>


    <xsl:for-each select="Lesson">
        <H2><xsl:value-of select="TitleOfLesson"/></H2>

        <TABLE BORDER="1">
            <TR><TH>Word</TH><TH>Translations</TH><TH>Remark</TH></TR>
            <xsl:for-each select="Vocable">
                <TR><TD><xsl:value-of select="Word"/></TD>
                <TD><xsl:for-each select="Translation"><xsl:value-of/>, </xsl:for-each></TD>
                <TD><xsl:value-of select="Remark"/></TD>
                </TR>
            </xsl:for-each>
        </TABLE>


        <xsl:for-each select="Lesson">
            <H2><xsl:value-of select="TitleOfLesson"/></H2>

            <TABLE BORDER="1">
                <TR><TH>Word</TH><TH>Translations</TH><TH>Remark</TH></TR>
                <xsl:for-each select="Vocable">
                    <TR><TD><xsl:value-of select="Word"/></TD>
                    <TD><xsl:for-each select="Translation"><xsl:value-of/>, </xsl:for-each></TD>
                    <TD><xsl:value-of select="Remark"/></TD>
                    </TR>
                </xsl:for-each>
            </TABLE>


            <xsl:for-each select="Lesson">
                <H2><xsl:value-of select="TitleOfLesson"/></H2>

                <TABLE BORDER="1">
                    <TR><TH>Word</TH><TH>Translations</TH><TH>Remark</TH></TR>
                    <xsl:for-each select="Vocable">
                        <TR><TD><xsl:value-of select="Word"/></TD>
                        <TD><xsl:for-each select="Translation"><xsl:value-of/>, </xsl:for-each></TD>
                        <TD><xsl:value-of select="Remark"/></TD>
                        </TR>
                    </xsl:for-each>
                </TABLE>
            </xsl:for-each>

        </xsl:for-each>
    </xsl:for-each>
</xsl:for-each>
</xsl:template>
</xsl:stylesheet>
